/************************************************************
Copyright 1989,1990 by Tektronix Inc.
Copyright 1989,1990 by The Massachusetts Institute of Technology

                    All Rights Reserved

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the names of MIT and Tektronix not be 
used in advertising or publicity pertaining to distribution of the
software without specific prior written permission.
M.I.T. and Tektronix make no representation about the 
suitability of this software for any purpose. It is provided 
"as is" without any express or implied warranty.

MIT AND TEKTRONIX DISCLAIM ALL WARRANTIES WITH REGARD TO  THIS  
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL MIT OR
TEKTRONIX BE LIABLE FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA  OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

/* $Header: VEXctrlstr.h,v 1.3 90/03/05 13:45:48 scotthe Exp $ */

#ifndef _VEXCTRLSTR_H_
#define _VEXCTRLSTR_H_


typedef struct {
	unsigned long		normalCapability;
	XVEXFraction		normalSpeed;
	unsigned long		slowCapability;
	XVEXFractionRange	slowSpeed;
	unsigned long		fastCapability;
	XVEXFractionRange	fastSpeed;
} XVEXCtrlPlay;

typedef struct {
	unsigned long		directive;
	unsigned long		frameA;
	unsigned long		frameB;
	XVEXFraction		speed;
} XVEXSettingPlay;

typedef struct {
	unsigned long		directive;
	unsigned long		frameA;
} XVEXSettingFreezeFrame;

typedef struct {
	unsigned long		Capability;
} XVEXCtrlCapability;

typedef struct {
	unsigned long		directive;
} XVEXSettingDirective;

/*
 * Settings corresponding to Galatea command set
 */

/*
 * Std commands: No Arguments:
 *	INDEX_ON, INDEX_OFF, INDEX_TOGGLE, A1_ON, A1_OFF, A2_ON, A2_OFF,
 *	LOAD, UNLOAD, EJECT, INDEX_TOGGLE
 */
/* XXX Note pioneer does not implement EJECT */

/* 
 * Optional commands 
 *	No Arguments: RESET, 
 */

typedef struct {
    long	frame1;
} XVEXSettingSearch;

typedef struct {
    long	frame1;
    long	frame2;
    long	speed;
} XVEXSettingSegPlay;

/*
 * Note this is not valid for a ChangeVideoControls, only valid for
 * QueryVideoControls
 */
typedef struct {
    long	frame1;
} XVEXSettingGetFrame;

typedef struct {
    long	num;
} XVEXSettingVarSpeed;

typedef struct {
    long	num;
} XVEXSettingJog;

/* XXX
 * Not implemented: XVEXSettingRecord
 */

#endif /* _VEXCTRLSTR_H_ */
