/* $Header: VEXSetting.c,v 1.5 90/04/19 11:53:35 scotthe Exp $ */
/************************************************************
Copyright 1989,1990 by Tektronix Inc.
Copyright 1989,1990 by The Massachusetts Institute of Technology

                    All Rights Reserved

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the names of MIT and Tektronix not be
used in advertising or publicity pertaining to distribution
of the software without specific prior written permission.
M.I.T. and Tektronix make no representation about the 
suitability of this software for any purpose. It is provided 
"as is" without any express or implied warranty.

MIT AND TEKTRONIX DISCLAIM ALL WARRANTIES WITH REGARD TO  THIS  
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL MIT OR
TEKTRONIX BE LIABLE FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA  OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

#include "Xlibint.h"
#include "Xutil.h"
#include "VEXlib.h"
#include "VEXproto.h"


/*
 * Create a list of XVEXSettings which correspond one-to-one with the input list
 * of XVEXControls.  Constant data is copied from the XVEXControls to the 
 * XVEXSettings:
 *	name, format, length
 * Space is allocated for value data and the list pointer is set in the
 * XVEXSettings structures.
 */
XVEXSetting *XVEXCreateSettingList(vid, controlList, nControl)
    VideoID vid;
    XVEXControl controlList[];
    unsigned long nControl;
{
    XVEXSetting *settings_return;
    XVEXSetting *settings_cur;
    char *settings_data_cur, *settings_data;
    int nBytes;
    int i;

    /* 
     * XXX
     * This implementation works only if sizeof(short) == CARD16 and
     * sizeof(long) == CARD32.
     */
    nBytes = nControl * sizeof(XVEXSetting);
    for (i=0; i<nControl; i++)
	nBytes += (controlList[i].setting_length + 3) & ~0x3;
    settings_cur = settings_return = (XVEXSetting *)Xmalloc(nBytes);
    settings_data_cur = settings_data = 
	    (char *)(settings_return + nControl);

    while ((char *)settings_cur < settings_data) {
	settings_cur->name = controlList->name;
	settings_cur->id = vid;
	settings_cur->format = controlList->setting_format;
	settings_cur->length = controlList->setting_length;
	switch (controlList->setting_format) {
	    case 16:
		settings_cur->value.p16list = (short *) settings_data_cur;
		break;
	    case 32:
		settings_cur->value.p32list = (long *) settings_data_cur;
		break;
	    default:
		settings_cur->value.p8list = settings_data_cur;
		break;
	}
	settings_data_cur += (controlList->setting_length + 3) & ~0x3;
	settings_cur++;
	controlList++;
    }

    return (settings_return);
}
