/************************************************************
Copyright 1989,1990 by Tektronix Inc.
Copyright 1989,1990 by The Massachusetts Institute of Technology

                    All Rights Reserved

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the names of MIT and Tektronix not be 
used in advertising or publicity pertaining to distribution of the
software without specific prior written permission.
M.I.T. and Tektronix make no representation about the 
suitability of this software for any purpose. It is provided 
"as is" without any express or implied warranty.

MIT AND TEKTRONIX DISCLAIM ALL WARRANTIES WITH REGARD TO  THIS  
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL MIT OR
TEKTRONIX BE LIABLE FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA  OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

/* $Header: VEXlibint.h,v 1.3 90/04/16 16:13:41 scotthe Exp $ */

#ifndef _VEXLIBINT_H_
#define _VEXLIBINT_H_

#include "Xlib.h"
#include "VEXlib.h"

/*
 * VEX library internal function declarations.
 */

extern XExtCodes *_VEXCheckExtension ();
extern void _VEXFreeVideoInfo();
extern Status _VEXQueryVideo();

/* 
 * Clients never get to see these unless we write macros which use it
 */
typedef struct {
	char		*matrix;
	long		index;
} CurrentState;

typedef struct {
	int		screen;
	int		input_overlap;
	int		capture_overlap;
	int		io_overlap;
	unsigned long	query_video_time;
	unsigned long	video_connect_time;
	int		ndepths;
	Depth  		 *depths;
	int		nvin;
	XVEXVin		*vin;
	int		nvout;
	XVEXVout		*vout;
	int		nvdev;
	XVEXVdev		*vdev;
	CurrentState	cur_state;
	int		nadjacency_matrices;
	int		nadj_mat_col;
	unsigned char	**adj_matrix;
	int		ntransitions;
	XVEXTransition *transitions;
} VideoInfo;


#endif /* _VEXLIBINT_H_ */
