/************************************************************
Copyright 1989,1990 by Tektronix Inc.
Copyright 1989,1990 by The Massachusetts Institute of Technology

                    All Rights Reserved

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the names of MIT and Tektronix not be
used in advertising or publicity pertaining to distribution
of the software without specific prior written permission.
M.I.T. and Tektronix make no representation about the 
suitability of this software for any purpose. It is provided 
"as is" without any express or implied warranty.

MIT AND TEKTRONIX DISCLAIM ALL WARRANTIES WITH REGARD TO  THIS  
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL MIT OR
TEKTRONIX BE LIABLE FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA  OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

#include "Xlibint.h"
#include "VEXlibint.h"
#include "Xutil.h"
#include "VEXlib.h"
#include "VEXproto.h"

XVEXCaptureGraphics(dpy, src, dest, cmap, src_x, src_y, srcWidth, srcHeight,
dst_x, dst_y, dstWidth, dstHeight, fullMotion, priority, subWindowMode)
    Display *dpy;
    Drawable src;
    VideoOut dest;
    Colormap cmap;
    int src_x, src_y;
    unsigned int srcWidth, srcHeight;
    int dst_x, dst_y;
    unsigned int dstWidth, dstHeight;
    Bool fullMotion;
    int priority;
    int subWindowMode;
{
    register xCaptureGraphicsReq   *req;
    XExtCodes			    *codes;

    if (!(codes = _VEXCheckExtension (dpy)))
	return;
    LockDisplay (dpy);
    GetReq (CaptureGraphics, req);
    req->reqType = codes->major_opcode;
    req->videoReqType = X_CaptureGraphics;
    req->src = src;
    req->dest = dest;
    req->cmap = cmap;
    req->srcX = src_x;
    req->srcY = src_y;
    req->srcWidth = srcWidth;
    req->srcHeight = srcHeight;
    req->dstX = dst_x;
    req->dstY = dst_y;
    req->dstWidth = dstWidth;
    req->dstHeight = dstHeight;
    req->fullMotion = fullMotion;
    req->priority = priority;
    req->subWindowMode = subWindowMode;

    UnlockDisplay (dpy);
    SyncHandle ();
}
