/* $Header: XVEXFrac.c,v 1.1 90/04/17 16:08:39 toddb Exp $ */
#include "VEXlib.h"

Bool XVEXMatchFraction (given, range, lower, higher)
XVEXFraction *given;
XVEXFractionRange *range;
XVEXFraction *lower;
XVEXFraction *higher;
{
   long min_num, max_num, min_den, max_den, try_num, try_den, try_diff;
   register int j0;
   Bool exact_num, exact_den;

/* Find minimum and maximum numerators and denominators */
/* Check for exact fit too */
   exact_num = False;
/* Linear range numerator */
   if (range->num_type == VEXLinearRange) {
      min_num = range->num_base;
      max_num = range->num_limit;
      if (given->numerator >= min_num && given->numerator <= max_num &&
         (given->numerator - min_num) % range->num_increment == 0) {
         exact_num = True;
      }
   }
/* Geometric range numerator */
   else {
      min_num = 1;
      for (j0 = 0; j0 < range->num_increment; j0++) {
         min_num *= range->num_base;
      }
      if (given->numerator == min_num) {
         exact_num = True;
      }
      max_num = min_num;
      while (j0 < range->num_limit) {
         max_num *= range->num_base;
         if (given->numerator == max_num) {
            exact_num = True;
         }
         j0++;
      }
   }
/* Linear range denominator */
   exact_den = False;
   if (range->denom_type == VEXLinearRange) {
      min_den = range->denom_base;
      max_den = range->denom_limit;
      if (given->denominator >= min_den && given->denominator < max_den &&
         (given->denominator - min_den) % range->denom_increment == 0) {
         exact_den = True;
      }
   }
/* Geometric range denominator */
   else {
      min_den = 1;
      for (j0 = 0; j0 < range->denom_increment; j0++) {
         min_den *= range->denom_base;
      }
      if (given->denominator == min_den) {
         exact_den = True;
      }
      max_den = min_den;
      while (j0 < range->denom_limit) {
         max_den *= range->denom_base;
         if (given->denominator == max_den) {
            exact_den = True;
         }
         j0++;
      }
   }

/* Return the given fraction if it is an exact fit */
   if (exact_num && exact_den) {
      lower->numerator = given->numerator;
      lower->denominator = given->denominator;
      higher->numerator = given->numerator;
      higher->denominator = given->denominator;
      return True;
   }

/* Squeeze the lower and higher fractions around the given fraction */
   lower->numerator = min_num;
   lower->denominator = max_den;
   higher->numerator = max_num;
   higher->denominator = min_den;

   try_num = min_num;
   while (try_num <= max_num) {
      try_den = min_den;
      while (try_den <= max_den) {
         try_diff = try_num * given->denominator - given->numerator * try_den;
/* Return numerically equivalent fraction */
         if (try_diff == 0) {
            lower->numerator = try_num;
            lower->denominator = try_den;
            higher->numerator = try_num;
            higher->denominator = try_den;
            return True;
         }
/* If denominator is too big, try-fraction is smaller than given-fraction */
/* See if the lower fraction can be moved up, exit denominator loop */
         else if (try_diff < 0) {
            if (lower->numerator * try_den < try_num * lower->denominator) {
               lower->numerator = try_num;
               lower->denominator = try_den;
            }
            try_den = max_den + 1;
         }
/* See if the higher fraction can be moved down */
         else {
            if (higher->numerator * try_den > try_num * higher->denominator) {
               higher->numerator = try_num;
               higher->denominator = try_den;
            }
/* Increment the denominator, linear */
            if (range->denom_type == VEXLinearRange) {
               try_den += range->denom_increment;
            }
/* Increment the denominator, geometric */
            else {
               try_den *= range->denom_base;
            }
         }
      }
/* See if the numerator is too big yet (exit the routine) */
      if (try_num * given->denominator > given->numerator * max_den) {
         return False;
      }
/* Increment the numerator, linear */
      if (range->num_type == VEXLinearRange) {
         try_num += range->num_increment;
      }
/* Increment the numerator, geometric */
      else {
         try_num *= range->num_base;
      }
   }
/* Return the closest lower and higher value fractions */
   return False;
}
