/* $Header: swapvex.c,v 1.9 90/04/13 15:18:13 toddb Exp $ */
/************************************************************
Copyright 1989,1990 by Tektronix Inc.
Copyright 1989 by The Massachusetts Institute of Technology

                    All Rights Reserved

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the names of MIT and Tektronix not be
used in advertising or publicity pertaining to distribution 
of the software without specific prior written permission.
M.I.T. and Tektronix make no representation about the 
suitability of this software for any purpose. It is provided 
"as is" without any express or implied warranty.

MIT AND TEKTRONIX DISCLAIM ALL WARRANTIES WITH REGARD TO  THIS  
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL MIT OR
TEKTRONIX BE LIABLE FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA  OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

#include "X.h"
#define NEED_EVENTS
#include "Xproto.h"
#include "misc.h"
#include "dixstruct.h"
#include "VEX.h"
#include "VEXproto.h"
#include "videostr.h"

void
SVideoControlEvent(from, to)
    xVideoControlEvent *from, *to;
{
    to->type = from->type;
    cpswaps (from->sequenceNumber, to->sequenceNumber);
    cpswapl (from->vid, to->vid);
    cpswapl (from->name, to->name);
    cpswapl (from->time, to->time);
    to->state = from->state;
}

void
SVideoViolationEvent(from, to)
    xVideoViolationEvent *from, *to;
{
    to->type = from->type;
    cpswaps (from->sequenceNumber, to->sequenceNumber);
    cpswapl (from->id, to->id);
    cpswapl (from->vid, to->vid);
    cpswapl (from->time, to->time);
    cpswaps (from->actionMask, to->actionMask);
    to->state = from->state;
}

void
SVideoSyncEvent(from, to)
    xVideoSyncEvent *from, *to;
{
    to->type = from->type;
    cpswaps (from->sequenceNumber, to->sequenceNumber);
    cpswapl (from->id, to->id);
    cpswapl (from->vid, to->vid);
    cpswapl (from->time, to->time);
    to->state = from->state;
}

void
SVideoOverrideEvent(from, to)
    xVideoOverrideEvent *from, *to;
{
    to->type = from->type;
    cpswaps (from->sequenceNumber, to->sequenceNumber);
    cpswapl (from->id, to->id);
    cpswapl (from->vid, to->vid);
    cpswapl (from->time, to->time);
}

void
SVideoChangeEvent(from, to)
    xVideoChangeEvent *from, *to;
{
    to->type = from->type;
    cpswaps (from->sequenceNumber, to->sequenceNumber);
    cpswapl (from->screen, to->screen);
    cpswapl (from->vdev, to->vdev);
    cpswapl (from->time, to->time);
    to->state = from->state;
}

#ifdef IMPLEMENTED
void
SVideoConnectivityStateEvent(from, to)
    xVideoConnectivityStateEvent *from, *to;
{
    to->type = from->type;
    cpswaps (from->sequenceNumber, to->sequenceNumber);
    cpswapl (from->screen, to->screen);
    cpswapl (from->newState, to->newState);
    cpswapl (from->time, to->time);
}
#endif /* IMPLEMENTED */

void
SVideoRequestEvent(from, to)
    xVideoRequestEvent *from, *to;
{
    to->type = from->type;
    cpswaps (from->sequenceNumber, to->sequenceNumber);
    cpswapl (from->src, to->src);
    cpswapl (from->dst, to->dst);
    cpswapl (from->cmap, to->cmap);
    cpswaps (from->srcx, to->srcx);
    cpswaps (from->srcy, to->srcy);
    cpswaps (from->dstx, to->dstx);
    cpswaps (from->dsty, to->dsty);
    cpswaps (from->srcWidth, to->srcWidth);
    cpswaps (from->srcHeight, to->srcHeight);
    cpswaps (from->dstWidth, to->dstWidth);
    cpswaps (from->dstHeight, to->dstHeight);
}

void
SVideoRequestAddendumEvent(from, to)
    xVideoRequestAddendumEvent *from, *to;
{
    to->type = from->type;
    cpswaps (from->sequenceNumber, to->sequenceNumber);
    cpswapl (from->time, to->time);
    to->request = from->request;
    to->redirect = from->redirect;
    to->fullMotion = from->fullMotion;
    to->priority = from->priority;
    to->subwindowMode = from->subwindowMode;
}


#ifdef R3
/* Macros needed for byte-swapping, copied from swapreq.c.  Really
   should be in a header file somewhere. */

#define LengthRestB(stuff) \
    (((unsigned long)stuff->length << 2) - sizeof(*stuff))

#define LengthRestL(stuff) \
    ((unsigned long)stuff->length - (sizeof(*stuff) >> 2))

#define SwapRestL(stuff) \
    SwapLongs((long *)(stuff + 1), LengthRestL(stuff))
#endif R3


int
SProcQueryVideo (client)
    register ClientPtr	client;
{
    register char   n;
    REQUEST (xQueryVideoReq);

    swaps (&stuff->length, n);
    swapl (&stuff->window, n);
    return ProcQueryVideo (client);
}

int
SProcCreateVideo (client)
    register ClientPtr	client;
{
    register char   n;
    REQUEST (xCreateVideoReq);

    swaps (&stuff->length, n);
    swapl (&stuff->id, n);
    swapl (&stuff->reference, n);
    return ProcCreateVideo (client);
}

int
SProcRenderVideo (client)
    register ClientPtr	client;
{
    register char   n;
    REQUEST (xRenderVideoReq);

    swaps (&stuff->length, n);
    swapl (&stuff->src, n);
    swapl (&stuff->dest, n);
    swaps (&stuff->srcX, n);
    swaps (&stuff->srcY, n);
    swaps (&stuff->dstX, n);
    swaps (&stuff->dstY, n);
    swaps (&stuff->srcWidth, n);
    swaps (&stuff->srcHeight, n);
    swaps (&stuff->dstWidth, n);
    swaps (&stuff->dstHeight, n);
    return ProcRenderVideo (client);
}

int
SProcCaptureGraphics (client)
    register ClientPtr	client;
{
    register char   n;
    REQUEST (xCaptureGraphicsReq);

    swaps (&stuff->length, n);
    swapl (&stuff->src, n);
    swapl (&stuff->dest, n);
    swapl (&stuff->cmap, n);
    swaps (&stuff->srcX, n);
    swaps (&stuff->srcY, n);
    swaps (&stuff->dstX, n);
    swaps (&stuff->dstY, n);
    swaps (&stuff->srcWidth, n);
    swaps (&stuff->srcHeight, n);
    swaps (&stuff->dstWidth, n);
    swaps (&stuff->dstHeight, n);
    return ProcCaptureGraphics (client);
}

int
SProcStopVideo (client)
    register ClientPtr	client;
{
    register char   n;
    REQUEST (xStopVideoReq);

    swaps (&stuff->length, n);
    SwapRestL(stuff);
    return ProcStopVideo (client);
}


int
SProcQueryVideoControls (client)
    register ClientPtr	client;
{
    register char   n;
    REQUEST (xQueryVideoControlsReq);

    swaps (&stuff->length, n);
    swapl (&stuff->vid, n);
    SwapRestL(stuff);
    return ProcQueryVideoControls (client);
}

int
SProcChangeVideoControls (client)
    register ClientPtr	client;
{
    register char   n;
    xSetting		*settingList;

    REQUEST (xChangeVideoControlsReq);

    swaps (&stuff->length, n);
    swapl (&stuff->nSettings, n);
    settingList = (xSetting *) (stuff + 1);
    SwapSettingList(stuff->nSettings, settingList, FALSE);

    return ProcChangeVideoControls (client);
}

#ifdef IMPLEMENTED
int
SProcChangeConnectivity (client)
    register ClientPtr	client;
{
    register char   n;
    REQUEST (xChangeConnectivityReq);

    swaps (&stuff->length, n);
    swapl (&stuff->time, n);
    swapl (&stuff->oldState, n);
    swapl (&stuff->newState, n);
    return ProcChangeConnectivity (client);
}

int
SProcChangeOwnership (client)
    register ClientPtr	client;
{
    register char   n;
    REQUEST (xChangeOwnershipReq);

    swaps (&stuff->length, n);
    SwapRestL(stuff);
    return ProcChangeOwnership (client);
}
#endif /* IMPLEMENTED */

int
SProcSelectVideoEvents (client)
    register ClientPtr	client;
{
    register char   n;
    REQUEST (xSelectVideoEventsReq);

    swaps (&stuff->length, n);
    swapl (&stuff->id, n);
    swapl (&stuff->mask, n);
    return ProcSelectVideoEvents (client);
}



void
SwapSettingList(nValue, settingList, fReply)
    unsigned long nValue;		/* number of values to swap */
    xSetting	*settingList;		/* list of xSetting structs */
    int		fReply;			/* Is SettingList is part of a reply? */
{
    register char n;
    register int i;
    int length;

    for (i = 0; i < nValue; i++) {
	if (fReply) {
	    length = settingList->length;
	    swapl(&settingList->length, n);
	} else {
	    swapl(&settingList->length, n);
	    length = settingList->length;
	}
	swapl(&settingList->name, n);
	swapl(&settingList->id, n);
	switch (settingList->format) {
	    case 8:
		break;
	    case 16:
		SwapShorts((short *)(settingList + 1), length >> 1);
		break;
	    case 32:
		SwapLongs((long *)(settingList + 1), length >> 2);
		break;
	}
	settingList = (xSetting *)(((char *)settingList) + sizeof(xSetting) +
				   ((length + 3) & ~0x3));
    }
}

void
SwapFraction(pFraction)
    xFraction  *pFraction;
{
    SwapLongs((long *)(pFraction), sizeof(xFraction) >> 2);
}

void
SwapFractionRange(pFractionRange)
    xFractionRange  *pFractionRange;
{
    /*
     * This is kinda gross.  An xFractionRange is a bunch of longs
     * followed by 2 CARD8 type fields.
     */
    SwapLongs((long *)(pFractionRange), (sz_xFractionRange - 4) >> 2);
}

void
SwapRectangleRange(pRectangleRange)
    xRectangleRange  *pRectangleRange;
{
    /*
     * This is kinda gross.  An xRectangleRange is a bunch of shorts
     * followed by a CARD8 type field.
     */
    SwapShorts((short *)pRectangleRange, (sz_xRectangleRange - 4) >> 1);
}

void
SQueryVideoControlsReply(pClient, nbytes, pRep)
    ClientPtr pClient;
    int nbytes;
    xQueryVideoControlsReply *pRep;
{
    register int n;

    SwapSettingList(pRep->nSettings, (xSetting *)(pRep +1), TRUE);
    swaps(&pRep->sequenceNumber, n);
    swapl(&pRep->length, n);
    swaps(&pRep->nSettings, n);

    (void)WriteToClient(pClient, nbytes, (char *) pRep);
    
}

void
SwapDepths(ppDepth, nDepths)
    xDepth **ppDepth;
    int nDepths;
{
    register int n;
    int i, k;
    xVisualType *pVis;

    for (i=0; i<nDepths; i++) {
	pVis = (xVisualType *) (*ppDepth + 1);
	for(k = 0; k < (*ppDepth)->nVisuals; k++){
	    swapl(pVis->visualID, n);
	    swaps(pVis->colormapEntries, n);
	    swapl(pVis->redMask, n);
	    swapl(pVis->greenMask, n);
	    swapl(pVis->blueMask, n);
	    pVis++;
	}
	swapl((*ppDepth)->nVisuals, n)
	*ppDepth = (xDepth *)pVis;
    }
}

void
SwapRenderModels(ppRenderModel, nAllowedDepths)
    xRenderModel **ppRenderModel;
    int nAllowedDepths;
{
    register int n;
    int i;

    for (i=0; i<nAllowedDepths; i++) {
	swapl((*ppRenderModel)->visualid, n);
	swapl((*ppRenderModel)->redMask, n);
	swapl((*ppRenderModel)->greenMask, n);
	swapl((*ppRenderModel)->blueMask, n);
	(*ppRenderModel)++;
    }
}

void
SwapVideoGeometries(ppVideoGeometry, nGeom)
    xVideoGeometry **ppVideoGeometry;
    int nGeom;
{
    xVideoGeometry *pVideoGeometry = *ppVideoGeometry;
    xPlacement *pPlacement;
    register int n;
    int i, k;

    for (i=0; i < nGeom; i++) {
	pPlacement = (xPlacement *) (pVideoGeometry + 1);
	for (k=0; k < pVideoGeometry->nPlacement; k++) {
	    SwapFraction(&(pPlacement->frameRate));
	    SwapRectangleRange(&(pPlacement->src));
	    SwapRectangleRange(&(pPlacement->dest));
	    SwapFractionRange(&(pPlacement->xScale));
	    SwapFractionRange(&(pPlacement->yScale));
	    pPlacement++;
	}
	SwapFraction(&(pVideoGeometry->frameRate));
	SwapFraction(&(pVideoGeometry->fieldRate));
	swaps(pVideoGeometry->width, n);
	swaps(pVideoGeometry->height, n);
	swaps(pVideoGeometry->concurrentUse, n);
	swapl(pVideoGeometry->referenceId, n);
	swapl(pVideoGeometry->nPlacement, n);
	pVideoGeometry = (xVideoGeometry *)pPlacement;
    }
    *ppVideoGeometry = pVideoGeometry;
}

void
SwapControls(ppControl, nControl)
    xControl **ppControl;
    unsigned long  nControl;
{
    xControl *pControl = *ppControl;
    register int n;
    int i;
    int length;

    for (i=0; i < nControl; i++) {
	length = pControl->descriptionLength;
	switch (pControl->descriptionFormat) {
	    case 8:
		break;
	    case 16:
		SwapShorts((short *)(pControl + 1), length >> 1);
		break;
	    case 32:
		SwapLongs((long *)(pControl + 1), length >> 2);
		break;
	}
	swapl(&pControl->name, n);
	swapl(&pControl->id, n);
	swapl(&pControl->settingLength, n);
	swapl(&pControl->descriptionLength, n);
	pControl = (xControl *)(((char *)pControl) + sizeof(xControl) +
			        ((length + 3) & ~0x3));
    }
    *ppControl = pControl;

}


void
SQueryVideoReply(pClient, nBytesData, pRep, preplyData)
    ClientPtr pClient;
    int nBytesData;			/* Size of Reply data */
    xQueryVideoReply *pRep;		/* Reply structure */
    pointer preplyData;			/* Reply data */
{
    register int n;
    xQueryVideoReply *pRepT;
    int nDepths, nAllowedDepths, nVin, nVout, nVdev;

    nDepths = pRep->nDepths;
    nAllowedDepths = pRep->nAllowedDepths;
    nVin = pRep->nVin;
    nVout = pRep->nVout;
    nVdev = pRep->nVdev;

    /*
     * Swap the reply data structure in place and then write it out.
     * Routines which swap data structures also move the pRepT pointer.
     */

    pRepT = (xQueryVideoReply *)preplyData;

    SwapDepths((xDepth **)&pRepT, nDepths);
    SwapRenderModels((xRenderModel **)&pRepT, nAllowedDepths);
    SwapLongs((long *)pRepT, nVdev);
    pRepT = (xQueryVideoReply *)(((char *)pRepT) + (nVdev << 2));
    SwapVideoGeometries((xVideoGeometry **)&pRepT, nVin);
    SwapVideoGeometries((xVideoGeometry **)&pRepT, nVout);
    /*
     * Skip over VideoInput Models and VideoOutput Models
     */
    pRepT = (xQueryVideoReply *)
		(((char *)pRepT) + ((nVin * nAllowedDepths +3) & ~0x3));
    pRepT = (xQueryVideoReply *)
		(((char *)pRepT) + ((nVout * nAllowedDepths +3) & ~0x3));
    SwapControls((xControl **)&pRepT, pRep->nDeviceControls);
    SwapShorts((short *)pRepT, nVin * (sizeof(xRectangle) >> 1));
    pRepT = (xQueryVideoReply *)(((char *)pRepT) + (nVin * sizeof(xRectangle)));
    /*
     * Skip over Adjacency Matrix
     */
    pRepT = (xQueryVideoReply *) (((char *)pRepT)
		 + ((((nVdev + nVin) * (nVdev + nVout)) +3) & ~0x3)); 
    SwapLongs((long *)pRepT, pRep->nTransitions * 
	      (sizeof(xVideoTransition) >> 2));
    

    swaps(&pRep->sequenceNumber, n);
    swapl(&pRep->length, n);
    swapl(&pRep->time, n);
    swapl(&pRep->nDeviceControls, n);
    swapl(&pRep->nAdjacencyMatrices, n);
    swapl(&pRep->nTransitions, n);

    (void)WriteToClient(pClient, sizeof (xQueryVideoReply), (char *) pRep);
    (void) WriteToClient(pClient, nBytesData, (char *)preplyData);

}

