/* $Header: vexutil.c,v 1.7 90/04/10 12:22:06 scotthe Exp $ */
/************************************************************
Copyright 1989,1990 by Tektronix Inc.

                    All Rights Reserved

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the names of MIT and Tektronix not be
used in advertising or publicity pertaining to distribution 
of the software without specific prior written permission.
M.I.T. and Tektronix make no representation about the 
suitability of this software for any purpose. It is provided 
"as is" without any express or implied warranty.

MIT AND TEKTRONIX DISCLAIM ALL WARRANTIES WITH REGARD TO  THIS  
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL MIT OR
TEKTRONIX BE LIABLE FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA  OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

#define NEED_REPLIES
#define NEED_EVENTS
#include <stdio.h>
#include "X.h"
#include "Xproto.h"
#include "misc.h"
#include "os.h"
#include "windowstr.h"
#include "colormapst.h"
#include "scrnintstr.h"
#include "pixmapstr.h"
#include "extnsionst.h"
#include "gcstruct.h"
#include "dixstruct.h"
#include "resource.h"
#include "opaque.h"
#include "regionstr.h"

#include "VEX.h"
#include "VEXproto.h"
#include "videostr.h"

typedef struct {
    int nDepths;
    DepthPtr pDepths;
} UniqueDepths;

/*
 * Free a list of depth structures created by CreateVideoDepths.
 */
void
FreeDepths(nDepths, pDepths)
    int nDepths;		/* number of depth structures */
    DepthPtr pDepths;		/* list of depth structures */
{
    int i;

    if (!pDepths)
	return;

    for(i=0; i < nDepths; i++) {
	if (pDepths[i].vids)
	    Xfree(pDepths[i].vids);
    }
    Xfree(pDepths);
}


/*
 * Create a list of unique VEX depths/visuals.  Take a list of 
 * depths/visuals that the video hardware supports and make a list of
 * those which are NOT part of the core list for this screen.
 * Fill in numVisuals, visuals, pDepths, and nDepths fields of pVideoScreenRec.
 *
 * Return FALSE if allocation fails, TRUE otherwise.
 */
Bool
CreateVideoDepths(pScreen, pVideoScreenRec, nvideoDepths, videoDepths)
    ScreenPtr pScreen;			/* Screen for video data */
    VideoScreenPtr pVideoScreenRec;	/* video data */
    int nvideoDepths;			/* number of video depths */
    VideoVisual *videoDepths;		/* list of video depths */
{
    int i;
    UniqueDepths newDepths;
    VisualPtr pVis, pvisuals;
    int depth;
    VisualID vid;
    unsigned long GetCoreVid();

    /*
     * VEX may have a list of depths/visuals which come with the video hardware
     * We need to search the core list of depths/visuals (look through the
     * depths/visuals listed in pScreen->allowedDepths) and only put desired
     * depths/visuals into pVideoScreenRec->pDepths if they are not in
     * the core list.
     * Either way, remember the VisualID so that it can be
     * used for the list of RenderModels.
     */

    pVideoScreenRec->visuals = (VisualRec *)NULL;
    pVideoScreenRec->numVisuals = 0;
    pVideoScreenRec->nDepths = 0;
    newDepths.nDepths = 0;
    newDepths.pDepths = (DepthPtr) NULL;

    for (i = 0; i < nvideoDepths; i++) {
	depth = videoDepths[i].depth;
	if (!(IsCoreDepth(pScreen, depth))) {
	    if (!AddNewDepth(pScreen, depth, &newDepths, (VisualRec *)NULL)) {
		return(FALSE);
	    }
	}
	if (pVis = videoDepths[i].pVis) {
	    if (!(vid = GetCoreVid(pScreen, depth, pVis))) {
		if (!AddNewDepth(pScreen, depth, &newDepths, pVis))
		    return(FALSE);
		pVideoScreenRec->numVisuals++;
		pvisuals = (VisualPtr) xrealloc(pVideoScreenRec->visuals, 
			sizeof(VisualRec) * pVideoScreenRec->numVisuals);
		if (!pvisuals) {
		    pVideoScreenRec->numVisuals--;
		    FreeDepths(newDepths.nDepths, newDepths.pDepths);
		    return(FALSE);
		}
		bcopy((char *)pVis, 
		      (char *)(pvisuals + pVideoScreenRec->numVisuals - 1),
		      sizeof(VisualRec));
		pVideoScreenRec->visuals =  pvisuals;
	    }
	    else {
		pVis->vid = vid;
	    }
	}
    }
    pVideoScreenRec->pDepths = (DepthPtr) newDepths.pDepths;
    pVideoScreenRec->nDepths = newDepths.nDepths;
    return (TRUE);
}

/*
 * If alloc failure, delete list
 */
static Bool
AddNewDepth(pScreen, newDepth, depthList, pVis)
    ScreenPtr pScreen;
    int newDepth;		/* depth to add to list if not already present*/
    VisualRec *pVis;		/* if non-NULL, create resource and VisualID
				 * and add to list */
    UniqueDepths *depthList;
{
    int i, index;
    int fFound;
    unsigned long *pvids;
    DepthPtr pDepths;

    if (newDepth == 0)
	return TRUE;

    for(i=0, fFound=FALSE; i < depthList->nDepths; i++)
	if (depthList->pDepths[i].depth == newDepth) {
	    fFound = TRUE;
	    index = i;
	    break;
	}
    if (!fFound) {
	depthList->nDepths++;
	pDepths = (DepthPtr) xrealloc(depthList->pDepths, 
		sizeof(DepthRec) * depthList->nDepths);
	if (!pDepths) {
	    depthList->nDepths--;
	    FreeDepths(depthList->nDepths, depthList->pDepths);
	    return(FALSE);
	}
	index = depthList->nDepths - 1;
	pDepths[index].depth = newDepth;
	pDepths[index].numVids = 0;
	pDepths[index].vids = (unsigned long *)0;
	depthList->pDepths = pDepths;
    }


    if (pVis) {
	depthList->pDepths[index].numVids++;
	pvids = xrealloc(depthList->pDepths[index].vids,
		sizeof(unsigned long) * depthList->pDepths[index].numVids);
	if (!pvids) {
	    FreeDepths(depthList->nDepths, depthList->pDepths);
	    return(FALSE);
	}
	pVis->vid = FakeClientID(0);
#ifdef R3
	pVis->screen = pScreen->myNum;
#endif
	pvids[depthList->pDepths[index].numVids - 1] = pVis->vid;
	depthList->pDepths[index].vids = pvids;
    }

    return(TRUE);
}

static Bool
IsCoreDepth(pScreen, depth)
    ScreenPtr pScreen;
    int depth;
{
    int i;
    for (i = 0; i < pScreen->numDepths; i++) {
	if (depth == pScreen->allowedDepths[i].depth)
	    return (TRUE);
    }
    return (FALSE);
}

/*
 * Find a core visual which matches "pVis".  If a match is found, return
 * the visual id.  Otherwise return None
 */
static unsigned long
GetCoreVid(pScreen, depth, pVis)
    ScreenPtr pScreen;
    int depth;
    VisualPtr pVis;
{
    int i, j;
    VisualPtr pVisCore;

    for (i = 0; i < pScreen->numDepths; i++) {
        if (depth == pScreen->allowedDepths[i].depth) {
	    for (j = 0; j < pScreen->allowedDepths[i].numVids; j++) {
#ifdef R3
		unsigned long vid;
		vid = pScreen->allowedDepths[i].vids[j];
		pVisCore = (VisualPtr) LookupID(vid, RT_VISUALID, RC_CORE);
#else
		pVisCore = &pScreen->visuals[j];
#endif
		if (pVis->class == pVisCore->class &&
		    pVis->bitsPerRGBValue == pVisCore->bitsPerRGBValue &&
		    pVis->ColormapEntries == pVisCore->ColormapEntries &&
		    ((pVis->class != DirectColor && 
			    pVis->class != TrueColor) ||
			pVis->redMask == pVisCore->redMask &&
			pVis->greenMask == pVisCore->greenMask &&
			pVis->blueMask == pVisCore->blueMask)) {

		    return(pVisCore->vid);
		}
	    }
	}
    }

    return (None);
}
/* XXX
 * If we are going to add depths which are not listed in the core
 * connection, we must ensure that the core connection lists formats
 * for our new depths.  There are a couple of possibilities:
 *     Modify InitOutput() to add the needed format info, using
 *         a call to *uninitialized* VEX extension to determine needed 
 *	       formats.
 *     Modify CreateConnectionBlock() to add the needed format info,
 *         using a call to *uninitialized* VEX extension to determine needed
 *         formats.
 *    (Who should be able to set scanlinePad?  InitOutput() or the VEX
 *         extension?  Probably depends on who is supplying the ddx
 *         Put/GetImage routines.)
 */
/* XXX
 * How does one ensure that MAXFORMATS is not exceeded?
 */
vexAddFormats(screenInfo)
    ScreenInfo *screenInfo;
{
#ifdef needed
    int i,j;
    int curFormat = screenInfo->numPixmapFormats;

    for (i= 0; i < NPLXFORMATS; i++ {
	for (j = 0, found = FALSE; j < screenInfo->numPixmapFormats; j++) {
	    if (vexPlxFormats[i].depth == screenInfo->formats[j].depth) {
		found = TRUE;
		break;
	    }
	}
	if (!found) {
	    screenInfo->formats[curFormat].depth = vexPlxFormats[i].depth;
	    screenInfo->formats[curFormat].bitsPerPixel =
		    vexPlxFormats[i].bitsPerPixel;
	    screenInfo->formats[curFormat].scanlinePad =
		    vexPlxFormats[i].scanlinePad;
	    curFormat++;
	}
    }
    screenInfo->numPixmapFormats = curFormat;
#else
    return;
#endif /* needed */
}

/*
 * Get a VideoDrawRec structure for a given drawable.  Create
 * one if one does not already exist.
 *
 * Returns NULL if alloc error, else returns a VideoDrawPtr.
 */
VideoDrawPtr GetVideoDrawable(vp, pDraw)
    VideoScreenPtr vp;		/* Video screen */
    DrawablePtr pDraw;		/* Drawable */
{
    VideoDrawPtr vDraw;

    if (vDraw = (VideoDrawPtr) LookupIDByType(pDraw->id, vp->vDrawType))
	return (vDraw);

    vDraw = (VideoDrawPtr) xalloc(sizeof(VideoDrawRec));
    if (vDraw == NULL)
	return (vDraw);
    if (!AddResource(pDraw->id, vp->vDrawType, (pointer)vDraw)) {
	xfree(vDraw);
	return(NULL);
    }
    vDraw->renderActive = NoVideo;
    vDraw->captureActive = NoVideo;
    vDraw->pDraw = pDraw;
    return(vDraw);
}
