/************************************************************
Copyright 1989 by Tektronix Inc.
Copyright 1989 by The Massachusetts Institute of Technology

                    All Rights Reserved

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the names of MIT and Tektronix not be 
used in advertising or publicity pertaining to distribution of the
software without specific prior written permission.
M.I.T. and Tektronix make no representation about the 
suitability of this software for any purpose. It is provided 
"as is" without any express or implied warranty.

MIT AND TEKTRONIX DISCLAIM ALL WARRANTIES WITH REGARD TO  THIS  
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL MIT OR
TEKTRONIX BE LIABLE FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA  OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

/* $Header: ctrlproto.h,v 1.2 90/03/09 13:48:47 scotthe Exp $ */

#ifndef _CTRLPROTO_H_
#define _CTRLPROTO_H_


typedef struct {
	INT32		numBase B32;
	INT32		numIncrement B32;
	INT32		numLimit B32;
	INT32		denomBase B32;
	INT32		denomIncrement B32;
	INT32		denomLimit B32;
	INT32		numType B32;
	INT32		denomType B32;
} xIntFractionRange;

typedef struct {
	CARD32		normalCapability B32;
	xFraction	normalSpeed;
	CARD32		slowCapability B32;
	CARD32		slowSpeedType B32;
	xIntFractionRange	slowSpeed;
	CARD32		fastCapability B32;
	CARD32		fastSpeedType B32;
	xIntFractionRange	fastSpeed;
} xvexCtrlPlay;

typedef struct {
	CARD32		directive B32;
	CARD32		frameA B32;
	CARD32		frameB B32;
	xFraction	speed;
} xvexSettingPlay;

typedef struct {
	CARD32		directive B32;
	CARD32		frameA B32;
} xvexSettingFreezeFrame;

typedef struct {
	CARD32		Capability B32;
} xvexCtrlCapability;

typedef struct {
	CARD32		directive B32;
} xvexSettingDirective;

/*
 * Settings corresponding to Galatea command set
 */

/*
 * Std commands: No Arguments:
 *	INDEX_ON, INDEX_OFF, INDEX_TOGGLE, A1_ON, A1_OFF, A2_ON, A2_OFF,
 *	LOAD, UNLOAD, EJECT, INDEX_TOGGLE
 */
/* XXX Note pioneer does not implement EJECT */

/* 
 * Optional commands 
 *	No Arguments: RESET, 
 */

typedef struct {
    INT32	frame1;
} xvexSettingSearch;

typedef struct {
    INT32	frame1;
    INT32	frame2;
    INT32	speed;
} xvexSettingSegPlay;

/*
 * Note this is not valid for a ChangeVideoControls, only valid for
 * QueryVideoControls
 */
typedef struct {
    INT32	frame1;
} xvexSettingGetFrame;

typedef struct {
    INT32	num;
} xvexSettingVarSpeed;

typedef struct {
    INT32	num;
} xvexSettingJog;

/* XXX
 * Not implemented: xvexSettingRecord
 */

#endif /* _CTRLPROTO_H_ */
