/************************************************************
Copyright 1989 by Tektronix Inc.
Copyright 1989 by The Massachusetts Institute of Technology

                    All Rights Reserved

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the names of MIT and Tektronix not be 
used in advertising or publicity pertaining to distribution of the
software without specific prior written permission.
M.I.T. and Tektronix make no representation about the 
suitability of this software for any purpose. It is provided 
"as is" without any express or implied warranty.

MIT AND TEKTRONIX DISCLAIM ALL WARRANTIES WITH REGARD TO  THIS  
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL MIT OR
TEKTRONIX BE LIABLE FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA  OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

/* $Header: video.h,v 1.10 90/04/13 15:43:28 toddb Exp $ */

#ifndef _VIDEO_H_
#define _VIDEO_H_

/*
 * Constants for VideoDrawRec (per drawable resource)
 * These work for either CaptureGraphics or RenderVideo
 */
#define	NoVideo			0	/* vanilla window */
#define	StillVideo		1	/* if the hardware makes distinction */
#define	MotionVideo		2	/* motion */
#define	SuspendedStillVideo	-1	/* -StillVideo */
#define	SuspendedMotionVideo	-2	/* -MotionVideo */

#define AllVEXEventMask	\
	(VEXRedirectMask|VEXConnectivityMask|VEXSyncMask \
	|VEXControlMask|VEXOverrideMask|VEXViolationMask)


#define VideoNumberErrors		1
/*
 * This mask must not intersect with AllVEXEventMask
 */
#define ChangeNotify                   (1L << 31)

#define BAD_VIDEO	(VideoErrorBase + BadVideo)

extern void SVideoControlEvent();
extern void SVideoViolationEvent();
extern void SVideoSyncEvent();
extern void SVideoOverrideEvent();
extern void SVideoChangeEvent();
extern void SVideoConnectivityStateEvent();
extern void SVideoRequestEvent();
extern void SVideoRequestAddendumEvent();
extern int SProcQueryVideo ();
extern int SProcCreateVideo ();
extern int SProcRenderVideo ();
extern int SProcCaptureGraphics ();
extern int SProcStopVideo ();
extern int SProcQueryVideoControls ();
extern int SProcChangeVideoControls ();
extern int SProcChangeConnectivity ();
extern int SProcChangeOwnership ();
extern int SProcSelectVideoEvents ();
extern int SProcVideoDispatch ();
extern void SwapSettingList();
extern void SwapFraction();
extern void SQueryVideoControlsReply();
extern void SwapDepths();
extern void SwapRenderModels();
extern void SwapVideoGeometries();
extern void SwapControls();
extern void SQueryVideoReply();

extern void SendVideoOverrideEvent();
extern void SendVideoViolationEvent();
extern void SendVideoRequestEvent();
extern void SendVideoSyncEvent();
extern void SendVideoControlEvent();
extern void SendVideoChangeEvent();


#endif
