/* $Header: videostr.h,v 1.17 90/04/10 13:43:42 scotthe Exp $ */

/************************************************************
Copyright 1989 by Tektronix Inc.

                    All Rights Reserved

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the names of MIT and Tektronix not be
used in advertising or publicity pertaining to distribution
of the software without specific prior written permission.
M.I.T. and Tektronix make no representation about the 
suitability of this software for any purpose. It is provided 
"as is" without any express or implied warranty.

MIT AND TEKTRONIX DISCLAIM ALL WARRANTIES WITH REGARD TO  THIS  
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL MIT OR
TEKTRONIX BE LIABLE FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA  OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/


#ifndef _VIDEOSTR_H_

/*
 * These should probably move out to another header file??
 */
#include "scrnintstr.h"
#include "dixstruct.h"
#include "video.h"

#ifdef XDEBUG
/*
 * This define appears as a single statement and can be used anywhere, e.g.
 *	assert(foo < 0);
 * doassert() avoids complaints from lint.
 */
#define assert(ex) 							\
	((ex) ? 0 :							\
	    (FatalError("Assertion in \"%s\", line %d failed:\n\t%s\n",	\
		__FILE__, __LINE__, "ex"), 1))
#define doassert() 							\
	    (FatalError("Assertion in \"%s\", line %d failed:\n\t%s\n",	\
		__FILE__, __LINE__, "ex"), 1)
#else
#define assert(ex)
#define doassert()
#endif

extern int VideoErrorBase;

typedef struct _VideoEventElement {
    ClientPtr client;
    struct _VideoEventElement *next;
} VideoEventElement;

typedef struct {
    xVideoGeometry xvg;
    xPlacement *pPlacements;
} VideoGeometry;

typedef struct {
    xControl xc;
    char *pValues;
} ControlElement;

typedef struct _DeviceElement {
    char type;
    char onLine;
    unsigned short nControl;
    unsigned long id;
    ControlElement *pControl;
    Bool (* ChangeVideoControls)();
    Bool (* QueryVideoControls)();
    pointer devPrivate;
} DeviceElement;

typedef struct {
    unsigned long nAdjacencyMatrices;
    unsigned long nTransitions;
    unsigned long currentState;
    unsigned char  *pAdjMat;
    xVideoTransition *pTransitions;
} ConnectivityInfo;

typedef struct {
    int nDevice;
    DeviceElement **pDeviceElement;
} DeviceList;

typedef struct {
    DeviceList devices;
    ConnectivityInfo connectivity;
} DeviceInfo;

typedef struct _VideoScreen {
    ScreenPtr pScreen;
    XID id;			/* XID for Resource mgt, e.g. event selection */
    short numVisuals;
    RESTYPE vDrawType;
    RESTYPE vResType;
    RESTYPE vIdType;
    RESTYPE vClientOwnerType;
    RESTYPE vWinOwnerType;
    VisualPtr visuals;
    unsigned char inputOverlap;
    unsigned char captureOverlap;
    unsigned char ioOverlap;
    unsigned char nDepths;
    unsigned char nAllowedDepths;
    unsigned char nVin;
    unsigned char nVout;
    DepthPtr pDepths;
    xRenderModel *pAllowedDepths;
    VideoGeometry *pInattrs;
    VideoGeometry *pOutattrs;
    unsigned char  *pVinModels;
    unsigned char  *pVoutModels;
    xRectangle *pClipSize;
    DeviceInfo deviceInfo;
    TimeStamp lastVideoChangeTime;

    pointer		devPrivate;

    /*
     * protocol vectors.
     */
    Bool (* QueryVideo)();		/* pScreen, pVideoInfo->deviceInfo */
    void (* ChangeConnectivity)();	/* ? */
    Bool (* RenderVideo)();		/* ? */
    void (* StopVideo)();		/* ? */
    Bool (* CaptureGraphics)();		/* ? */
    void (* FreeDeviceInfo)();		/* pVideoInfo->deviceInfo */

    /*
     * utility vectors
     */
    Bool (* PreCopyWindow)();		/* pWin, lastPosition, pRegionSrc */
    void (* PostCopyWindow)();		/* pWin, lastPosition, pRegionSrc */

    /*
     * Saved vectors from the screen
     */
    Bool (* CreateWindow)();
    void (* CopyWindow)();
    Bool (* DestroyWindow)();		/* pWin */
} VideoScreenRec, *VideoScreenPtr;

/*
 * Used by ddx layers for building queryvideo information
 */
typedef struct {
    unsigned long redMask;
    unsigned long greenMask;
    unsigned long blueMask;
} RGBMaskRec, *RGBMaskPtr;

typedef struct _videoVisual {
    int depth;				/* RenderModel depth */
    int opaque;				/* True if pixels cannot be interpreted
					 * by a Core type */
    VisualRec *pVis;			/* RenderModel visual */
    RGBMaskPtr pMasks;			/* RenderModel RGB masks (for pixmaps)*/
} VideoVisual;


typedef struct _ownership {
    ClientPtr		pClient;	/* The owning client */
    unsigned long	clientID;	/* A fake client XID */
    unsigned long	window;		/* A window XID */
    long		inUse;		/* TRUE if this ownership is applied
					 * to a current use */
} Ownership;

typedef struct _resourceUsage {
    ClientPtr		pClient;	/* client issuing the Render/Capture */
    DrawablePtr		pDraw;		/* Drawable being Rendered/Captured */
    long		owned;		/* TRUE is this use has an ownership */
} ResourceUsage;

typedef struct _screenIndexRec {
    short	index;		/* index into attributes (Input and Output) */
    ScreenPtr	pScreen;
    struct _screenIndexRec *next;
} screenIndexRec;

/*
 * holds references that identify a particular video resource
 */
typedef struct _videoResourceRec {
    short		type;		/* Video{Input,Output,Device} */
    short		ownerCount;	/* Count of current owners */
    short		useCount;	/* Count of current uses */
    short		maxUse;		/* Maximum of concurrent ownerships
					 * or uses */
    XID			id;		/* VReference or VideoDevice */
    DeviceElement       *pElement;	/* Controls info etc. */
    screenIndexRec	*screens;	/* List of screens this resource is 
				 	 * attached to */
    Ownership		*owners;	/* array of ownership info */
    ResourceUsage	*usage;		/* array of usage info */
} VideoResourceRec, *VideoResourcePtr;

/*
 * holds vex-specific stuff for video windows and pixmaps.
 */
typedef struct _videoDrawRec {
    short	renderActive;
    short	captureActive;
    DrawablePtr	pDraw;
    VideoIn	videoIn;
    VideoOut	videoOut;
} VideoDrawRec, *VideoDrawPtr;

/*
 * Holds the pertinent information for a RenderVideo or CaptureGraphics.
 */
typedef struct _videoActionRec {
    int	srcX, srcY;
    int dstX, dstY;
    int srcWidth, srcHeight;
    int dstWidth, dstHeight;
    Bool fullMotion;
    int priority;
    int subWindowMode;
    VideoDrawPtr vDraw;		/* vex info about the drawable */
    VideoResourcePtr vRes;	/* vex info about the video IO */
    DrawablePtr drawable;	/* source or destination */
    VideoIO videoIO;		/* VideoIn or VideoOut */
    ColormapPtr pcmap;		/* Used for pixmap or window Capture */
} VideoActionRec, *VideoActionPtr;

extern VideoScreenPtr	*ScreenVideoInfo;

extern VideoDrawPtr GetVideoDrawable();	/* VideoScreenPtr, id */

#endif /* _VIDEOSTR_H_ */
