/* $Header: plxEvents.c,v 3.3 90/03/06 15:50:06 toddb Exp $ */
/*
 *   Copyright (c) 1987, 88 by
 *   PARALLAX GRAPHICS, INCORPORATED, Santa Clara, California.
 *   All rights reserved
 *
 *   This software is furnished on an as-is basis, and may be used and copied
 *   only with the inclusion of the above copyright notice.
 *
 *   The information in this software is subject to change without notice.
 *   No committment is made as to the usability or reliability of this
 *   software.
 *
 *   Parallax Graphics, Inc.
 *   2500 Condensa Street
 *   Santa Clara, California  95051
 */

#ifndef lint
static char *sid_ = "@(#)plxEvents.c	1.15 09/01/88 Parallax Graphics Inc";
#endif

#define	PARALLAX_QEVENT
#include	"Xplx.h"
#include	<sys/time.h>

#define	NEED_EVENTS
#include	"Xproto.h"
#include	"input.h"

#ifdef	PARALLAX_CMDKEYS
#include	"../ddx/dec/lk201/keynames.h"
#define	KEY_ALLUP	179
#else /* PARALLAX_CMDKEYS */
#define check_pan(junk)  /* as nothing */
#endif /* PARALLAX_CMDKEYS */

extern vsEventQueue *queue;
extern int lastEventTime;
extern int screenIsSaved;
extern int plx_wfd;
extern DevicePtr plxKeyboard, plxPointer;

/*
 * ProcessInputEvents()
 *
 *	processes all the pending input events
 */
void
ProcessInputEvents()
{
    register int i;
    register vsEvent *pE;
    xEvent x;
    int nowInCentiSecs, nowInMilliSecs, adjustCentiSecs;
    struct timeval tp;
    int needTime = 1;

    ifdebug(4) printf("plx ProcessInputEvents()\n");

    while ((i = queue->head) != queue->tail) {
	if (screenIsSaved == SCREEN_SAVER_ON) {
	    SaveScreens(SCREEN_SAVER_OFF, ScreenSaverReset);
	}

	pE = &queue->events[i];

	x.u.keyButtonPointer.rootX = PTX(pE->vse_x);
	x.u.keyButtonPointer.rootY = PTY(pE->vse_y);

	/*
	 * The following silly looking code is because the old
	 * version of the driver only delivers 16 bits worth of
	 * centiseconds. We are supposed to be keeping time in
	 * terms of 32 bits of milliseconds.
	 */
	if (needTime) {
	    needTime = 0;
	    gettimeofday(&tp, 0);
	    nowInCentiSecs =
		((tp.tv_sec * 100) + (tp.tv_usec / 10000)) & 0xFFFF;
	    /* same as driver */
	    nowInMilliSecs =
		(tp.tv_sec * 1000) + (tp.tv_usec / 1000);
	    /* beware overflow */
	}

	if ((adjustCentiSecs = nowInCentiSecs - pE->vse_time) < -20000) {
	    adjustCentiSecs += 0x10000;
	} else {
	    if (adjustCentiSecs > 20000)
		adjustCentiSecs -= 0x10000;
	}
	x.u.keyButtonPointer.time = lastEventTime =
	    nowInMilliSecs - adjustCentiSecs * 10;

	switch (pE->vse_device) {
	case VSE_DKB:				/* DEC Keyboard */
	    switch (pE->vse_type) {
	    case VSE_BUTTON:
		ifdebug(4) printf("\t%d dev,type,key,dir=%s,%s,%d,%d\n",
				  i, "VSE_DKB", "VSE_BUTTON",
				  pE->vse_key, pE->vse_direction);
		x.u.u.detail = pE->vse_key;
		switch (pE->vse_direction) {
		case VSE_KBTDOWN:
		    x.u.u.type = KeyPress;
		    (plxKeyboard->processInputProc)(&x, plxKeyboard, 1);
		    break;
		case VSE_KBTUP:
		    x.u.u.type = KeyRelease;
		    (plxKeyboard->processInputProc)(&x, plxKeyboard, 1);
		    break;
		case VSE_KBTRAW:
		    check_pan(pE->vse_key);
		    ProcessLK201Input(&x, plxKeyboard);
		    break;
		default:
		    /* IGNORE */
		    break;
		}
		break;
	    default:
		ifdebug(4) {
		    printf("\t%d dev,type,x,y,key,dir=%s,%d,%d,%d,%d,%d\n",
			    i, "VSE_DKB", pE->vse_type, pE->vse_x,
			    pE->vse_y, pE->vse_key, pE->vse_direction);
		    printf("\t%d dev,type,key,dir=%s,%s,%d,%d\n",
			    i, "VSE_DKB", "UNKNOWN", pE->vse_key,
			    pE->vse_direction);
		}
		/* IGNORE */
		break;
	    }
	    break;
	case VSE_MOUSE:				/* Mouse */
	    switch (pE->vse_type) {
	    case VSE_BUTTON:
		ifdebug(4) {
		    printf("\t%d dev,type,x,y,key,dir=%s,%s,%d,%d,%d,%d\n",
			   i, "VSE_MOUSE", "VSE_BUTTON",
			   pE->vse_x, pE->vse_y, pE->vse_key,
			   pE->vse_direction);
		}
		if (pE->vse_direction == VSE_KBTDOWN) {
		    x.u.u.type = ButtonPress;
		} else {
		    x.u.u.type = ButtonRelease;
		}
		/* mouse buttons numbered from one */
		x.u.u.detail = pE->vse_key + 1;
		(*plxPointer->processInputProc)(&x, plxPointer, 1);
		break;
	    case VSE_MMOTION:
		ifdebug(4) {
		    printf("\t%d dev,type,x,y,key,dir=%s,%s,%d,%d,%d,%d\n",
			   i, "VSE_MOUSE", "VSE_MMOTION", pE->vse_x, pE->vse_y,
			   pE->vse_key, pE->vse_direction);
		}
		x.u.u.type = MotionNotify;
		(*plxPointer->processInputProc)(&x, plxPointer, 1);
		break;
	    default:
		ifdebug(4) {
		    printf("\t%d dev,type,x,y,key,dir=%s,%d,%d,%d,%d,%d\n",
			   i, "VSE_MOUSE", pE->vse_type, pE->vse_x, pE->vse_y,
			   pE->vse_key, pE->vse_direction);
		}
		/* IGNORE */
		break;
	    }
	    break;
	default:
	    ifdebug(4) {
		printf("\t%d dev,type,key,dir=%d,%d,%d,%d,%d,%d\n",
			i, pE->vse_device, pE->vse_type, pE->vse_key,
			pE->vse_direction);
	    }
	    /* IGNORE */
	    break;
	}

	if (i == (queue->size - 1)) {
	    queue->head = 0;
	} else {
	    queue->head++;
	}
    }
}

TimeSinceLastInputEvent()
{
    if (lastEventTime == 0)
	lastEventTime = GetTimeInMillis();
    return GetTimeInMillis() - lastEventTime;
}

#if defined(sun) || defined(is68k) || defined(interactive) || defined(motorola131)
void plxWakeupHandler(nscreen, pbdata, err, pReadmask)
    int nscreen;
    pointer pbdata;
    unsigned long err;
    long *pReadmask;
{
    if (pReadmask[ plx_wfd>>5 ] & (1<<(plx_wfd & 0x1f)))
	px_scupdate();
}

#endif

#ifdef	PARALLAX_CMDKEYS
static
check_pan(key)
unsigned char key;
{
    static unsigned char last[4];
    static int idx = -1;		/* -1 == no seqence */
    static int x, y;

    if (key == KEY_HELP) {
	idx = 0;
	return;
    }
    if ((idx < 0) || (key == KEY_ALLUP)) {
	return;
    }

    switch (key) {
    case KEY_F17:			/* normal, top left */
	x = 0; y = 0; idx = -1;
	goto doPan;
    case KEY_F18:			/* top right */
	x = 0x300; y = 0; idx = -1;
	goto doPan;
    case KEY_F19:			/* bottom left */
	x = 0; y = 0x400; idx = -1;
	goto doPan;
    case KEY_F20:			/* bottom right */
	x = 0x300; y = 0x400; idx = -1;
	goto doPan;
    case KEY_LEFT:			/* pan left */
        if (x >= 8)
	    x -= 8;
	goto doPan;
    case KEY_RIGHT:			/* pan right */
	if (x <= 2048 - 1280 - 8)
	    x += 8;
	goto doPan;
    case KEY_DOWN:			/* pan down */
	if (y <= 2048 - 1024 - 8)
	    y += 8;
	goto doPan;
    case KEY_UP:			/* pan up */
	if (y >= 8)
	    y -= 8;
doPan:
	p_pan(x, y);
	return;
    case KEY_REMOVE:		/* first of 'exit' string */
    case KEY_NEXT_SCREEN:		/* Abort server, core dump */
    case KEY_PREV_SCREEN:		/* reset all connections */
	if (idx != 0) {
	    idx = -1;
	    return;
	}
	last[idx++] = key;
	return;
    case KEY_MENU:			/* completion of command */
	if (idx != 1) {
	    idx = -1;
	    return;
	}
	switch (last[idx-1]) {
	case KEY_PREV_SCREEN:
	    idx = -1;
	    FatalError ("Keyboard requested exit");
	    /* NOT REACHED */
	    return;
	case KEY_NEXT_SCREEN:
	    idx = -1;
	    AutoResetServer();
	    return;
	case KEY_REMOVE:
	    idx = -1;
	    GiveUp();
	    /* NOT REACHED */
	    return;
	default:
	    idx = -1;
	    return;
	}
    default:
	idx = -1;
	return;
    }
}
#endif
