/* $Header: plxPixmap.c,v 3.1 90/03/06 15:50:39 toddb Exp $ */
/*
 *   Copyright (c) 1987, 88 by
 *   PARALLAX GRAPHICS, INCORPORATED, Santa Clara, California.
 *   All rights reserved
 *
 *   This software is furnished on an as-is basis, and may be used and copied
 *   only with the inclusion of the above copyright notice.
 *
 *   The information in this software is subject to change without notice.
 *   No committment is made as to the usability or reliability of this
 *   software.
 *
 *   Parallax Graphics, Inc.
 *   2500 Condensa Street
 *   Santa Clara, California  95051
 */

#ifndef lint
static char *sid_ = "@(#)plxPixmap.c    1.31 08/31/88 Parallax Graphics Inc";
#endif

#include    "Xplx.h"

static PixmapPtr dbgPixmap; /* for debugging */
static MapPrivPtr dbgMp; /* for debugging */

PixmapPtr
plxCreatePixmap(pScreen, width, height, depth)
ScreenPtr pScreen;
int width;
int height;
int depth;
{
    register PixmapPtr pPixmap;
    register MapPrivPtr	mp;

    ifdebug(1) printf("plxCreatePixmap(), w,h,depth=%d,%d,%d\n",
			width, height, depth);

    switch (depth) {
    case 1:
    case 8:
        break;
    default:
        ifdebug(1) printf("plxCreatePixmap() NULL, bad depth\n");
        return (NullPixmap);
    }

    mp = (MapPrivPtr) Xalloc(sizeof(MapPriv));
    if (mp == NULL)
	return (NullPixmap);

    mp->plxcache = (plxCache *)NULL;
    mp->plxmemorycopy = NULL;
    mp->plxtile.expanded = FALSE;
    mp->plxtile.x = mp->plxtile.y = 0;
    mp->plxtile.w = mp->plxtile.h = 0;
    mp->plxtile.canTile = FALSE;
#ifdef notdef
    mp->plxtile.rotate = FALSE;
    mp->plxtile.original = NullPixmap;
#endif

    /*
     * This should be done in VEX but is done here because the parallax
     * is very integrated; i.e., one framebuffer is used for both
     * video and graphics.
     */
    mp->videoFormat = FALSE;

    pPixmap = (PixmapPtr)Xalloc(sizeof(PixmapRec));
    pPixmap->drawable.type = DRAWABLE_PIXMAP;
    pPixmap->drawable.pScreen = pScreen;
    pPixmap->drawable.depth = depth;
    pPixmap->drawable.serialNumber = NEXT_SERIAL_NUMBER;
    pPixmap->drawable.width = width;
    pPixmap->drawable.height = height;
    pPixmap->refcnt = 1;
    pPixmap->devPrivate.ptr = (pointer)mp;
    switch (depth) {
    case 1:
        pPixmap->devKind = PixmapBytePad(width, depth);
        break;
    case 8:
        pPixmap->devKind = (((width + 3) >> 2) << 2);
        break;
    }

    if (!plxCachePixmap(pPixmap)) {
        plxDestroyPixmap (pPixmap);
        return (PixmapPtr)NULL;
    }

    ifdebug(1) printf("plxCreatePixmap(), 0x%08x\n", pPixmap);

    return (pPixmap);
}

Bool
plxDestroyPixmap(pPixmap)
register PixmapPtr pPixmap;
{
    register MapPrivPtr mp;

    ifdebug(1) printf("plxDestroyPixmap() 0x%08x\n", pPixmap);

    if (--pPixmap->refcnt) {
        return (TRUE);
    }

    mp = (MapPrivPtr)pPixmap->devPrivate.ptr;
    if (mp->plxcache)
        pl_cache_free(mp->plxcache, 0);
    if (mp->plxmemorycopy)
        Xfree(mp->plxmemorycopy);
    Xfree(mp);
    Xfree(pPixmap);
    return (TRUE);
}

void
plxreadbackpixmap(ce, pPixmap)
register plxCache *ce;
register PixmapPtr pPixmap;
{
    register MapPrivPtr mp = (MapPrivPtr)pPixmap->devPrivate.ptr;
    register int size;

    ifdebug(1) printf("plxreadbackpixmap() 0x%08x\n", pPixmap);

    if (mp->plxcache != ce) {
        printf("plxreadbackpixmap(), cache mismatch\n");
        return;
    }
    if (mp->plxmemorycopy) {
        printf("plxreadbackpixmap(), already have copy in host\n");
        return;
    }

    /* we could unload based on pPixmap->depth, but... */
    size = ce->grp->sizex * ce->grp->sizey;
    mp->plxmemorycopy = (char *)Xalloc(size);

    /*
     * the routine is only called from another pl_*()
     * call, hence we are working in a rmap/opaq/mask clean
     * enviroment
     */
    p_uimg(ce->x, ce->y,
	   ce->x + ce->grp->sizex - 1, ce->y - ce->grp->sizey + 1,
	   mp->plxmemorycopy);
}

Bool
plxCachePixmap(pPixmap)
    register PixmapPtr pPixmap;
{
    register MapPrivPtr mp = (MapPrivPtr)pPixmap->devPrivate.ptr;
    register plxCache *ce = mp->plxcache;
    Bool just_allocated = FALSE;

    ifdebug(1) printf("plxCachePixmap() 0x%08x\n", pPixmap);

    p_mask(0xffff);
    p_rmap(0);
    p_opaq(0);
    p_damvg();
    plxClipInvalidate (pPixmap->drawable.pScreen);

    if (!ce) {
        ce = pl_cache_find(pPixmap->drawable.width, pPixmap->drawable.height);
        if (!ce) {
            ifdebug(1) printf ("plxCachePixmap() failed, size %dx%d\n",
                    pPixmap->drawable.width, pPixmap->drawable.height);
            return(FALSE);
        }
        mp->plxcache = ce;
        /*
         * set readback function for cache, this is our
         * hook into the cache reclaim code.
         */
        pl_cache_readback(ce, plxreadbackpixmap, pPixmap);
        just_allocated = TRUE;
    }
 
    if (mp->videoFormat)
        p_damvv();
    else
        p_damvg();

    if (mp->plxmemorycopy) {
        /*
         * gosh, we got thrown out of the cache.
         */
        p_limg(ce->x, ce->y,
	       ce->x + ce->grp->sizex - 1, ce->y - ce->grp->sizey + 1,
	       mp->plxmemorycopy);
        Xfree(mp->plxmemorycopy);
        mp->plxmemorycopy = (char *)0;
    } else if (just_allocated) {
        /* clear pixmap to 0's */
        p_box(0, ce->x, ce->y,
	      ce->x + pPixmap->drawable.width - 1,
	      ce->y - pPixmap->drawable.height + 1);
    }
    p_damvx();
    return(TRUE);
}

/*
 * plxPixmapUse -- retrieve off screen coordinates and mark use of cached data
 */

Bool
plxPixmapUse(rwflag, pPixmap, x, y)
int rwflag;            /* Do we want to read or write */
register PixmapPtr pPixmap;
short *x,*y;            /* coords in cache. *x = -1 if not cached */
{
    register MapPrivPtr mp = (MapPrivPtr)pPixmap->devPrivate.ptr;
    register plxCache *ce;

    ifdebug(1) printf("plxPixmapUse() 0x%08x, rw=%d\n", pPixmap, rwflag);

    /*
     * this check is more for sanity than for safety, it seems
     * silly for someone to read back a pixmap that has not been
     * written too.
     */
    ce = mp->plxcache;
    if ((rwflag == PIXMAP_READ) && (!ce)) {
        ErrorF("plxPixmapUse() EMPTY PIXMAP\n");
    }

    if (!plxCachePixmap(pPixmap)) {
        *x = *y = -1;
        return (FALSE);
    }

    ce = mp->plxcache;
    *x = ce->x;
    *y = ce->y;

    if (rwflag == PIXMAP_WRITE) {
        /* reset the expanded tile/stipple */
        mp->plxtile.expanded = FALSE;
    }
    pl_cache_update(ce);
    ifdebug(1) printf("\t x,y=%d,%d\n", ce->x, ce->y);

    return (TRUE);
}

plxrotatepixmap(pPixmap, x, y)
register PixmapPtr pPixmap;
{
    register MapPrivPtr	mp;
    register plxCache *ce;
    int deltax, deltay;

    ifdebug(1) printf("plxrotatepixmap() 0x%08x, x,y=%d, %d\n", pPixmap, x, y);
    mp = (MapPrivPtr)pPixmap->devPrivate.ptr;

    ce = mp->plxcache;
    if (!ce) {
        ErrorF("plxrotatepixmap() EMPTY PATTERN\n");
        return;
    }

    deltax = (mp->plxtile.x - x) % pPixmap->drawable.width;
    deltay = (mp->plxtile.y - y) % pPixmap->drawable.height;
    ifdebug(1) printf("\tdelta x,y=%d,%d\n", deltax, deltay);

    if (deltax != 0) {
        /* copy to AREA1 */
        /* copy back to cache box */
    }
    if (deltay != 0) {
        /* copy to AREA1 */
        /* copy back to cache box */
    }

    mp->plxtile.x = x;
    mp->plxtile.y = y;
}

/*
 * We have a pixmap we want to use for a parallax stipple operation.
 * Note that this returns x and y pointing at the upper left.  If the
 * tile operation must be done by hand (with boxc) then these will work.
 * If it can be done with the stipple command (boxs), then it must
 * be done from lower left to upper right... therefore the y coordinate
 * must move to the bottom of the stipple.
 *
 * Note that mp->plxtile.canTile is only an indication that the hardware
 * will support certain instances of the operation.  There are some instances
 * of tiling where you still have to do it by hand (clip list already in
 * use and the tile origin doesn't coincide with the destination rectangle
 * origin).
 */
Bool
plxPreparePattern(pPixmap, xret, yret)
    register PixmapPtr pPixmap;     /* pattern we want to stipple with */
    register short *xret, *yret;    /* what coordinates to use for stipple */
{
    register MapPrivPtr	mp;
    register plxCache *ce;
    register short tileWidth, tileHeight;

    ifdebug(1) printf("plxPreparePattern(), 0x%08x\n", pPixmap);

    tileWidth = pPixmap->drawable.width;
    tileHeight = pPixmap->drawable.height;

    mp = (MapPrivPtr)pPixmap->devPrivate.ptr;
    ce = mp->plxcache;
    if (!ce) {
        ErrorF("plxPreparePattern() EMPTY PATTERN\n");
    }

    if (!plxPixmapUse(PIXMAP_READ, pPixmap, xret, yret)) {
        return (FALSE);
    }
    ce = mp->plxcache;

    ifdebug(1) printf("\tx,y=%d,%d\n", *xret, *yret);

    /*
     * duplicate stipple/tile thru whole of cache box
     * the idea is to get at least a 16by16 area to tile/stipple
     * with.
     */
    if ((tileWidth >= 16) && (tileHeight >= 16)) {
        /*
	 * We end up doing it by hand
	 */
        mp->plxtile.expanded = TRUE;
        mp->plxtile.w = tileWidth;
        mp->plxtile.h = tileHeight;
	if (tileWidth == 16 && tileHeight == 16)
	    mp->plxtile.canTile = TRUE;
    }

    if (! mp->plxtile.expanded) {
        register int x, y, xdisp, ydisp;

        p_rmap(0);
        p_opaq(0);
        p_mask(0xffff);
        plxClipInvalidate (pPixmap->drawable.pScreen);

        if (mp->videoFormat)
            p_damvv();
        else
            p_damvg();

	xdisp = *xret;
	ydisp = *yret;
        /* build a 16x16 stipple pattern */
        p_clip(xdisp, ydisp,
	       xdisp + (ce->grp->sizex - 1), ydisp - (ce->grp->sizey - 1));
        for (x=0; x + tileWidth <= 16; x += tileWidth) {
            for (y=0; y + tileHeight <= 16; y += tileHeight) {
                if ((x == 0) && (y == 0))
                    continue; /* its already in the upper left corner */
                p_boxc(xdisp, ydisp,
		       xdisp + x, ydisp - y,
		       xdisp + x + (tileWidth - 1),
		       ydisp - y - (tileHeight - 1));
            }
        }
        mp->plxtile.w = x;
        mp->plxtile.h = y;
	if (mp->plxtile.w == 16 && mp->plxtile.h == 16)
	    mp->plxtile.canTile = TRUE;
        mp->plxtile.expanded = TRUE;
        p_damvx();
        p_clipd();
    }

    return (TRUE);
}
