/* $Header: plxWindow.c,v 3.0 89/11/27 15:36:46 toddb Exp $ */
/*
 *   Copyright (c) 1987, 88 by
 *   PARALLAX GRAPHICS, INCORPORATED, Santa Clara, California.
 *   All rights reserved
 *
 *   This software is furnished on an as-is basis, and may be used and copied
 *   only with the inclusion of the above copyright notice.
 *
 *   The information in this software is subject to change without notice.
 *   No committment is made as to the usability or reliability of this
 *   software.
 *
 *   Parallax Graphics, Inc.
 *   2500 Condensa Street
 *   Santa Clara, California  95051
 */

#ifndef lint
static char *sid_ = "@(#)plxWindow.c	1.19 08/31/88 Parallax Graphics Inc";
#endif

#include	"Xplx.h"

#include	"mi.h"

Bool plxCreateWindow(pWindow)
WindowPtr pWindow;
{
    register MapPrivPtr mp;

    ifdebug(3) printf("plxCreateWindow()\n");

    mp = plxGetWindowPriv(pWindow);
    mp->plxcache = NULL;
    mp->plxmemorycopy = NULL;
    mp->backgroundPainter = indexPaintAreaNone;
    mp->borderPainter = indexPaintAreaPR;

    /*
     * This should be done in VEX but is done here because the parallax
     * is very integrated; i.e., one framebuffer is used for both
     * video and graphics.
     */
    mp->videoFormat = FALSE;

    return TRUE;
}

void 
plxCopyWindow(pWindow, lastposition, pRegionSrc)
WindowPtr pWindow;
DDXPointRec lastposition;
RegionPtr pRegionSrc;
{
    RegionPtr pRegionDst;
    register BoxPtr pbox;
    register int dx, dy;
    int nbox;
    ScreenPtr	pScr = pWindow->drawable.pScreen;

    ifdebug(3) printf("plxCopyWindow()\n");

    pRegionDst =
	(* pScr->RegionCreate)(NULL, REGION_NUM_RECTS(&pWindow->borderClip));

    dx = lastposition.x - pWindow->drawable.x;
    dy = lastposition.y - pWindow->drawable.y;
    (* pScr->TranslateRegion)(pRegionSrc, -dx, -dy);
    (* pScr->Intersect)(pRegionDst, &pWindow->borderClip, pRegionSrc);

    plxClipInvalidate (pScr);

    p_opaq(0);
    p_rmap(0);
    p_mask(0xffff);
    p_damvg ();

    /*
     * a straight box copy, although source may overlap
     * destination, so possibly reverse the blit direction
     * to prevent blit feedback
     */
    if ((dy > 0) || ((dy == 0) && (dx > 0))) {
	nbox = REGION_NUM_RECTS(pRegionDst);
	pbox = REGION_RECTS(pRegionDst);

	while (--nbox >= 0) {
	    p_boxc(pbox->x1 + dx, PTY(pbox->y1 + dy),
		    pbox->x1, PTY(pbox->y1),
		    pbox->x2 - 1, PTY(pbox->y2-1));
	    pbox++;
	}
    } else {
	nbox = REGION_NUM_RECTS(pRegionDst);
	pbox = REGION_RECTS(pRegionDst) + nbox;

	while (--nbox >= 0) {
	    pbox--;
	    p_boxc(pbox->x2 + dx - 1, PTY(pbox->y2 + dy - 1),
		    pbox->x2 - 1, PTY(pbox->y2 - 1),
		    pbox->x1, PTY(pbox->y1));
	}
    }
    (* pScr->RegionDestroy)(pRegionDst);
}

/*
* swap in correct PaintWindow* routine. 
* These functions are in plxpntwin.c. 
*/
Bool
plxChangeWindowAttributes(pWin, vmask)
WindowPtr pWin;
long vmask;
{
    register int idx;
    extern void	plxSaveAreas (), plxRestoreAreas ();
    register MapPrivPtr mp;

    mp = plxGetWindowPriv(pWin);

    ifdebug(3) printf("plxChangeWindowAttributes()\n");

    while(vmask) {
	idx = ffs(vmask) -1;
	vmask &= ~(idx = (1 << idx));
	switch(idx) {
	case CWBackingStore:
	    /* handled in mi wrapper */
	    break;
	case CWBackPixmap:
	    switch(pWin->backgroundState) {
	    case None:
		mp->backgroundPainter = indexPaintAreaNone;
		break;
	    case ParentRelative:
		mp->backgroundPainter = indexPaintAreaPR;
		break;
	    case BackgroundPixmap:
		mp->backgroundPainter = indexPaintArea;
		break;
	    default:
		FatalError("plxChangeWindowAttributes: backgroundState=%d\n",
		    pWin->backgroundState);
		break;
	    }
	    break;
	case CWBackPixel:
	    mp->backgroundPainter = indexPaintAreaSolid;
	    break;
	case CWBorderPixmap:
	    mp->borderPainter = indexPaintArea;
	    break;
	case CWBorderPixel:
	    mp->borderPainter = indexPaintAreaSolid;
	    break;
	}
    }
}

Bool
plxDestroyWindow(pWindow)
WindowPtr pWindow;
{
    return(TRUE);
}

Bool plxPositionWindow(pWindow, x, y)
WindowPtr pWindow;
int x, y;
{
    ifdebug(3) printf("plxPositionWindow() x,y = %d,%d\n", x, y);

    /*
     * deal with rotation of Window's background and border Tile
     */
    if (pWindow->backgroundState == BackgroundPixmap)
	plxrotatepixmap(pWindow->background.pixmap, x, y);
    if (!pWindow->borderIsPixel)
	plxrotatepixmap(pWindow->border.pixmap, x, y);
}

Bool plxRealizeWindow(pWindow)
WindowPtr pWindow;
{
    ifdebug(3) printf("plxRealizeWindow()\n");
}

Bool plxUnrealizeWindow(pWindow)
WindowPtr pWindow;
{
}
