/*
 * Copyright (c) 1998, 1999 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */
package examples.activation; 

import java.rmi.*;
import java.util.Vector;

public class Client4 {

    public static void main(String args[]) {

	String server = "localhost";
	if (args.length < 1) {
	    System.out.println ("Usage: java Client <rmihost>");
	    System.exit(1);
	} else {
	    server = args[0];
	}

	try {

	    String location = "rmi://" + server + "/MyPersistentClass";

	    YetAnotherRemoteInterface yari = 
		(YetAnotherRemoteInterface)Naming.lookup(location);
	    System.out.println("Got a remote reference to the class " +
	 	"MyPersistentClass");

	    // "result" will be appended to by the remote method call
	    //
	    Vector result = new Vector (1,5);
	    result.addElement("Deposited money");
	    result.addElement("Withdrew money");
	    result.addElement("Transferred money from Savings");
	    result.addElement("Check cleared");
	    result.addElement("Point-of-sale charge at grocery store");
		
	    result = (Vector)yari.calltheServer(result);
	    System.out.println("Called the remote method");
	    System.out.println("Result: ");
	    for (int i = 0; i < result.size(); i++) {
	    	System.out.println(result.elementAt(i));
	    }

	} catch (Exception e) {
		System.out.println("Exception: " + e);
		e.printStackTrace();
	}
    }
}

