#!/usr/gnu/bin/perl
# wwwgnats.pl - a WWW interface to the GNATS bug tracking system
# Thanks to Larry Wall, CERN, and NCSA for Perl, WWW, and Mosaic!

require "/usr/local/Web/cgi-bin/libgnats.pl";

#### Configuration begins here

# Miscellanous data
$EDITOR_FILE = "$GNATS_LIB/gnats/local/editors";
$ORIGIN_FILE = $EDITOR_FILE;
#$ORIGIN_FILE = "/etc/mail/ccmail";

# Outside commands
$MAILER      = "/usr/ucblib/sendmail -oi -t";
$DATEPROG    = "/usr/bin/date";
$LSPROG      = "/usr/bin/ls";
### Configuration ends here

### Modification log:
#  7/14/94 Dan Kegel (dank@adventure.com) - Originally written  
#  7/15/94 Huy Le - Created front-end, added quick-query output restrictions
#  7/16/94 Dan Kegel - added config section & read responsible file
#  7/18/94 Huy Le - Added send-pr function
#  8/19/94 Huy Le - Added edit-pr function
#  1/17/95 Dan Kegel - Rewrote edit-pr for robustness
#  1/20/95 Dan Kegel - cleanup, added way to look for bugs waiting on person
#  1/20/95 Dan Kegel - added a button to report summary of active bugs
#  1/30/95 Dan Kegel - Moved some code into sub parse_pr()
#  2/1/95  Dan kegel - moved all non-WWW code into libgnats.pl
#  3/1/95  Dan Kegel - Edit code now uses associative array to represent
#    current PR.  PR is output in fixed order, not input order.
#    Fewer hardcoded paths to external programs.  Moved pr_addr code to
#    subroutine in libgnats.pl.
#  3/2/95  Dan Kegel - Fixed small bug in timestamp; : was confusing browsers.
### End Modifcation log

### Environment variables
$SCRIPT_NAME = $ENV{"SCRIPT_NAME"};
$PATH_INFO = $ENV{"PATH_INFO"};
$QUERY_STRING = $ENV{"QUERY_STRING"};
$CONTENT_LENGTH = $ENV{"CONTENT_LENGTH"};
$HTTP_AGENT = $ENV{"HTTP_USER_AGENT"};
$SERVER_NAME = $ENV{"SERVER_NAME"};


#################### Array definitions
# Query-pr's -i option outputs the following fields numerically.
# Define arrays to map numbers to name.

### Arrays for quick output display with restricted output fields
@quickSeverity = ("", "Crit", "Ser", "Noncr");
@quickPriority = ("", "Hi", "Med", "Low");
@quickfmt    = ("brief","regular","verbose");
   # The first field is the quickfmt, the second is the field width
%field      = (
		"CATEGORY",     "0:10",
		"RELEASE",      "0:7",
		"SEVERITY",     "1:5",
		"PRIORITY",     "4:3", # Not displayed
		"RESPONSIBLE",  "1:2",
		"STATE",        "0:9",
		"CLASS",        "1:8",
		"SUBMITTER",    "4:7", # Not displayed
		"ARRIVAL_DATE", "2:14",
		"ORIGINATOR",   "1:9",
		"SYNOPSIS",     "0:0",
	     );
   # Defines order of field display in quick output
@field      = (
		"CATEGORY",
		"RELEASE",
		"SEVERITY",
		"PRIORITY",
		"RESPONSIBLE",
		"STATE",
		"CLASS",
		"SUBMITTER",
		"ARRIVAL_DATE",
		"ORIGINATOR",
		"SYNOPSIS",
	     );

### Arrays for quick output of PR's with restricted characteristics
   # The first field is the restriction, the second field is the default option
%quickrestr = (
		"Category",    "any",
		"State",       "open",
		"Responsible", "any",
		"Originator",  "any",
	    );
   # Defines order of quick output restrictions
@quickrestr = (
		"Category",
		"State",
		"Responsible",
		"Originator",
	    );

#################### Main routine
# Main Program
print "Content-type: text/html\n\n";
print "<HTML>\n";

&read_originator;
&read_editor;

### Submit a new PR
if ($PATH_INFO =~ m,^/send_pr,) {
    &send_pr();
} elsif ($PATH_INFO =~ m,^/handle_send_pr,) {
    &handle_send_pr();

### Edit an existing PR
} elsif ($PATH_INFO =~ m,^/edit_pr,) {
    $QUERY_STRING =~ m,^pr=(\d*),;
    &edit_pr($1);
} elsif ($PATH_INFO =~ m,^/handle_edit_pr/,) {
    if ($PATH_INFO =~ m,^/handle_edit_pr/(\d+)&([^&]+)&([^&]+)$,) {
	&handle_edit_pr($1, $2, $3);
    } else {
	print "Bad args for handle_edit_pr!\n";
	print "Args are $PATH_INFO.\n";
	if ($PATH_INFO =~ m,^/handle_edit_pr/(\d+)&,) {
	    print "Doesn't have digits&\n";
	}
	if ($PATH_INFO =~ m,^/handle_edit_pr/(\d+)&([^&]+)&,) {
	    print "Doesn't have digits&stuff\n";
	}
    }

### Display the entire PR
} elsif ($PATH_INFO =~ m,^/full,) {
    local($subdir);
    $subdir = $PATH_INFO;
    if ($subdir =~ m,^/full/(\d+),) {  # Called from quick query
        &query_full($1);
    } else {
	$QUERY_STRING =~ m,^pr=(\w+)$,;
	&query_full($1);
    }

### Query a number of PR's and display in quick output form
} elsif ($PATH_INFO =~ m,^/quick,) {
    # Get arg of quickfmt=
    $QUERY_STRING =~ m,^quickfmt=(\w+)&,;
    $QUICKFMT = $1;
    # Get all restrictions.  First, strip off quickfmt prefix.
    ($RESTR = $QUERY_STRING) =~ s/^quickfmt=\w+&//;
    # Then, split into words.
    @RESTR=split(/&/,$RESTR);

    &query_quick($QUICKFMT,@RESTR);
### Get count of pending bugs by category
} elsif ($PATH_INFO =~ m,^/summary_cat,) {

    &query_summary_cat();

### Get count of pending bugs by person
} elsif ($PATH_INFO =~ m,^/summary,) {

    &query_summary();

### Main menu
} elsif ($PATH_INFO eq "") {
    &main_menu();
    print"<HR>Version: 15 Mar 95<BR>Authors: <A HREF=\"http://alumni.caltech.edu/~dank\">Dan Kegel</A> dank@alumni.caltech.edu & <A HREF=\"http://alumni.caltech.edu/~huyle/\">Huy Le</A> huyle@alumni.caltech.edu</H5>\n";
} else {
    print "<head><title>SPR Front End</title></head>
<H1>SPR Front End</H1>
<body>
";
   print "Bad subdirectory/parameters specified in URL.\n";
}

#&dumpenv;
print "\n</body>\n";
print "</HTML>\n";
exit(0);

#################### Miscellaneous functions
# Dumps the environment
sub dumpenv
{
    print "\n<P><HR><P>\n";
    print "<pre>\n";
    foreach (sort(keys(%ENV))) {
    	print "$_ ", $ENV{$_}, "\n";
    }
    print "</pre>\n";
}

# Translates '+' to ' ' and '%##' to 'chr(0x##)'
sub cgi_trans
{
    local($str) = $_[0];

    $str =~ s/\+/ /g;
    $str =~ s/%([\dA-Fa-f][\dA-Fa-f])/sprintf("%c",hex($1))/eg;
    return $str;
}

# Make text safe to display in an HTML stream
sub html_escape
{
    local($tmp) = $_[0];
    $tmp =~ s/</&lt;/g;
    $tmp =~ s/>/&gt;/g;
    return $tmp;
}

# Reads in possible PR originators
# Note: @nOriginator has an extra entry at the top
sub read_originator {
    #  Full_name e-mail@address of originators
    #  Huy_Le Huy_Le@ccmail.adventure.com
    open(ORIGINATOR, "$ORIGIN_FILE") || die "Couldn't get originator file\n";
    while (<ORIGINATOR>) {
	if (!/^\s*(#|\n)/) {
	    ($name, $email) = split(/ /);
	    chop($email);
	    $nOriginator{$name} = $email;
	}
    }
    close(ORIGINATOR);
    @nOriginator = sort(keys(%nOriginator));
    unshift(@nOriginator, "");  # needed for 'any'
}

# Reads in possible PR editors
sub read_editor {
    #  Full_name e-mail@address of editors
    #  Huy_Le Huy_Le@ccmail.adventure.com
    open(EDITOR, "$EDITOR_FILE") || die "Couldn't open editor file $EDITOR_FILE\n";
    while (<EDITOR>) {
	if (!/^\s*(#|\n)/) {
	    ($name, $email) = split(/ /);
	    chop($email);
	    $nEditor{$name} = $email;
	}
    }
    close(EDITOR);
    @nEditor = sort(keys(%nEditor));
}

#################### PR submission

# Sends the new PR
sub handle_send_pr {   
    # Display title
    print "<head><title>New Problem Report submission</title></head>
<body>
";

    # Get arguments
    local($_)=scalar(<STDIN>);
    chop; s/\r$//;
    local($i,%input);
    undef(%fieldvalues);	# Global!
    foreach (split(/&/)) {
        ++$i;
        local($key,$value)=split(/=/);
	$value = &cgi_trans($value);
	# By convention, multi-line fields have newlines at end of
	# each line.  I think some browsers forget the last newline?
	if ($fieldnames_multi{$key} > 0 && $value !~ /\n$/) {
	    $value .= "\n";
	}
        $fieldvalues{$key}=$value;
    }

    # Verify arguments
    local($field);
    foreach $field ("Originator", "Category") {
	if ($fieldvalues{$field} eq "") {
	    print "<H3>Your problem report has not been sent.</H3>\n";
	    print "You must select a $field.\n";
	    return;
	}
    }

    # kludge
    $fieldvalues{"Confidential"} = "no";
    $fieldvalues{"Priority"} = "medium";
    # megakludge.
    $fieldvalues{"Submitter-Id"} = $fieldvalues{"Organization"};

    # Send the PR
    $prtext = &unparse_pr("send");
    open(MAIL, "|$MAILER") || die "Error while invoking sendmail";
    print MAIL
"To: $GNATS_ADDR
Subject:
From: $nOriginator{$fieldvalues{\"Originator\"}} ($fieldvalues{\"Originator\"})
Reply-To: $nOriginator{$Originator}
X-send-pr-version: $GNATS_VER

$prtext";
    close(MAIL);
    print "<H3>Your problem report has been sent.  It will take about 3 minutes to show up in the system.</H3>\n";
}


# Gives interface for new PR submission
sub send_pr
{
    # Display title
    print "<head><title>New Problem Report submission</title></head>
<H2>New Problem Report form:</H2>
<body>
";

    print "<FORM METHOD=\"POST\" ACTION=\"http:$SCRIPT_NAME/handle_send_pr\">\n";
    print "Organization: \n";
    for ("kadev", "kaqa", "kaworlds") {
        print "<INPUT TYPE=\"radio\" NAME=\"Organization\" VALUE=\"$_\"";
	print " CHECKED" if ($_ eq "kadev");
        print "><I>$_</I> \n";
    }
    print "<BR>\n\n";

    print "Originator (you): \n";
    print "<SELECT NAME=\"Originator\" SIZE=10>\n";
    for (sort keys(%nOriginator)) {
	print "<OPTION> $_\n";
    }
    print "</SELECT>\n";

    print "Category: \n";
    print "<SELECT NAME=\"Category\" SIZE=10>\n";
    foreach $option (@nCategory) {
	print "<OPTION> $option\n" if ($option);
    }
    print "</SELECT>\n";

    print "<UL>\n";
    print "Release: <INPUT NAME=\"Release\" SIZE=20><BR>\n";
    foreach ("Class", "Severity") {
        print "$_:\n";
        print "<SELECT NAME=\"$_\">\n";
        foreach $option (eval "\@n$_") {
	    print "<OPTION", $_ eq "Severity" && $option eq "Serious" ?
	          " SELECTED" : "", "> $option\n" if ($option);
	}
        print "</SELECT><BR>\n";
    }
    print "</UL>\n";

    # Maximize box dimensions
    local($width)= $HTTP_AGENT=~/X Win/ ? 60 : 80;
    local($height)= $HTTP_AGENT=~/X Win/ ? 2 : 4;
    local($height2)=$height*2;

    print "
Environment:<BR>
<TEXTAREA NAME=\"Environment\" COLS=$width ROWS=$height></TEXTAREA><BR>
Synopsis:<BR>
<INPUT NAME=\"Synopsis\" SIZE=$width><BR>
Description:<BR>
<TEXTAREA NAME=\"Description\" COLS=$width ROWS=$height2></TEXTAREA><BR>
How-To-Repeat:<BR>
<TEXTAREA NAME=\"How-To-Repeat\" COLS=$width ROWS=$height></TEXTAREA><BR>

<P><INPUT TYPE=\"submit\" VALUE=\"Click here to send\">
 or <INPUT TYPE=\"reset\" VALUE=\"Click here to clear the page.\">
</FORM>
";
}

#Fix:<BR>
#<TEXTAREA NAME=\"Fix\" COLS=$width ROWS=$height></TEXTAREA><BR>

#################### PR editing
# Gets the timestamp of the given file
sub timestamp {
    local($fname) = shift(@_);

    open(TIMESTAMP, "$LSPROG -l $fname|")
        || die "Error: can't record the timestamp of the PR ($fname)";
    ($_=<TIMESTAMP>)=~ /\s(\S+\s+\S+\s+\S+)\s+\S+$/
	|| die "Error: can't record the timestamp of the PR ($fname)";
    close(TIMESTAMP);
    local($ts)=$1;
    $ts =~ tr/ /+/;
    $ts =~ tr/:/_/;
    $ts;
}

# Sends the PR changes
sub handle_edit_pr {
    # Display title
    print "<head><title>Problem Report editing</title></head>
<body>
";
    # Initialization
    $errmsg="<H3>Your problem report changes have not been sent.</H3>\n";

    # Get the PR, editor, old state, and timestamp
    local($pr, $oldstate, $timestamp) = @_;

    # Get arguments
    local($_)=scalar(<STDIN>);
    chop; s/\r$//;
    local($i,%input);
    foreach (split(/&/)) {
        ++$i;
        local($key,$value)=split(/=/);
        $input{$key}=&cgi_trans($value);
    }

    # Verify arguments
    if (!$input{"Editor"}) {
	print $errmsg, "You must register your name.\n";
	return;
    }

    # Lock and read the PR into @oldpr and %fieldvalues
    # Also sets $semipr and $fullpr
    $err = &read_pr($pr, $input{"Editor"});
    if ($err ne "") {
	print $errmsg, $err;
	return;
    }
    #local($oldstate) = $fieldvalues{"State"};
    local($oldsyn) = $fieldvalues{"Synopsis"};
    local($oldresp) = $fieldvalues{"Responsible"};
    $oldresp =~ s/\s*\(.*$//; # Get rid of comment in responsible party name
    local($reply_to) = $fieldvalues{"Reply-To"};
    if ($reply_to eq "") {
	# "Reply-To:" takes precedence over "From:".
	$reply_to = $fieldvalues{"From"};
    }

    local($ed_err);
    local(%mail_to);
    local($change_msg) = "";
    LOCKED: {
	# Now that pr has been locked, if any errors are encountered,
	# set $ed_err to the reason and jump to UNLOCK.

	# Check that the timestamp hasn't changed since the form was generated
	if ($timestamp ne &timestamp($fullpr)) {
	    $ed_err = "$errmsg\nThis PR has been modified since you started editing it.\n";
	    last LOCKED;
	}

	# Another sanity check
	if ($reply_to eq "" || $oldresp eq "") {
	    $ed_err = "$errmsg\nHey!  Old responsible is '$oldresp', reply address on pr is '$reply_to'!\n";
	    last LOCKED;
	}

	# Get the date
	local($date);
	if (!open(DATE, "$DATEPROG|")) {
	    $ed_err = "$errmsg\nError: can't run $DATEPROG";
	    last LOCKED;
	}
	chop($date=<DATE>);
	close(DATE);

	$mail_to{&tolower($nEditor{$input{'Editor'}})} = 1;
	local($to_subm, $to_old, $to_new);

	# Update the audit trail
	#print "if ($input{'State'} ne $fieldvalues{'State'})\n";
	if ($input{"State"} ne $fieldvalues{'State'}) {
	    if ($input{'StateReason'} eq "") {
		$ed_err = "$errmsg\nYou must tell why the State changed.\n";
		last LOCKED;
	    }
	    $change_msg .= "State-Changed-From-To: $fieldvalues{'State'}-$input{'State'}
State-Changed-By: $input{'Editor'}
State-Changed-When: $date
State-Changed-Why:
$input{'StateReason'}
";
	    $to_old = $to_subm = 1;
	    $fieldvalues{'State'} = $input{'State'};
	}

	#print "if ($input{'Responsible'} ne $oldresp)\n";
	if ($input{'Responsible'} ne $oldresp) {
	    if ($input{'ResponsibleReason'} eq "") {
		$ed_err = "$errmsg\nYou must tell why the Responsible person changed.\n";
		last LOCKED;
	    }
	    $change_msg .= "Responsible-Changed-From-To: $fieldvalues{'Responsible'}-$input{'Responsible'}
Responsible-Changed-By: $input{'Editor'}
Responsible-Changed-When: $date
Responsible-Changed-Why:
$input{'ResponsibleReason'}
";
	    $to_old = $to_new = 1;
	    $fieldvalues{'Responsible'} = $input{'Responsible'};
	}
	if ($input{"Category"} ne $fieldvalues{"Category"}) {
	    # Gnats' original edit-pr command didn't generate an audit
	    # trail for this change
	    # Note: category names might have dashes in them, making
	    # the following line hard to parse!
	    $change_msg .= 
"Category-Changed-From-To: $fieldvalues{'Category'}-$input{'Category'}
Category-Changed-By: $input{'Editor'}
Category-Changed-When: $date
\n";
	    $fieldvalues{'Category'} = $input{'Category'};
	}

	# Check that changes were actually made
	if ($change_msg eq "") {
	    $ed_err = "$errmsg\nNothing was changed.\n";
	    last LOCKED;
	}
	# Add the change log to the PR
	$fieldvalues{'Audit-Trail'} .= $change_msg;

	# Generate the mailing list
	if ($to_subm) {
	    $mail_to{&tolower($reply_to)} = 1;
	}
	if ($to_old) {
	    ($adr, $err) = &pr_addr($oldresp);
	    if ($err ne "") {
		$ed_err = "$errmsg\n$err";
		last LOCKED;
	    }
	    $mail_to{&tolower($adr)} = 1;
	}
	if ($to_new) {
	    ($adr, $err) = &pr_addr($input{'Responsible'});
	    if ($err ne "") {
		$ed_err = "$errmsg\n$err";
		last LOCKED;
	    }
	    $mail_to{&tolower($adr)} = 1;
	}

	# Apply the changes and send the new PR
	$newpr = &unparse_pr("");
	#print "opening |$PR_EDIT > /tmp/wwwgnats.$$ 2>&1\n";
	unlink("/tmp/wwwgnats.$$");
	if (!open(PREDIT, "|$PR_EDIT > /tmp/wwwgnats.$$ 2>&1")) {
	    $ed_err = "$errmsg\nError: can't invoke pr-edit\n";
	    last LOCKED;
	}
	print PREDIT $newpr;
	close(PREDIT);
	if ($?) {
	    $ed_err = "$errmsg\nError: pr-edit returns status $?, and reports:\n";
	    if (!open(PREDIT, "/tmp/wwwgnats.$$")) {
		$ed_err .= "(whoops, no output from pr-edit found; couldn't open /tmp/wwwgnats.$$)\n";
	    } else {
		$ed_err .= join("\n",<PREDIT>);
		close(PREDIT);
	    }
	    unlink("/tmp/wwwgnats.$$");
	    last LOCKED;
	}
	unlink("/tmp/wwwgnats.$$");
	#print "</PRE>";
    }

    # Unlock the PR
    #print "unlocking\n";
    system("$PR_EDIT --unlock $semipr");
    # if we got here via a last, report the error and quit
    if ($ed_err ne "") {
	print "<PRE>";
	print $ed_err;
	print "</PRE>";
	return;
    }

    # Email-notify all concerned parties
    #print "---------------------------------</pre>\n";
    local($mail_to);
    $mail_to = join(", ", sort(keys(%mail_to)));
    if ($mail_to ne "") {
	if (open(MAILER, "|$MAILER")) {
	    $msg = 
"To: $mail_to
From: $input{'Editor'}
Subject: Changed information for PR $semipr

Synopsis: $oldsyn

$change_msg
";
	    print MAILER $msg;
	    close(MAILER);

	    # Display message
	    print 
"<H3>Your changes to PR $pr were filed to the database.</H3>
The parties concerned were notified via e-mail as follows:
<br><pre>$msg</pre>
";
	} else {
	    print "Error: can't run $MAILER\n";
	}
    }
}

# Gives the interface to change the PR
sub edit_pr
{
    # Display title
    print "<HEAD><TITLE>Problem Report editing</TITLE></HEAD><BODY>\n";

    $pr = $_[0];
    if ($pr eq "") {
	print "<H3>Sorry</H3>\n";
	print "You must specify the number of the problem report to edit.\n";
	return;
    }
    $err = &read_pr($pr, "");
    if ($err ne "") {
	print "$err\n";
	return;
    }
    local($oldsyn) = $fieldvalues{"Synopsis"};
    local($oldstate) = $fieldvalues{"State"};
    local($oldresp) = $fieldvalues{"Responsible"};
    $oldresp =~ s/\s*\(.*$//; # Get rid of comment in responsible party name

    local($timestamp)=&timestamp($fullpr);

    # The modification form
    print "
<H2>Modification form for PR number $pr</H2>
Synopsis: " . &html_escape($oldsyn) . " <BR>
<A HREF=\"$SCRIPT_NAME/full/$pr\">
Click here to view the full text of PR #$pr
</A>
<P>
<FORM METHOD=\"POST\" ACTION=\"$SCRIPT_NAME/handle_edit_pr/$pr&$oldstate&$timestamp\">
";

    # Maximize box dimensions
    local($width)= 60;
    local($height)= 4;

    print "<dl>
<dt>Editor (you):
<dd><SELECT NAME=\"Editor\" SIZE=10>\n";
    for (sort keys(%nEditor)) {
	print "<OPTION> $_\n";
    }
    print "</SELECT><BR>\n";

    print "<dt>New <a href=\"/cgi-bin/info2www?(gnats.info)States\">state</a>:\n";
    print "<dd>";
    print "<SELECT NAME=\"State\">\n";
    foreach $option (@nState) {
	next if (!$option);
	print "<OPTION";
	if ($option eq $oldstate) { print " SELECTED"; }
	print "> $option\n";
    }
    print 
"</SELECT><BR><dt>If state changed, give the reason here:<dd><TEXTAREA NAME=\"StateReason\" COLS=$width ROWS=$height></TEXTAREA>";

    print "<dt>New category:\n";
    print "<dd>";
    print "<SELECT NAME=\"Category\">\n";
    foreach $option (@nCategory) {
	next if (!$option);
	print "<OPTION";
	if ($option eq $fieldvalues{"Category"}) { print " SELECTED"; }
	print "> $option\n";
    }
    print "</SELECT><BR>\n";

    print "<dt>New responsible person:\n";
    print "<dd>";
    print "<SELECT NAME=\"Responsible\">\n";
    local($somebody_resp);
    foreach $option (@nResponsible) {
	next if (!$option);
	print "<OPTION";
	if ($option eq $oldresp) { print " SELECTED"; $somebody_resp = 1; }
	print "> $option\n";
    }
    print "</SELECT><BR>\n";
    if (! $somebody_resp) {
	print "Error!  No known person responsible for this bug!\n";
    }
    print "<dt>If responsible person changed, give the reason here:";
    print "<dd><TEXTAREA NAME=\"ResponsibleReason\" COLS=$width ROWS=$height></TEXTAREA>\n";

    print "</dl>\n";
    print "<INPUT TYPE=\"submit\" VALUE=\"Click here to submit the changes.\">\n";
    print "</FORM>\n";
}

#################### Quick query
# Truncate a string to the given width, replacing last shown char with $ if truncated.
# Usage: $fstr = &truncstr("long string", $width);
sub truncstr {
    local($str) = shift(@_);
    local($WIDTH) = shift(@_);
    local($W, $fstring);
    # Truncate or pad the variable to the desired width.
    $W=$WIDTH;
    if (length($str)>$WIDTH && $WIDTH) { --$W };
    $fstring = sprintf("%-${W}s",$WIDTH?substr($str,0,$W):$str);
    # Add a $ if we truncated it.
    if (length($str)>$WIDTH && $WIDTH) {
	$fstring .= "\$";
    }
    return $fstring;
}

sub numerically { $a <=> $b; }

sub query_quick {
    # Print title
    print "<head><title>Quick summary of PR's</title></head>
<H2>Quick summary of PR's:</H2>
<body>
";
    #print "args = (@_)\n";
    local($quickfmt,@restrict)=@_;
    # Convert $quickfmt to index into @quickfmt
    LOOP: for ($i=0; $i<@quickfmt; $i++) {
	if ($quickfmt eq $quickfmt[$i]) {
	    $quickfmt=$i;
	    last LOOP;
	}
    }
    # Split restrictions into key,value pairs
    # Collapse multiple selections with same key
    # Store collapsed restrictions in %restrict
    local($oldkey, $oldval);
    local(%restrict);
    foreach (@restrict) {
	$_ = &tolower($_);
	$_ = &cgi_trans($_);
	local($key,$val) = split(/=/);
	if ($key ne $oldkey) {
	    if ($oldval ne "") {
		$restrict{$oldkey} = $oldval;
	    }
	    $oldkey = $key;
	    $oldval = "";
	    $oldval = $val if ($val ne "");
	} else {
	    # just continue adding to old restriction
	    $oldval .= "|" if ($oldval ne "");
	    $oldval .= "$val" if ($val ne "");
	}
    }
    # Could have put a sentinal on the end of @restrict, but let's duplicate
    # code instead.
    if ($oldval ne "") {
	$restrict{$oldkey} = $oldval;
    }
    local($opts);
    local(@prs);
    # Read in quick format list of pr's matching query
    # If querying by person, then do two queries: originator and responsible
    if ($restrict{"person"} ne "") {
	$fullname = $restrict{"person"};
	# Look up bugs for which this person is the originator.
	if ($fullname eq "any") {
	    $opts = "--state=\"open|analyzed|feedback\"";
	} else {
	    $oldval = $fullname;
	    # Turn underscores and spaces into regular expression
	    # that match either underscores or spaces
	    # (Our database sometimes puts underscores instead of spaces).
	    $oldval =~ s/[\s_]/[ _]/g;
	    # Handle bugs with no known originator
	    if ($oldval eq "nobody") {
		$oldval = "nobody|^$";
	    }
	    # Convert this key into a query-pr option
	    $opts = " --originator=\"$oldval\"";
	    # The originator cares about bugs which are in feedback state.
	    $opts .= " --state=\"feedback\"";
	}
	print "<pre>query-pr -i $opts\n</pre>\n";
	open(PIPE,"$GNATS_BIN/query-pr -i $opts|") || die "Can't open";
	@prs = <PIPE>;
	close(PIPE);

	# Look up bugs for which this person is the responsible party.
	# Convert person's name into nickname
	$nickname = $fullname2nametag{$fullname};
	# Golly, maybe the spaces have been replaced with underscores.
	if ($nickname eq "") {
	    $fullname =~ s/_/\040/g;
	    $nickname = $fullname2nametag{$fullname};
	}
	if ($nickname ne "") {
	    # Convert this key into a query-pr option
	    $opts = " --responsible=\"$nickname\"";
	    # Responsible person cares about bugs which are open or analyzed.
	    $opts .= " --state=\"open|analyzed\"";
	    print "<pre>query-pr -i $opts\n</pre>\n";
	    open(PIPE,"$GNATS_BIN/query-pr -i $opts|") || die "Can't open";
	    @prs = (@prs,<PIPE>);
	    close(PIPE);
	} else {
	    #print "Warning: $fullname has no nickname.\n";
	    ;
	}
    } else {
	# Output restrictions as query-pr options
	foreach (keys(%restrict)) {
	    $oldkey = $_;
	    $oldval = $restrict{$oldkey};
	    # If "any" was given, don't bother using this key
	    if ($oldval !~ /\bany\b/) {
		# Turn underscores and spaces into regular expression
		# that match either underscores or spaces
		# (Our database sometimes puts underscores instead of spaces).
		$oldval =~ s/[\s_]/[ _]/g;
		# Convert this key into a query-pr option
		$opts .= " --$oldkey=\"$oldval\"";
	    }
	}
     
	print "<pre>query-pr -i $opts\n</pre>\n";
	open(PIPE,"$GNATS_BIN/query-pr -i $opts|") || die "Can't open";
	@prs = <PIPE>;
	close(PIPE);
    }
    @prs = sort numerically (@prs);
    if (@prs == 0) {
	print "<h3>No bugs match your query.</h3>\n";
	return;
    }
    print "<pre>\n";
    # Print field headers.
    local($QUICKFMT, $WIDTH, $fstring, $str);
    $fstring = "";
    foreach (@field) {
	($QUICKFMT, $WIDTH)=split(/:/,$field{$_});
	if ($QUICKFMT <= $quickfmt) {
	    $fstring .= &truncstr($_, $WIDTH) . " ";
	}
    }
    print "     ",$fstring,"\n"; 
    # Print each PR in result as link to full text 
    foreach (@prs) {
	s/\s*\|\s*/|/go;
	( $NUMBER,
	$CATEGORY,
	$SYNOPSIS,
	$CONFIDENTIAL,
	$SEVERITY,
	$PRIORITY,
	$RESPONSIBLE,
	$STATE,
	$CLASS,
	$SUBMITTER,
	$ARRIVAL_DATE,
	$ORIGINATOR,
	$RELEASE ) = split(/\|/, $_);
	$SEVERITY = $quickSeverity[$SEVERITY];
	$PRIORITY = $quickPriority[$PRIORITY];
	$STATE = $nState[$STATE];
	$CLASS = $nClass[$CLASS];

	$fstring = sprintf("%s", substr("    ", 0, (length($NUMBER)<5)?4-length("$NUMBER"):1));
	# @field is an array of the variable names $NUMBER, etc., in presentation order.
	# %field tells which quickfmt level and ?below? to print this variable
	#       in, and how wide to print it.
	foreach (@field) {
	    ($QUICKFMT, $WIDTH)=split(/:/,$field{$_});
	    if ($QUICKFMT <= $quickfmt) {
		$str = eval "\$$_";
		$fstring .= &truncstr($str, $WIDTH) . " ";
	    }
	}
	print "<a href=http:$SCRIPT_NAME/full/$NUMBER>$NUMBER</a> ",&html_escape($fstring),"\n"; 
    } 
    print "</pre>\n";
}

sub query_summary {
    # Print title
    print "<head><title>Summary of active PR's by person and status</title></head>
<H2>Summary of active PR's by person and status:</H2>
<body>
";
    #print "<pre>query-pr -i --state=\"open|analyzed|feedback\" \n</pre>\n";
    open(PIPE,"$GNATS_BIN/query-pr -i --state=\"open|analyzed|feedback\" |") || die "Can't open";
    @prs = <PIPE>;
    close(PIPE);
    if (@prs == 0) {
	print "<h3>No bugs match your query.</h3>\n";
	return;
    }
    # Count bugs by person.
    # Print each PR in result as link to full text 
    local(%counts,%names);
    foreach (@prs) {
	s/\s*\|\s*/|/go;
	( $NUMBER,
	$CATEGORY,
	$SYNOPSIS,
	$CONFIDENTIAL,
	$SEVERITY,
	$PRIORITY,
	$RESPONSIBLE,
	$STATE,
	$CLASS,
	$SUBMITTER,
	$ARRIVAL_DATE,
	$ORIGINATOR,
	$RELEASE ) = split(/\|/, $_);
	$STATE = $nState[$STATE];

	#print "$STATE, $ORIGINATOR, $RESPONSIBLE    ";
	# Figure out which person this bug is waiting on, if any
	if ($STATE eq "open" || $STATE eq "analyzed") {
	    # Waiting on responsible person
	    # Convert nickname to fullname
	    $nickname = $RESPONSIBLE;
	    $nickname = &tolower($nickname);
	    $fullname = $nametag2fullname{$nickname};
	    if ($fullname eq "") {
		$fullname = $nickname;
	    }
	} elsif ($STATE eq "feedback") {
	    $fullname = $ORIGINATOR;
	    $fullname = &tolower($fullname);
	    $fullname =~ tr/_/\040/;
	}
	if ($fullname eq "") {
	    $fullname = "nobody";
	}

	if ($STATE eq "open" || $STATE eq "analyzed" || $STATE eq "feedback") {
	    #print "counts{$fullname._.$STATE}++";
	    $counts{$fullname."_".$STATE}++;
	    $names{$fullname}++;
	}
	#print "\n";
    } 
    #print "</pre>\n";

    # Print field headers.
    print "<pre>\n";
    local(@states) = ("open", "analyzed", "feedback");
    local($fstring, $str);
    $fstring = &truncstr("", 20)."   ";
    foreach (@states) {
	$fstring .= &truncstr($_, 10) . " ";
    }
    print $fstring,"\n"; 
    # Print counts per person.
    foreach $fullname (sort(keys(%names))) {
	$fstring = &truncstr($fullname, 20)."   ";
	local($_fullname) = $fullname;
	$_fullname =~ tr/ /_/;
	$fstring =~ s/(\s*)$//;
	print "<a href=http:$SCRIPT_NAME/quick?quickfmt=regular&Person=$_fullname>$fstring</a>$1"; 
	$fstring = "";
	foreach (@states) {
	    $str = $counts{$fullname."_".$_}+0;
	    $fstring .= &truncstr($str, 10) . " ";
	}
	print "$fstring\n";
    }
    print "</pre>\n";
}
    
sub query_summary_cat {
    # Print title
    print "<head><title>Summary of PR's by category and status</title></head>
<H2>Summary of PR's by category and status:</H2>
<body>
";
    #print "<pre>query-pr -i \n</pre>\n";
    open(PIPE,"$GNATS_BIN/query-pr -i |") || die "Can't open";
    @prs = <PIPE>;
    close(PIPE);
    if (@prs == 0) {
	print "<h3>No bugs match your query.</h3>\n";
	return;
    }
    # Count bugs by category.
    # Print each PR in result as link to full text 
    local(%counts,%names,%states);
    foreach (@prs) {
	s/\s*\|\s*/|/go;
	( $NUMBER,
	$CATEGORY,
	$SYNOPSIS,
	$CONFIDENTIAL,
	$SEVERITY,
	$PRIORITY,
	$RESPONSIBLE,
	$STATE,
	$CLASS,
	$SUBMITTER,
	$ARRIVAL_DATE,
	$ORIGINATOR,
	$RELEASE ) = split(/\|/, $_);
	$STATE = $nState[$STATE];

	#print "$STATE, $ORIGINATOR, $RESPONSIBLE    ";
	#print "counts{$CATEGORY._.$STATE}++";
	$counts{$CATEGORY."_".$STATE}++;
	$names{$CATEGORY}++;
	$states{$STATE}++;
	#print "\n";
    } 
    #print "</pre>\n";

    # Print field headers.
    print "<pre>\n";
    local(@states) = sort(keys(%states));
    local($fstring, $str);
    $fstring = &truncstr("", 20)."   ";
    foreach (@states) {
	$fstring .= &truncstr($_, 10) . " ";
    }
    print $fstring,"\n"; 
    # Print counts per person.
    foreach $CATEGORY (sort(keys(%names))) {
	$fstring = &truncstr($CATEGORY, 20)."   ";
	$fstring =~ s/(\s*)$//;
	print "<a href=http:$SCRIPT_NAME/quick?quickfmt=regular&Category=$CATEGORY>$fstring</a>$1"; 
	$fstring = "";
	foreach (@states) {
	    next if ($_ eq "");
	    $str = $counts{$CATEGORY."_".$_}+0;
	    if ($str > 0) {
		# Who's gonna answer the following query?
		$fstring .= "<a href=http:$SCRIPT_NAME/quick?quickfmt=regular&Category=$CATEGORY&State=$_>$str</a>"; 
		$fstring .= " " x (11-length($str));
	    } else {
		$fstring .= &truncstr($str, 10) . " ";
	    }
	}
	print "$fstring\n";
    }
    print "</pre>\n";
}
    
#################### Full query
sub query_full
{
    local($pr) = $_[0];
    print "<head><title>Full Problem Report Text</title></head>
<body>
";
    if ($pr eq "") {
	print "<H3>Sorry</H3>\n";
	print "You must specify the number of the problem report to view.\n";
	return;
    }
    $err = &read_pr($pr, "");
    if ($err ne "") {
	print "$err\n";
    } else {
	print "
<FORM ACTION=\"http:$SCRIPT_NAME/edit_pr\">
<INPUT TYPE=\"submit\" VALUE=\"Click here to edit\">
<INPUT NAME=\"pr\" TYPE=\"hidden\" VALUE=\"$pr\">
</FORM>
<H2>Full text of PR number $pr:</H2>
";
	print "<pre>\n";
	$prtext = &html_escape(join("",@oldpr));
	print $prtext;
	print "</pre>\n";
    }
}

#################### Main Menu

# Very first page of front end
sub main_menu {
    # Display title
    print "<head><title>Ace Bug Tracking System</title></head>
<H2>Ace Bug Tracking System</H2>
<body>
";

    print "
<a href=\"/cgi-bin/info2www?(gnats)\">
Click here for an introduction to the GNATS Bug Tracking software,
</a>
or choose one of the following seven commands:
<ol>
<li><FORM ACTION=\"http:$SCRIPT_NAME/send_pr\">
<INPUT TYPE=\"submit\" VALUE=\"Submit a new problem report\">
</FORM>

<li><FORM ACTION=\"http:$SCRIPT_NAME/edit_pr\">
Enter PR number <INPUT NAME=\"pr\" SIZE=6>
and click here to <INPUT TYPE=\"submit\" VALUE=\"Edit existing PR \">
</FORM>

<li><FORM ACTION=\"http:$SCRIPT_NAME/full\">
Enter PR number <INPUT NAME=\"pr\" SIZE=6>
and click here to <INPUT TYPE=\"submit\" VALUE=\"View existing PR \">
</FORM>

<li><FORM ACTION=\"http:$SCRIPT_NAME/summary\">
<INPUT TYPE=\"submit\" VALUE=\"Get a summary of active bugs by status and person\">.
</FORM>
<li><FORM ACTION=\"http:$SCRIPT_NAME/summary_cat\">
<INPUT TYPE=\"submit\" VALUE=\"Get a summary of all bugs by status and category\">.
</FORM>
";

    #------------------------------------------------------------------
    # Bug look-up by person
    print "<hr>\n";
    print "<li>Fill out this form to look up active bugs by who is supposed to be working on them\n";
    print "<FORM ACTION=\"http:$SCRIPT_NAME/quick\">\n";
    # Choose quick output format.
    print "Select \n";
    print "<SELECT NAME=\"quickfmt\">\n";
    foreach (@quickfmt) {
	print "<OPTION", ($_ eq "regular") ? " SELECTED" : "", "> $_\n";
    }
    print "</SELECT> output format. <BR>\n";
    foreach ("Person") {
	# Make sure choices fit within window
	$mode = @nOriginator >30 ? "SIZE=2" : "";
	print "<DT> Name\n";
        print "<DD>";
        print "<SELECT $mode NAME=\"$_\">\n";
	# Refer to arrays @nCategory, @nState, @nResponsible as appropriate.
        foreach $option (@nOriginator) {
	    $option="any" if (!$option);
	    print "<OPTION", ($option eq $quickrestr{$_}) ? " SELECTED" : "", "> $option\n";
	}
        print "</SELECT>\n";
    }
    print "<p>and <INPUT TYPE=\"submit\" VALUE=\"click here to search\">. <BR>\n";
    print "</form>\n";

    #------------------------------------------------------------------
    # Quick query
    print "<hr>\n";
    print "<li>Fill out the following form to look up bugs any which way:";
    print "<br><FORM ACTION=\"http:$SCRIPT_NAME/quick\">\n";

    # Choose quick output format.
    print "Select \n";
    print "<SELECT NAME=\"quickfmt\">\n";
    foreach (@quickfmt) {
	print "<OPTION", ($_ eq "regular") ? " SELECTED" : "", "> $_\n";
    }
    print "</SELECT> output format. <BR>\n";

    local($mode);
    print "<BR>Restrict the output by specifying a value for one or more
<a href=\"/cgi-bin/info2www?(gnats.info)Problem%20Report%20fields\">problem report fields</a>\n";
    print "<DL>\n";
    # Loop over output restrictions (Category, State, Responsible).
    foreach (@quickrestr) {
	# Make sure choices fit within window
	#$mode = $HTTP_AGENT=~/X Win/ && eval"\@n$_">20 ? "SIZE=10" : "";
	$mode = eval"\@n$_">30 ? "SIZE=2" : "";
	# Let user select more than one choice for "State".
	if ($_ eq "State") {
	    $mode = "SIZE=". eval"\@n$_";
	    $mode .= " MULTIPLE";
	}
	print "<DT> $_\n";
        print "<DD>";
        print "<SELECT $mode NAME=\"$_\">\n";
	# Refer to arrays @nCategory, @nState, @nResponsible as appropriate.
	# Note use of eval.
        foreach $option (eval "\@n$_") {
	    $option="any" if (!$option);
	    print "<OPTION", ($option eq $quickrestr{$_}) ? " SELECTED" : "", "> $option\n";
	}
        print "</SELECT>";
    }

    # Loop over freeform search restrictions (Text, Multitext).
    print "</DL>\n";
    print "and/or specifying a 
<a href=\"/cgi-bin/info2www?(gnats.info)Regexps\">freeform text search</a>
on
<a href=\"/cgi-bin/info2www?(gnats.info)Fields\">any GNATS field</a>.\n";
    print "<DL>\n";
    foreach ("Text", "Multitext") {
	print "<DT>$_\n";
        print "<DD>\n";
        print "<INPUT NAME=\"$_\" SIZE=\"32\">\n";
    }
    print "</DL>
<BR>Finally, <INPUT TYPE=\"submit\" VALUE=\"click here to search\">. <BR>
</FORM>
</ol>
";
}
