/* Global variable declarations. 
   Copyright (C) 1993, 1994, 1995 Free Software Foundation, Inc.
   Contributed by Tim Wicinski (wicinski@barn.com).
   Further hacked by Brendan Kehoe (brendan@cygnus.com).

This file is part of GNU GNATS.

GNU GNATS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU GNATS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU GNATS; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111, USA.  */

#ifndef _globals_h
#define _globals_h 1

/* Get `PARAMS'.  */
#include <ansidecl.h>

/* Whether or not to automatically create a directory for an unrecognized
   category.  Not used (yet).  */
extern int flag_autocreate;

/* If true, send the submitter an acknowledgement.  */
extern int flag_ack;

/* If true, don't send any notification.  */
extern int flag_notify;

/* Current version of GNATS.  */
extern char *version_string;

/* Defined in pr.c.  */
extern PR_entry pr[NUM_PR_ITEMS];

/* Head of linked list of responsible people. */
extern Responsible *responsible_chain;

/* Where to keep the static index if necessary.  */
extern Index *index_chain;

#ifndef LOGGING 
# ifdef HAVE_SYSLOG_H
#  define LOGGING SYSLOG
#  ifndef LOG_LEVEL
#   ifdef LOG_USER
#    define LOG_LEVEL LOG_USER
extern int log_level;
#   endif
#  endif
# else /* !HAVE_SYSLOG_H */
/* FIXME */
#  define LOGGING MAIL
#  define LOG_ERR 0
#  define LOG_INFO 1
# endif /* HAVE_SYSLOG_H */
#endif /* LOGGING */

#define LOG_NONE -1

/* Safely append a string.  */
#define APPEND_STRING(from, to, to_ptr, to_len, to_max, l, free_from)	\
 { if (from)							\
    {								\
      (l) = strlen (from);					\
      if ((to_len) + (l) > (to_max))				\
	{							\
	  (to_max) += BUFSIZ;					\
	  (to) = (char *) xrealloc ((to), (to_max));		\
	  (to_ptr) = (to) + (to_len);				\
	}							\
      memcpy ((to_ptr), (from), (l));				\
      (to_len) += (l);						\
      (to_ptr) += (l);						\
      if (free_from) free (from);				\
    }								\
 }

/* For struct tm.  */
#include <time.h>

/* In btime.c */
extern struct tm *get_response_time	PARAMS((int));

/* in gnats.c */
extern void gnats			PARAMS((FILE *));
extern char *check_if_reply		PARAMS((void));
extern void append_report		PARAMS((FILE *, char *));

/* in files.c */
extern int find_category		PARAMS((Category*, char *));
extern int find_submitter		PARAMS((Submitter*, char *));
extern int init_responsibles		PARAMS((void));
extern void free_responsible		PARAMS((Responsible*));

/* in resp_lookup.c */
extern Responsible* get_responsible		PARAMS((Category *));

#endif /* !_globals_h  */
