/* Codes returned by the GNATS server.
   Copyright (C) 1994 Free Software Foundation, Inc.
   Contributed by Brendan Kehoe (brendan@cygnus.com).

This file is part of GNU GNATS.

GNU GNATS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU GNATS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU GNATS; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111, USA.  */

#ifdef HAVE_NETDB_H
#include <netdb.h>
#endif

/* The information we need for a reply from the server.  */
typedef struct _reply
{
  int state;
  char *text;
  int type;
} Reply;

typedef enum _msg_type {
  PR_eof, PR_ok, PR_long, PR_timeout
} MsgType;

/* in gnatsd.c */
extern MsgType get_line			PARAMS((char *, int, int));

/* cmds.c */
extern void GNATS_helo			PARAMS((int, char**));
extern void GNATS_quit			PARAMS((int, char**));
extern void GNATS_qury			PARAMS((int, char**));
extern void GNATS_summ			PARAMS((int, char**));
extern void GNATS_sqlf			PARAMS((int, char**));
extern void GNATS_full			PARAMS((int, char**));
extern void GNATS_lock			PARAMS((int, char**));
extern void GNATS_unlk			PARAMS((int, char**));
extern void GNATS_edit			PARAMS((int, char**));
extern void GNATS_mlpr			PARAMS((int, char**));
extern void GNATS_mlct			PARAMS((int, char**));
extern void GNATS_mlsu			PARAMS((int, char**));
extern void GNATS_type			PARAMS((int, char**));
extern void GNATS_resp			PARAMS((int, char**));
extern void GNATS_catg			PARAMS((int, char**));
extern void GNATS_conf			PARAMS((int, char**));
extern void GNATS_svty			PARAMS((int, char**));
extern void GNATS_stat			PARAMS((int, char**));
extern void GNATS_sear			PARAMS((int, char**));
extern void GNATS_msrc			PARAMS((int, char**));
extern void GNATS_clss			PARAMS((int, char**));
extern void GNATS_bfor			PARAMS((int, char**));
extern void GNATS_aftr			PARAMS((int, char**));
extern void GNATS_vdat			PARAMS((int, char**));
extern void GNATS_orig			PARAMS((int, char**));
extern void GNATS_prio			PARAMS((int, char**));
extern void GNATS_subm			PARAMS((int, char**));
extern void GNATS_text			PARAMS((int, char**));
extern void GNATS_mtxt			PARAMS((int, char**));
extern void GNATS_rset			PARAMS((int, char**));
extern void GNATS_auth			PARAMS((int, char**));
extern void GNATS_lcat			PARAMS((int, char**));
extern void GNATS_lres			PARAMS((int, char**));
extern void GNATS_lsub			PARAMS((int, char**));
extern void GNATS_bfor			PARAMS((int, char**));
extern void GNATS_aftr			PARAMS((int, char**));
extern void GNATS_vdat			PARAMS((int, char**));
extern void GNATS_load			PARAMS((int, char**));
extern void GNATS_chst			PARAMS((int, char**));
extern void GNATS_chre			PARAMS((int, char**));
extern void GNATS_chor			PARAMS((int, char**));
extern void GNATS_chsu			PARAMS((int, char**));
extern void GNATS_chsy			PARAMS((int, char**));
extern void GNATS_chco			PARAMS((int, char**));
extern void GNATS_chse			PARAMS((int, char**));
extern void GNATS_chpr			PARAMS((int, char**));
extern void GNATS_chct			PARAMS((int, char**));
extern void GNATS_chrl			PARAMS((int, char**));
extern void GNATS_chcl			PARAMS((int, char**));
extern void GNATS_nocl			PARAMS((int, char**));
extern void GNATS_help			PARAMS((int, char**));

#include <netinet/in.h> /* for sockaddr_in */
#include <arpa/inet.h>	/* for inet_ntoa decl */
#include <sys/param.h>
#include <netdb.h>	/* for hostent and MAXHOSTNAMELEN */
#include <sys/socket.h>	/* for AF_INET */
#include <sys/time.h>	/* for timeval */
#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>	/* for fd_set */
#endif

/* Whether we received `STATE-' or `STATE '.  */
#define REPLY_CONT	1
#define REPLY_END	2

/* Used if Kerberos version 4 authentication is enabled.  */
#define GNATS_KRB4_VERSIONID		"GnatsK1.0"
#define GNATS_KRB4_PRINCIPAL_NAME	gnats_user

/* Directives for the pseudo-protocol.  */
#define CODE_GREETING		200
#define CODE_OK			210
#define CODE_PR_READY		220
#define CODE_CLOSING		205
#define CODE_INFORMATION	230
#define CODE_HELLO		250

#define CODE_INVALID_PR		410
#define CODE_INVALID_CATEGORY	420
#define CODE_UNREADABLE_PR	430
#define CODE_NO_PRS		440
#define CODE_NO_KERBEROS	450
#define CODE_AUTH_TYPE_UNSUP	451
#define CODE_INVALID_SUBMITTER	460
#define CODE_INVALID_RESPONSIBLE 465
#define CODE_INVALID_DATE	468
#define CODE_NO_INDEX		470
#define CODE_FILE_ERROR		480
#define CODE_LOCKED_PR		490
#define CODE_GNATS_LOCKED	491
#define CODE_PR_NOT_LOCKED	495

#define CODE_ERROR		500
#define CODE_TIMEOUT		510
#define CODE_NO_ACCESS		520
