/* Pieces of the actual PR.
   Copyright (C) 1993 Free Software Foundation, Inc.
   Contributed by Tim Wicinski (wicinski@barn.com).

This file is part of GNU GNATS.

GNU GNATS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU GNATS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU GNATS; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111, USA.  */

#ifndef _pr_h_
#define _pr_h_

typedef enum
{ 
  NUMBER,              /* Supplied by Receiver */
  CATEGORY,            /* Supplied by Sender */
  SYNOPSIS,            /* Supplied by Sender */
  CONFIDENTIAL,        /* Supplied by Sender */
  SEVERITY,            /* Supplied by Sender */
  PRIORITY,            /* Supplied by Sender */
  RESPONSIBLE,         /* Supplied by Receiver */
  STATE,               /* Supplied by Receiver */
#ifdef GNATS_RELEASE_BASED
  QUARTER,             /* Supplied by Sender */
  KEYWORDS,            /* Supplied by Sender */
  DATE_REQUIRED,       /* Supplied by Sender */
#endif
  CLASS,               /* Supplied by Receiver */
  SUBMITTER,	       /* Supplied by Sender */
  ARRIVAL_DATE,        /* Supplied by Receiver */
  LAST_MODIFIED,       /* Supplied by Receiver */
  ORIGINATOR,          /* Supplied by Sender */
  ORGANIZATION,        /* Supplied by Sender */
  RELEASE,             /* Supplied by Sender */
  ENVIRONMENT,         /* Supplied by Sender */
  DESCRIPTION,         /* Supplied by Sender */
  HOW_TO_REPEAT,       /* Supplied by Sender */
  FIX,		       /* Supplied by either */
  AUDIT_TRAIL,         /* Supplied by Receiver */
  UNFORMATTED,         /* Catch all field */
  NUM_PR_ITEMS	/* this needs to stay in */
} PR_Name;	

typedef enum
{
  Nil, Text, MultiText, Enum, Integral, Receiver, Date
} PR_Type;

typedef struct
{
  /* name of the field.  */
  char *name;
  /* actual value of the entry */
  char *value;
  /* default value for the field */
  char *default_value;
  /* if variant is enum, what are the values */
  char *enum_values;
  /* type of data that will be accepted */
  PR_Type datatype;
} PR_entry;

typedef struct index_entry
{
  char *category;
  char *number;
  char *submitter;
  char *responsible;
  char *state;
  char *confidential;
  char *severity;
  char *priority;
#ifdef GNATS_RELEASE_BASED
  char *date_required;
#endif

  struct index_entry *next;
} Index;

/* These will eventually be properly configurable.  */
#define PR_START_FIELD		'>'

#define ARRIVAL_DATE_STRING	">Arrival-Date:"
#define AUDIT_TRAIL_STRING	">Audit-Trail:"
#define CATEGORY_STRING		">Category:"
#define CLASS_STRING		">Class:"
#ifdef GNATS_RELEASE_BASED
#define QUARTER_STRING		">Quarter:"
#define KEYWORDS_STRING		">Keywords:"
#endif
#define CONFIDENTIAL_STRING 	">Confidential:"
#define SUBMITTER_STRING 	">Submitter-Id:"
#define ALTERNATE_SUBMITTER	">Customer-Id:"
#define DESCRIPTION_STRING 	">Description:"
#define ENVIRONMENT_STRING 	">Environment:"
#define HOW_TO_REPEAT_STRING 	">How-To-Repeat:"
#define NUMBER_STRING 		">Number:"
#ifdef GNATS_RELEASE_BASED
#define DATE_REQUIRED_STRING	">Date-Required:"
#endif
#define LAST_MODIFIED_STRING	">Last-Modified:"
#define ORGANIZATION_STRING 	">Organization:"
#define ORIGINATOR_STRING 	">Originator:"
#define PRIORITY_STRING 	">Priority:"
#define RELEASE_STRING 		">Release:"
#define RESPONSIBLE_STRING 	">Responsible:"
#define SEVERITY_STRING 	">Severity:"
#define STATE_STRING 		">State:"
#define SYNOPSIS_STRING 	">Synopsis:"
#define UNFORMATTED_STRING 	">Unformatted:"
#define FIX_STRING		">Fix:"

#endif /* _pr_h_ */
