/*
 * Copyright 1993 by OpenVision Technologies, Inc.
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appears in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of OpenVision not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission. OpenVision makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 * 
 * OPENVISION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL OPENVISION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * $Id: util_cksum.c,v 1.13 1996/08/28 21:49:24 tytso Exp $
 */

#include "gssapiP_krb5.h"
#include <memory.h>

krb5_error_code
kg_checksum_channel_bindings(context, cb, cksum, bigend)
     krb5_context context;
     gss_channel_bindings_t cb;
     krb5_checksum *cksum;
     int bigend;
{
   int len;
   char *buf, *ptr;
   krb5_error_code code;

   /* initialize the the cksum and allocate the contents buffer */
   cksum->checksum_type = CKSUMTYPE_RSA_MD5;
   cksum->length = krb5_checksum_size(context, CKSUMTYPE_RSA_MD5);
   if ((cksum->contents = (krb5_octet *) xmalloc(cksum->length)) == NULL) {
      return(ENOMEM);
   }
 
   /* generate a buffer full of zeros if no cb specified */

   if (cb == GSS_C_NO_CHANNEL_BINDINGS) {
      memset(cksum->contents, '\0', cksum->length);
      return(0);
   }

   /* create the buffer to checksum into */

   len = (sizeof(krb5_int32)*5+
	  cb->initiator_address.length+
	  cb->acceptor_address.length+
	  cb->application_data.length);

   if ((buf = (char *) xmalloc(len)) == NULL)
      return(ENOMEM);

   /* helper macros.  This code currently depends on a long being 32
      bits, and htonl dtrt. */

   ptr = buf;

   TWRITE_INT(ptr, cb->initiator_addrtype, bigend);
   TWRITE_BUF(ptr, cb->initiator_address, bigend);
   TWRITE_INT(ptr, cb->acceptor_addrtype, bigend);
   TWRITE_BUF(ptr, cb->acceptor_address, bigend);
   TWRITE_BUF(ptr, cb->application_data, bigend);

   /* checksum the data */

   if (code = krb5_calculate_checksum(context, CKSUMTYPE_RSA_MD5, 
				      buf, len, NULL, 0, cksum)) {
      xfree(cksum->contents);
      xfree(buf);
      return(code);
   }

   /* success */

   xfree(buf);
   return(0);
}
