const char rcsid_dbcheck_c[] = "$Id: pkscheck.c,v 1.2 1999/01/12 20:47:05 hironobu Exp hironobu $";

/* 
 * Copyright (c) 1996, Marc Horowitz.  All rights reserved.
 * See the LICENSE file in the release for redistribution information.
 */


#include <db.h>
#include <stdio.h>
#include <stdlib.h>

#include "database.h"
#include "globals.h"
#include "kd_internal.h"

void usage(char *argv0)
{
   fprintf(stderr,
	   "%s /db/path\n",
	   argv0);
   exit(1);
}

int main(int argc, char *argv[])
{
   char *dir, *str;
   DBC *cursor;
   DBT ikey, idata, kkey, kdata;
   int ret, i;
   char buf[1024];

   if (argc < 2)
      usage(argv[0]);

   dir = argv[1];
   log_terminal = 1;

   if (!kd_open(dir, &str)) {
      fprintf(stderr, "database open failed: %s\n", str);
      free(str);
      exit(1);
   }

   if ((ret = (*(worddb->cursor))(worddb, NULL, &cursor))) {
      sprintf(buf, "error creating worddb cursor: error = %d", ret);
      log_error("main", buf);
   }

   for (ret = (*(cursor->c_get))(cursor, &ikey, &idata, DB_FIRST);
	ret == 0;
	ret = (*(cursor->c_get))(cursor, &ikey, &idata, DB_NEXT)) {
      if (idata.size%12) {
	 sprintf(buf, "worddb corrupt in entry = \"%.*s\", size = %d\n",
		 (int) ikey.size, (char *) ikey.data, (int) idata.size);

	 log_error("main", buf);
      }

      for (i=0; i<idata.size; i+=12) {
	 kkey.size = 4;
	 kkey.data = ((unsigned char *) idata.data)+i+8;
#ifdef MULTI_DB
	 {
	   extern DB *keydb_array[];
	   extern int which_db(void *byte);
	   keydb=keydb_array[where_db(kkey.data)];
	 }
#endif
	 if ((*(keydb->get))(keydb, NULL, &kkey, &kdata, 0)) {
	    sprintf(buf, "keyid %02X%02X%02X%02X in worddb but not keydb\n",
		    ((unsigned char *) kkey.data)[0],
		    ((unsigned char *) kkey.data)[1],
		    ((unsigned char *) kkey.data)[2],
		    ((unsigned char *) kkey.data)[3]);
	    log_error("main", buf);
	 }
      }
   }

   (*(cursor->c_close))(cursor);

   if ((ret = (*(timedb->cursor))(timedb, NULL, &cursor))) {
      sprintf(buf, "error creating timedb cursor: error = %d", ret);
      log_error("main", buf);
   }

   for (ret = (*(cursor->c_get))(cursor, &ikey, &idata, DB_FIRST);
	ret == 0;
	ret = (*(cursor->c_get))(cursor, &ikey, &idata, DB_NEXT)) {
      if (idata.size%12) {
	 sprintf(buf, "timedb corrupt in entry = \"%.*s\", size = %d\n",
		 (int) ikey.size, (char *) ikey.data, (int) idata.size);

	 log_error("main", buf);
      }

      for (i=0; i<idata.size; i+=12) {
	 kkey.size = 4;
	 kkey.data = ((unsigned char *) idata.data)+i+8;
#ifdef MULTI_DB
	 {
	   extern DB *keydb_array[];
	   extern int which_db(void *byte);
	   keydb=keydb_array[where_db(kkey.data)];
	 }
#endif
	 if ((*(keydb->get))(keydb, NULL, &kkey, &kdata, 0)) {
	    sprintf(buf, "keyid %02X%02X%02X%02X in timedb but not keydb\n",
		    ((unsigned char *) kkey.data)[0],
		    ((unsigned char *) kkey.data)[1],
		    ((unsigned char *) kkey.data)[2],
		    ((unsigned char *) kkey.data)[3]);
	    log_error("main", buf);
	 }
      }
   }

   (*(cursor->c_close))(cursor);

   kd_close();

   exit(0);
}
