#!@PERL@
##########################################################
# this is the base file every test is using ....
# this is made for not changing every file if we want to
# add an option or just want to change something in
# code what is the same in every file ...
##########################################################

#
# The exported values are:

# $opt_...	Various options
# $date		Current date in ISO format
# $server	Object for current server
# $limits	Hash reference to limits for benchmark

$benchmark_version="1.1";
use Getopt::Long;

require "$pwd/server-cfg" || die "Can't read Configuration file: $!\n";

$|=1;				# Output data immediately

$opt_skip_test=$opt_skip_create=$opt_skip_delete=$opt_verbose=$opt_fast_insert=$opt_lock_tables=$opt_debug=$opt_skip_delete=$opt_fast=$opt_force=$opt_log=$opt_use_old_results=$opt_help=0;
$opt_cmp=$opt_user=$opt_password="";
$opt_server="mysql"; $opt_dir="output";
$opt_host="localhost";$opt_database="test";
$opt_machine=""; $opt_suffix="";

$opt_time_limit=10*60;		# Don't wait more than 10 min for some tests

$log_prog_args=join(" ", skip_arguments(\@ARGV,"comments","cmp","server",
					"user", "host", "database", "password",
					"use-old-results","skip-test",
					"machine", "dir", "suffix", "log"));
GetOptions("skip-test=s","comments=s","cmp=s","server=s","user=s","host=s","database=s","password=s","loop-count=i","skip-create","skip-delete","verbose","fast-insert","lock-tables","debug","fast","force","field-count=i","regions=i","groups=i","time-limit=i","log","use-old-results","machine=s","dir=s","suffix=s","help") || usage();

usage() if ($opt_help);
$server=get_server($opt_server);
$limits=merge_limits($server,$opt_cmp);
$date=date();
@estimated=(0.0,0.0,0.0);		# For estimated time support

if (length($opt_cmp) && index($opt_cmp,$opt_server) < 0)
{
  $opt_cmp.=",$opt_server";
}
$opt_cmp=lc(join(",",sort(split(',',$opt_cmp))));

#
# set opt_lock_tables if one uses --fast and drivers supports it
#

if (($opt_lock_tables || $opt_fast) && $server->{'limits'}->{'lock_tables'})
{
  $opt_lock_tables=1;
}
else
{
  $opt_lock_tables=0;
}
if ($opt_fast)
{
  $opt_fast_insert=1;
  $opt_suffix="_fast" if (!length($opt_suffix));
}


if (!$opt_silent)
{
  print "Testing server '" . $server->version() . "' at $date\n\n";
}

if ($opt_debug)
{
  print "\nCurrent limits: \n";
  foreach $key (sort keys %$limits)
  {
    print $key . " " x (30-length($key)) . $limits->{$key} . "\n";
  }
  print "\n";
}

#
# Some help functions
#

sub skip_arguments
{
  my($argv,@skip_args)=@_;
  my($skip,$arg,$name,@res);

  foreach $arg (@$argv)
  {
    if ($arg =~ /^\-+([^=]*)/)
    {
      $name=$1;
      foreach $skip (@skip_args)
      {
	if (index($skip,$name) == 0)
	{
	  $name="";		# Don't use this parameters
	  last;
	}
      }
      push (@res,$arg) if (length($name));
    }
  }
  return @res;
}


sub merge_limits
{
  my ($server,$cmp)= @_;
  my ($name,$tmp_server,$limits,$res_limits,$limit,$tmp_limits);

  $res_limits=$server->{'limits'};
  if ($cmp)
  {
    foreach $name (split(",",$cmp))
    {
      $tmp_server= get_server($name) || die "Unknown SQL server: $name\n";
      $limits=$tmp_server->{'limits'};
      %new_limits=();
      foreach $limit (keys(%$limits))
      {
	if (defined($res_limits->{$limit}) && defined($limits->{$limit}))
	{
	  $new_limits{$limit}=min($res_limits->{$limit},$limits->{$limit});
	}
      }
      %tmp_limits=%new_limits;
      $res_limits=\%tmp_limits;
    }
  }
  return $res_limits;
}

sub date
{
  my ($sec, $min, $hour, $mday, $mon, $year) = localtime(time());
  sprintf("%04d-%02d-%02d %2d:%02d:%02d",
	  1900+$year,$mon+1,$mday,$hour,$min,$sec);
}

sub min
{
  my($min)=$_[0];
  my($i);
  for ($i=1 ; $i <= $#_; $i++)
  {
    $min=$_[$i] if ($min > $_[$i]);
  }
  return $min;
}


#
# Execute many statements in a row
#

sub do_many
{
  my ($dbh,@statements)=@_;
  my ($statement);

  foreach $statement (@statements)
  {
    if (!($sth=$dbh->do($statement)))
    {
      die "Can't execute command '$statement'\nError: $DBI::errstr\n";
    }
  }
}

#
# Do a query and fetch all rows from a statement and return the number of rows
#

sub fetch_all_rows
{
  my ($dbh,$query)=@_;
  my ($count,$sth);
  $count=0;

  print "$query\n" if ($opt_debug);
  return undef if (!($sth= $dbh->prepare($query)));
  if (!$sth->execute)
  {
    print "Error occured with execute($query)\n -> $DBI::errstr\n" if ($opt_debug);
    $sth->finish;
    return undef;
  }
  while ($sth->fetchrow_arrayref)
  {
    $count++;
  }
  $sth->finish;
  undef($sth);
  return $count;
}

#
# Handle estimated time of the server is too slow
# Returns 0 if one should continue as normal
#

sub predict_query_time
{
  my ($loop_time,$end_time,$count_ref,$loop,$loop_count)= @_;
  my ($k,$tmp);

  if (($end_time->[0] - $loop_time->[0]) > $opt_time_limit)
  {
    # We can't wait until the SUN dies.  Try to predict the end time
    $loop+=1.0;			# loop was 0 based
    if ($loop != $loop_count)
    {
      $tmp=($end_time->[0] - $loop_time->[0]);
      print "Note: The query took longer then time-limit: $opt_time_limit; Estimating end time based on:\n";
      print "$$count_ref queries in $loop loops of $loop_count loops took $tmp seconds\n";
      for ($k=0; $k < 3; $k++)
      {
	$tmp=$loop_time->[$k]+($end_time->[$k]-$loop_time->[$k])/$loop*
	  $loop_count;
	$estimated[$k]+=($tmp-$end_time->[$k]);
	$end_time->[$k]=$tmp;
      }
      $$count_ref= $$count_ref/$loop*$loop_count;
      return 1;
    }
  }
  return 0;
}

#
# standard end of benchmark
#

sub end_benchmark
{
  my ($start_time)=@_;

  $end_time=new Benchmark;
  if ($estimated[0])
  {
    print "Estimated total time: ";
    $end_time->[0]+=$estimated[0];
    $end_time->[1]+=$estimated[1];
    $end_time->[2]+=$estimated[2];
  }
  else
  {
    print "Total time: "
    }
  print timestr(timediff($end_time, $start_time),"noc") . "\n";
  exit 0;
}

#
# Create a filename part for the machine that can be used for log file.
#

sub machine_part
{
  my ($name);
  return $opt_machine if (length($opt_machine)); # Specified by user
  $name=machine();
  $name="win95" if ($name =~ /\swin95\s/i);
  $name =~ s/\s+/_/g;		# Make the filenames easier to parse
  $name =~ s/-/_/g;
  $name =~ s/\//_/g;
  return $name;
}

sub machine
{
  $name= `uname -s -r -m`;
  if ($?)
  {
    $name= `uname -s -m`;
  }
  if ($?)
  {
    $name= `uname -s`;
  }
  if ($?)
  {
    $name= `uname`;
  }
  if ($?)
  {
    $name="unknown";
  }
  chomp($name);
  return $name;
}

#
# Usage
#

sub usage
{
    print <<EOF;
The MySQL benchmarks Ver $benchmark_version

All benchmarks takes the following options:

--comments
  Add a comment to the benchmark output.  Comments should contain
  extra information that 'uname -a' doesn\'t give and if the database was
  stared with some specific, non default, options.

--database (Default $opt_database)
  In which database the test tables are created.

--debug
  This is a test specific option that is only used when debugging a test.
  Print out debugging information.

--dir (Default $opt_dir)
  Option to 'run-all-tests' to where the test results should be stored.

--fast
  Allow the database to use non standard ANSI SQL commands to make the
  test go faster.

--fast-insert
  Use "insert into table_name values(...)" instead of
  "insert into table_name (....) values(...)"

--field-count
  This is a test specific option that is only used when debugging a test.
  This usually means how many fields there should be in the test table.

--force
  This is a test specific option that is only used when debugging a test.
  Continue the test even if there is some error.
  Delete tables before creating new ones.

--groups (Default $opt_groups)
  This is a test specific option that is only used when debugging a test.
  This usually means how many different groups there should be in the test.

--lock-tables
  Allow the database to use table locking to get more speed.

--log
  Option to 'run-all-tests' to save the result to the '--dir' directory.

--loop-count (Default $opt_loop_count)
  This is a test specific option that is only used when debugging a test.
  This usually means how many times times each test loop is executed.

--help or --Information
  Shows this help

--host='host name' (Default $opt_host)
  Host name where the database server is located.

--machine="machine or os_name"
  The machine/os name that is added to the benchmark output filename.
  The default is the OS name + version.

--password='password'
  Password for the current user.

--regions
  This is a test specific option that is only used when debugging a test.
  This usually means how AND levels should be tested.

--server='server name'  (Default $opt_server)
  Run the test on the given SQL server.
  Known servers names are: Empress, mSQL, MySQL, Pg, Solid and Oracle.

--skip-delete
  This is a test specific option that is only used when debugging a test.
  This will keep the test tables after the test is run.

--suffix (Default $opt_suffix)
  The suffix that is added to the database name in the benchmark output
  filename.  This can be used to run the benchmark multiple times with
  different server options without overwritten old files.
  When using --fast the suffix is automaticly set to '_fast'.

--time-limit (Default $opt_time_limit)
  How long a test loop is allowed to take, in seconds, before the end result
  is 'estimated'.

--use-old-results
  Option to 'run-all-tests' to use the old results from the  '--dir' directory
  instead of running the tests.

--user='user_name'
  User name to log into the SQL server.

--verbose
  This is a test specific option that is only used when debugging a test.
  Print more information about what is going on.
EOF
  exit(0);
}



####
#### The end of the base file ...
####
1;
