.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "ALTER_GROUP" "l" "08 May 2000" "SQL - Language Statements" ""
.SH NAME
ALTER GROUP \- Add users to a group, remove users from a group
.SH SYNOPSIS
.sp
.nf
ALTER GROUP \fIname\fR ADD USER \fIusername\fR [, ... ]
ALTER GROUP \fIname\fR DROP USER \fIusername\fR [, ... ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of the group to modify.
.TP
\fB\fIusername\fB\fR
Users which are to be added or removed from the group. The user
names must exist.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBALTER GROUP\fR
Message returned if the alteration was successful.
.PP
.SH "DESCRIPTION"
.PP
\fBALTER GROUP\fR is used to change add users to a group or
remove them from a group. Only database superusers can use this command.
Adding a user to a group does not create the user. Similarly, removing
a user from a group does not drop the user itself.
.PP
Use \fBcreate_group\fR(l)
to create a new group and \fBdrop_group\fR(l) to remove a group.
.SH "USAGE"
.PP
Add users to a group:
.sp
.nf
ALTER GROUP staff ADD USER karl, john
.sp
.fi
Remove a user from a group
.sp
.nf
ALTER GROUP workers DROP USER beth
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBALTER GROUP\fR statement in
SQL92. The concept of roles is
similar.
