.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "DROP_TABLE" "l" "08 May 2000" "SQL - Language Statements" ""
.SH NAME
DROP TABLE \- Removes existing tables from a database
.SH SYNOPSIS
.sp
.nf
DROP TABLE \fIname\fR [, ...]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of an existing table or view to drop.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBDROP\fR
The message returned if the command completes successfully.
.TP
\fBERROR Relation "\fIname\fB" Does Not Exist!\fR
If the specified table or view does not exist in the database.
.PP
.SH "DESCRIPTION"
.PP
\fBDROP TABLE\fR removes tables and views from the database.
Only its owner may destroy a table or view. A table
may be emptied of rows, but not destroyed, by using \fBDELETE\fR.
.PP
If a table being destroyed has secondary indexes on it,
they will be removed first. The removal of just a
secondary index will not affect the contents of the underlying table.
.SS "NOTES"
.PP
Refer to \fBCREATE TABLE\fR and
\fBALTER TABLE\fR for information on
how to create or modify tables.
.SH "USAGE"
.PP
To destroy two tables, films and 
\fBdistributors\fR:
.sp
.nf
DROP TABLE films, distributors;
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
SQL92 specifies some additional capabilities for DROP TABLE:
.sp
.nf
DROP TABLE \fItable\fR { RESTRICT | CASCADE }
   
.sp
.fi
.TP
\fBRESTRICT\fR
Ensures that only a table with no dependent views or
integrity constraints can be destroyed.
.TP
\fBCASCADE\fR
Any referencing views or integrity constraints
will also be dropped.
.sp
.RS
.B "Tip:"
At present, to remove a referenced view you must drop
it explicitly.
.PP
.RE
.sp
