.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "EXPLAIN" "l" "08 May 2000" "SQL - Language Statements" ""
.SH NAME
EXPLAIN \- Shows statement execution plan
.SH SYNOPSIS
.sp
.nf
EXPLAIN [ VERBOSE ] \fIquery\fR        
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fBVERBOSE\fR
Flag to show detailed query plan.
.TP
\fB\fIquery\fB\fR
Any \fIquery\fR.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBNOTICE: QUERY PLAN:\fR
Explicit query plan from the Postgres backend.
.TP
\fBEXPLAIN\fR
Flag sent after query plan is shown.
.PP
.SH "DESCRIPTION"
.PP
This command displays the execution plan that the Postgres planner
generates for the supplied query. The execution plan shows how
the table(s) referenced by the query will be scanned --- by plain
sequential scan, index scan etc --- and if multiple tables are
referenced, what join algorithms will be used to bring together
the required tuples from each input table.
.PP
The most critical part of the display is the estimated query execution
cost, which is the planner's guess at how long it will take to run the
query (measured in units of disk page fetches). Actually two numbers
are shown: the startup time before the first tuple can be returned, and
the total time to return all the tuples. For most queries the total time
is what matters, but in contexts such as an EXISTS sub-query the planner
will choose the smallest startup time instead of the smallest total time
(since the executor will stop after getting one tuple, anyway).
Also, if you limit the number of tuples to return with a LIMIT clause,
the planner makes an appropriate interpolation between the endpoint
costs to estimate which plan is really the cheapest.
.PP
The VERBOSE option emits the full internal representation of the plan tree,
rather than just a summary (and sends it to the postmaster log file, too).
Usually this option is only useful for debugging Postgres.
.SS "NOTES"
.PP
There is only sparse documentation on the optimizer's use of cost
information in Postgres.
General information on cost estimation for query optimization
can be found in database textbooks.
Refer to the \fIProgrammer's Guide\fR
in the chapters on indexes and the genetic query optimizer for
more information.
.SH "USAGE"
.PP
To show a query plan for a simple query on a table with a single
\fBint4\fR column and 128 rows:
.sp
.nf
EXPLAIN SELECT * FROM foo;
    NOTICE:  QUERY PLAN:

Seq Scan on foo  (cost=0.00..2.28 rows=128 width=4)

EXPLAIN
    
   
.sp
.fi
.PP
For the same table with an index to support an
\fIequijoin\fR condition on the query,
\fBEXPLAIN\fR will show a different plan:
.sp
.nf
EXPLAIN SELECT * FROM foo WHERE i = 4;
    NOTICE:  QUERY PLAN:

Index Scan using fi on foo  (cost=0.00..0.42 rows=1 width=4)

EXPLAIN
    
   
.sp
.fi
.PP
And finally, for the same table with an index to support an
\fIequijoin\fR condition on the query,
\fBEXPLAIN\fR will show the following for a query
using an aggregate function:
.sp
.nf
EXPLAIN SELECT sum(i) FROM foo WHERE i = 4;
    NOTICE:  QUERY PLAN:

Aggregate  (cost=0.42..0.42 rows=1 width=4)
  ->  Index Scan using fi on foo  (cost=0.00..0.42 rows=1 width=4)
    
   
.sp
.fi
.PP
Note that the specific numbers shown, and even the selected query
strategy, may vary between Postgres releases due to planner improvements.
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBEXPLAIN\fR statement defined in SQL92.
