/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.dtu;

import java.io.CharArrayWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import uk.org.retep.dtu.DModule;
import uk.org.retep.dtu.DNode;
import uk.org.retep.dtu.DProcessor;
import uk.org.retep.dtu.DTransform;
import uk.org.retep.util.Logger;
import uk.org.retep.xml.core.XMLFactory;
import uk.org.retep.xml.parser.TagHandler;
import uk.org.retep.xml.parser.TagListener;

public class DModuleXML
implements TagListener {
    protected TagHandler handler = new TagHandler();
    protected DModule module = null;
    protected DNode node = null;
    protected DTransform trans = null;
    protected ArrayList txmap;
    private static final int T_DEFAULT = -1;
    private static final int T_MODULE = 0;
    private static final int T_NODE = 1;
    private static final int T_TRANS = 2;
    private static final String[] tags = new String[]{"MODULE", "NODE", "TRANSFORM"};

    public DModuleXML() {
        this.handler.addTagListener(this);
        this.txmap = new ArrayList();
        Logger.log(2, "DModuleXML initialised");
    }

    public void fixTransforms() {
        Iterator iterator2 = ((AbstractList)this.txmap).iterator();
        while (iterator2.hasNext()) {
            tx tx2 = (tx)iterator2.next();
            DNode dNode = this.module.getNode(tx2.toID);
            tx2.transform.setFrom(tx2.node);
            tx2.transform.setTo(dNode);
        }
    }

    public TagHandler getTagHandler() {
        return this.handler;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 2) {
            System.err.println("Syntax: java DModuleXML in-file out-file");
            System.exit(1);
        }
        Logger.setLevel(2);
        Logger.log(0, "DModuleXML Read test1.xml");
        DModuleXML dModuleXML = new DModuleXML();
        DModule dModule = dModuleXML.parse(new InputSource(new FileInputStream(stringArray[0])));
        Logger.log(0, "Parse complete");
        Logger.log(0, "DModuleXML Write XML");
        FileWriter fileWriter = new FileWriter(stringArray[1]);
        dModule.saveXML(new XMLFactory(fileWriter));
        fileWriter.close();
        Logger.log(0, "Write complete");
        DProcessor.run(dModule);
    }

    public DModule parse(String string) throws IOException, SAXException {
        this.getTagHandler().parse(string);
        this.fixTransforms();
        return this.module;
    }

    public DModule parse(InputSource inputSource) throws IOException, SAXException {
        this.getTagHandler().parse(inputSource);
        this.fixTransforms();
        return this.module;
    }

    public void tagContent(CharArrayWriter charArrayWriter) {
    }

    public void tagStart(int n, String string, HashMap hashMap) {
        Logger.log(2, "DModuleXML.tagStart", string);
        String string2 = (String)hashMap.get("TYPE");
        String string3 = (String)hashMap.get("X");
        String string4 = (String)hashMap.get("Y");
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        if (string2 != null) {
            n2 = Integer.parseInt(string2);
        }
        if (string3 != null) {
            n4 = Integer.parseInt(string3);
        }
        if (string4 != null) {
            n3 = Integer.parseInt(string4);
        }
        int n5 = -1;
        int n6 = 0;
        while (n6 < tags.length) {
            if (string.equals(tags[n6])) {
                n5 = n6;
            }
            ++n6;
        }
        switch (n5) {
            case 0: {
                this.module = new DModule();
                String string5 = (String)hashMap.get("DISPLAYNAME");
                if (string5 == null) break;
                this.module.setDisplayName(string5);
                break;
            }
            case 1: {
                this.node = new DNode();
                this.node.setType(n2);
                this.module.addNode(this.node);
                break;
            }
            case 2: {
                this.trans = new DTransform();
                this.trans.setType(n2);
                int n7 = Integer.parseInt((String)hashMap.get("TO"));
                this.txmap.add(new tx(this.node, this.trans, n7));
                break;
            }
        }
    }

    protected class tx {
        public DNode node;
        public DTransform transform;
        public int toID;

        public tx(DNode dNode, DTransform dTransform, int n) {
            this.node = dNode;
            this.transform = dTransform;
            this.toID = n;
        }
    }
}

