/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.hba;

import uk.org.retep.util.Logger;
import uk.org.retep.util.misc.IPAddress;
import uk.org.retep.util.misc.WStringTokenizer;

public class Record {
    int type;
    String dbname;
    IPAddress ip;
    IPAddress mask;
    int authType;
    String authArg;
    public static final int TYPE_LOCAL = 0;
    public static final int TYPE_HOST = 1;
    public static final int TYPE_HOSTSSL = 2;
    public static final String[] types = new String[]{"local", "host", "hostssl"};
    public static final int AUTH_TRUST = 0;
    public static final int AUTH_PASSWORD = 1;
    public static final int AUTH_CRYPT = 2;
    public static final int AUTH_IDENT = 3;
    public static final int AUTH_KRB4 = 4;
    public static final int AUTH_KRB5 = 5;
    public static final int AUTH_REJECT = 6;
    public static final String[] auths = new String[]{"trust", "password", "crypt", "ident", "krb4", "krb5", "reject"};
    private static final String spc = " ";
    private static WStringTokenizer tok;
    public static final int VALID = 0;
    public static final int INVALID_TYPE = 1;
    public static final int INVALID_IPREQUIRED = 2;

    public String getAuthArgs() {
        return this.authArg;
    }

    public int getAuthType() {
        return this.authType;
    }

    public String getDatabase() {
        return this.dbname;
    }

    public IPAddress getIP() {
        return this.ip;
    }

    public IPAddress getMask() {
        return this.mask;
    }

    public int getType() {
        return this.type;
    }

    public static Record parseLine(String string) {
        Record record = new Record();
        if (string == null || string.equals("") || string.startsWith("#")) {
            return null;
        }
        if (tok == null) {
            tok = new WStringTokenizer();
        }
        tok.setString(string);
        int n = WStringTokenizer.matchToken(types, tok.nextToken());
        record.setType(n);
        record.setDatabase(tok.nextToken());
        if (n == 1 || n == 2) {
            record.setIP(new IPAddress(tok.nextToken()));
            record.setMask(new IPAddress(tok.nextToken()));
        }
        record.setAuthType(WStringTokenizer.matchToken(auths, tok.nextToken()));
        record.setAuthArgs(tok.nextToken());
        return record;
    }

    public void setAuthArgs(String string) {
        this.authArg = string;
    }

    public void setAuthType(int n) {
        this.authType = n;
    }

    public void setDatabase(String string) {
        this.dbname = string;
    }

    public void setIP(String string) {
        this.setIP(new IPAddress(string));
    }

    public void setIP(IPAddress iPAddress) {
        this.ip = iPAddress;
    }

    public void setMask(String string) {
        this.setMask(new IPAddress(string));
    }

    public void setMask(IPAddress iPAddress) {
        this.mask = iPAddress;
    }

    public void setType(int n) {
        this.type = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.write(stringBuffer);
        return stringBuffer.toString();
    }

    public int validate() {
        switch (this.type) {
            case 1: 
            case 2: {
                if (this.ip == null || this.ip.isInvalid()) {
                    Logger.log(0, "pg_hba.conf: IP missing or invalid - repairing");
                    this.setMask("127.0.0.1");
                }
                if (this.mask != null && !this.mask.isInvalid() && this.ip.validateMask(this.mask)) break;
                Logger.log(0, "pg_hba.conf: IP address without mask - repairing");
                this.setMask(this.ip.getMask());
                break;
            }
            default: {
                return 1;
            }
            case 0: 
        }
        return 0;
    }

    public void write(StringBuffer stringBuffer) {
        stringBuffer.append(types[this.type]).append(spc);
        if (this.type == 1 || this.type == 2) {
            stringBuffer.append(this.getIP()).append(spc);
            stringBuffer.append(this.getMask()).append(spc);
        }
        stringBuffer.append(auths[this.authType]);
        switch (this.type) {
            case 3: {
                stringBuffer.append(spc).append(this.getAuthArgs());
                break;
            }
            case 1: 
            case 2: {
                if (this.authArg == null || this.authArg.equals("")) break;
                stringBuffer.append(spc).append(this.getAuthArgs());
                break;
            }
        }
    }
}

