/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.xml.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import uk.org.retep.xml.core.XMLFactory;
import uk.org.retep.xml.core.XMLFactoryException;

public class XMLDatabase {
    protected XMLFactory factory;

    public XMLDatabase() {
    }

    public XMLDatabase(XMLFactory xMLFactory) {
        this();
        this.setXMLFactory(xMLFactory);
    }

    public void close() throws IOException, XMLFactoryException {
        this.factory.close();
    }

    public XMLFactory getXMLFactory() {
        return this.factory;
    }

    public void setXMLFactory(XMLFactory xMLFactory) {
        this.factory = xMLFactory;
    }

    public void writeDatabase(Connection connection) throws IOException, SQLException, XMLFactoryException {
        this.writeDatabase(connection.getMetaData(), null, null, "%");
    }

    public void writeDatabase(Connection connection, String string) throws IOException, SQLException, XMLFactoryException {
        this.writeDatabase(connection.getMetaData(), null, null, string);
    }

    public void writeDatabase(DatabaseMetaData databaseMetaData) throws IOException, SQLException, XMLFactoryException {
        this.writeDatabase(databaseMetaData, null, null, "%");
    }

    public void writeDatabase(DatabaseMetaData databaseMetaData, String string) throws IOException, SQLException, XMLFactoryException {
        this.writeDatabase(databaseMetaData, null, null, string);
    }

    public void writeDatabase(DatabaseMetaData databaseMetaData, String string, String string2, String string3) throws IOException, SQLException, XMLFactoryException {
        ResultSet resultSet = databaseMetaData.getTables(string, string2, string3, null);
        if (resultSet != null) {
            this.factory.startTag("DATABASE");
            this.factory.addAttribute("PRODUCT", databaseMetaData.getDatabaseProductName());
            this.factory.addAttribute("VERSION", databaseMetaData.getDatabaseProductVersion());
            while (resultSet.next()) {
                this.writeTable(databaseMetaData, resultSet.getString(1), resultSet.getString(2), resultSet.getString(3));
            }
            this.factory.endTag();
            resultSet.close();
        }
    }

    public void writeTable(Connection connection, String string) throws IOException, SQLException, XMLFactoryException {
        this.writeTable(connection.getMetaData(), string);
    }

    public void writeTable(DatabaseMetaData databaseMetaData, String string) throws IOException, SQLException, XMLFactoryException {
        this.writeTable(databaseMetaData, null, null, string);
    }

    public void writeTable(DatabaseMetaData databaseMetaData, String string, String string2, String string3) throws IOException, SQLException, XMLFactoryException {
        String string4;
        this.factory.startTag("TABLE");
        this.factory.addAttribute("NAME", string3);
        ResultSet resultSet = databaseMetaData.getTables(null, null, string3, null);
        if (resultSet != null) {
            if (resultSet.next() && (string4 = resultSet.getString(5)) != null) {
                this.factory.addContent(string4);
            }
            resultSet.close();
        }
        if ((resultSet = databaseMetaData.getColumns(null, null, string3, "%")) != null) {
            while (resultSet.next()) {
                this.factory.startTag("COLUMN");
                this.factory.addAttribute("NAME", resultSet.getString(4));
                this.factory.addAttribute("TYPE", resultSet.getString(6));
                this.factory.addAttribute("COLUMN_SIZE", resultSet.getString(7));
                this.factory.addAttribute("DECIMAL_DIGITS", resultSet.getString(9));
                this.factory.addAttribute("NUM_PREC_RADIX", resultSet.getString(10));
                this.factory.addAttribute("NULLABLE", resultSet.getString(11));
                this.factory.addAttribute("COLUMN_DEF", resultSet.getString(13));
                this.factory.addAttribute("CHAR_OCTET_LENGTH", resultSet.getString(16));
                this.factory.addAttribute("ORDINAL_POSITION", resultSet.getString(17));
                this.factory.addAttribute("IS_NULLABLE", resultSet.getString(18));
                this.factory.addAttribute("TABLE_CAT", resultSet.getString(1));
                this.factory.addAttribute("TABLE_SCHEM", resultSet.getString(2));
                string4 = resultSet.getString(12);
                if (string4 != null) {
                    this.factory.addContent(string4);
                }
                this.factory.endTag();
            }
            resultSet.close();
        }
        this.factory.endTag();
    }
}

