/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.xml.test;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import uk.org.retep.xml.core.XMLFactoryException;
import uk.org.retep.xml.jdbc.XMLDatabase;
import uk.org.retep.xml.jdbc.XMLResultSet;

public class XMLExport {
    protected Connection conn;
    protected Statement stat;
    protected String drvr;
    protected String url;
    protected String table;
    protected XMLResultSet xrs = new XMLResultSet();
    protected XMLDatabase xdb;
    protected Properties prop;
    protected boolean outXML;
    protected boolean outDTD;
    protected boolean outTAB;
    protected int maxRows = 0;

    public XMLExport(String[] stringArray) throws IOException, SQLException, XMLFactoryException, ClassNotFoundException {
        this.xrs.setWriter(new OutputStreamWriter(System.out));
        this.prop = (Properties)((Hashtable)XMLResultSet.getDefaultProperties()).clone();
        this.xdb = new XMLDatabase(this.xrs.getXMLFactory());
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string.startsWith("-D")) {
                this.drvr = string.substring(2);
                Class.forName(this.drvr);
                System.out.println("Now using JDBC Driver: " + this.drvr);
            } else if (string.startsWith("-J")) {
                this.close();
                this.url = string.substring(2);
                this.conn = DriverManager.getConnection(this.url);
                System.out.println("Opened " + this.url);
                this.stat = null;
            } else if (string.startsWith("-M")) {
                this.maxRows = Integer.parseInt(string.substring(2));
                if (this.maxRows < 0) {
                    this.maxRows = 0;
                }
                this.prop.setProperty(XMLResultSet.FIRST_ROW, "0");
                this.prop.setProperty(XMLResultSet.LAST_ROW, Integer.toString(this.maxRows));
            } else if (string.startsWith("-O")) {
                this.xrs.setWriter(new FileWriter(string.substring(2)));
                System.out.println("XML/DTD Output now going to " + string.substring(2));
            } else if (string.startsWith("-P")) {
                int n2 = string.indexOf(61);
                this.prop.setProperty(string.substring(2, n2), string.substring(n2 + 1));
            } else if (string.startsWith("-S")) {
                if (string.length() > 2) {
                    String string2 = string.substring(2);
                    System.out.println("Generating XML Schema of table " + string2);
                    this.xdb.writeTable(this.conn, string2);
                    this.xdb.close();
                } else {
                    System.out.println("Generating XML Schema of database");
                    this.xdb.writeDatabase(this.conn);
                    this.xdb.close();
                }
            } else if (string.equals("-V")) {
                this.outDTD = false;
                this.outXML = false;
            } else if (string.equals("-X")) {
                this.outXML = true;
                this.outTAB = false;
                this.outDTD = false;
            } else if (string.equals("-Y")) {
                this.outTAB = false;
                this.outXML = false;
                this.outDTD = true;
            } else if (string.startsWith("-")) {
                System.err.println("Unknown argument: " + string);
                System.exit(1);
            } else {
                if (this.stat == null) {
                    this.stat = this.conn.createStatement();
                }
                System.out.println("Executing " + string);
                ResultSet resultSet = this.stat.executeQuery(string);
                if (resultSet != null) {
                    if (this.outXML) {
                        this.xrs.translate(resultSet, this.prop);
                        this.xrs.close();
                    } else if (this.outDTD) {
                        this.xrs.buildDTD(resultSet, this.prop);
                        this.xrs.close();
                    } else {
                        int n3 = 0;
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        int n4 = resultSetMetaData.getColumnCount();
                        boolean bl = false;
                        int n5 = 0;
                        while (n5 < n4) {
                            if (bl) {
                                System.out.print("\t");
                            }
                            System.out.print(resultSetMetaData.getColumnName(n5 + 1));
                            bl = true;
                            ++n5;
                        }
                        System.out.println();
                        while (resultSet.next() && (this.maxRows == 0 || n3 < this.maxRows)) {
                            bl = false;
                            int n6 = 0;
                            while (n6 < n4) {
                                if (bl) {
                                    System.out.print("\t");
                                }
                                System.out.print(resultSet.getString(n6 + 1));
                                bl = true;
                                ++n6;
                            }
                            System.out.println();
                            ++n3;
                        }
                        System.out.println("Returned " + n3 + " rows.");
                    }
                    resultSet.close();
                }
            }
            ++n;
        }
        this.close();
    }

    public void close() throws SQLException {
        if (this.conn != null) {
            this.conn.close();
            System.out.println("Closed " + this.url);
            this.conn = null;
            this.stat = null;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Useage: java uk.org.retep.xml.test.XMLExport [args ...]\nwhere args are:\n-Dclass.name  JDBC Driver Class\n-Jurl         JDBC URL\n-Mmax         Maximum number of rows to process\n-Ofilename    Send all XML or DTD output to file\n-Pkey=value   Property passed on to XMLResultSet\n-S[table]     Write XML description of table. Whole DB if table left out.\n-V            Default: Write result to System.out\n-X            Write result in XML to System.out\n-Y            Write DTD describing result to System.out\n\nAny other argument not starting with - is treated as an SQL Query\n\nFor example:\nTo dump the table structure of a database into db.xml, use\n   $ java uk.org.retep.xml.test.XMLExport -Doracle.jdbc.driver.OracleDriver -Jjdbc:oracle:thin:dbname/username@localhost:1521:ISORCL -Odb.xml -S\nTo dump the structure of a single table PRODUCTS and write into products.xml, use\n   $ clear;java uk.org.retep.xml.test.XMLExport -Doracle.jdbc.driver.OracleDriver-Jjdbc:oracle:thin:dbname/username@localhost:1521:ISORCL -Oproducts.xml -SPRODUCT\nTo query a table and write the results into standard out as XML, use\n   $ java uk.org.retep.xml.test.XMLExport -Doracle.jdbc.driver.OracleDriver -Jjdbc:oracle:thin:dbname/username@localhost:1521:ISORCL -M5 -PSKU=row -PIMAGE=attribute -X \"select sku,image,template from product\"\nTo query a table and write a DTD describing the ResultSet, use\n   $ java uk.org.retep.xml.test.XMLExport -Doracle.jdbc.driver.OracleDriver -Jjdbc:oracle:thin:dbname/username@localhost:1521:ISORCL -M5 -PSKU=row -PIMAGE=attribute -Y \"select sku,image,template from product\"\n");
            System.exit(1);
        }
        try {
            XMLExport xMLExport = new XMLExport(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

