/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;

public class ImageViewer
implements ItemListener {
    Connection db;
    Statement stat;
    LargeObjectManager lom;
    Frame frame;
    Label label;
    List list;
    imageCanvas canvas;
    String currentImage;

    public ImageViewer(Frame frame, String string, String string2, String string3) throws ClassNotFoundException, FileNotFoundException, IOException, SQLException {
        this.frame = frame;
        MenuBar menuBar = new MenuBar();
        frame.setMenuBar(menuBar);
        Menu menu = new Menu("PostgreSQL");
        menuBar.add(menu);
        MenuItem menuItem = new MenuItem("Initialise");
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this.init();
            }
        });
        menuItem = new MenuItem("Exit");
        menu.add(menuItem);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this.close();
            }
        };
        menu.addActionListener(actionListener);
        menu = new Menu("Image");
        menuBar.add(menu);
        menuItem = new MenuItem("Import");
        menu.add(menuItem);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this.importImage();
            }
        };
        menuItem.addActionListener(actionListener2);
        menuItem = new MenuItem("Remove");
        menu.add(menuItem);
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this.removeImage();
            }
        };
        menuItem.addActionListener(actionListener3);
        this.label = new Label();
        frame.add("North", this.label);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        Button button = new Button("Refresh List");
        panel.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this.refreshList();
            }
        });
        button = new Button("Import new image");
        panel.add(button);
        button.addActionListener(actionListener2);
        button = new Button("Remove image");
        panel.add(button);
        button.addActionListener(actionListener3);
        button = new Button("Quit");
        panel.add(button);
        button.addActionListener(actionListener);
        frame.add("South", panel);
        this.list = new List();
        frame.add("West", this.list);
        this.list.addItemListener(this);
        this.canvas = new imageCanvas();
        frame.add("Center", this.canvas);
        Class.forName("org.postgresql.Driver");
        this.db = DriverManager.getConnection(string, string2, string3);
        this.stat = this.db.createStatement();
        this.lom = ((org.postgresql.Connection)this.db).getLargeObjectAPI();
        this.refreshList();
    }

    public void close() {
        try {
            this.db.close();
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException.toString());
        }
        System.exit(0);
    }

    public void displayImage(String string) {
        try {
            try {
                this.db.setAutoCommit(false);
                ResultSet resultSet = this.stat.executeQuery("select imgoid from images where imgname='" + string + "'");
                if (resultSet != null) {
                    while (resultSet.next()) {
                        this.canvas.setImage(this.canvas.getToolkit().createImage(resultSet.getBytes(1)));
                        this.currentImage = string;
                        this.label.setText(this.currentImage);
                    }
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                this.label.setText(sQLException.toString());
            }
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            try {
                this.db.setAutoCommit(true);
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        try {
            this.db.setAutoCommit(true);
        }
        catch (SQLException sQLException) {}
    }

    public void importImage() {
        FileDialog fileDialog = new FileDialog(this.frame, "Import Image", 0);
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        fileDialog.dispose();
        importer importer2 = new importer(this.db, string, string2);
        importer2.start();
    }

    public void init() {
        try {
            this.stat.executeUpdate("create table images (imgname name,imgoid oid)");
            this.label.setText("Initialised database");
            this.db.commit();
        }
        catch (SQLException sQLException) {
            this.label.setText(sQLException.toString());
        }
    }

    public static void instructions() {
        System.err.println("java example.ImageViewer jdbc-url user password");
        System.err.println("\nExamples:\n");
        System.err.println("java -Djdbc.driver=org.postgresql.Driver example.ImageViewer jdbc:postgresql:test postgres password\n");
        System.err.println("This example tests the binary large object api of the driver.\nBasically, it will allow you to store and view images held in the database.");
        System.err.println("Note: If you are running this for the first time on a particular database,\nyou have to select \"Initialise\" in the \"PostgreSQL\" menu.\nThis will create a table used to store image names.");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.displayImage(this.list.getItem((Integer)itemEvent.getItem()));
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            ImageViewer.instructions();
            System.exit(1);
        }
        try {
            Frame frame = new Frame("PostgreSQL ImageViewer v7.0 rev 1");
            frame.setLayout(new BorderLayout());
            ImageViewer imageViewer = new ImageViewer(frame, stringArray[0], stringArray[1], stringArray[2]);
            frame.pack();
            ((Component)frame).setLocation(0, 50);
            ((Component)frame).setVisible(true);
        }
        catch (Exception exception) {
            System.err.println("Exception caught.\n" + exception);
            exception.printStackTrace();
        }
    }

    public void refreshList() {
        try {
            ResultSet resultSet = this.stat.executeQuery("select imgname from images order by imgname");
            if (resultSet != null) {
                this.list.removeAll();
                while (resultSet.next()) {
                    this.list.addItem(resultSet.getString(1));
                }
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            this.label.setText(String.valueOf(sQLException.toString()) + " Have you initialised the database?");
        }
    }

    public void removeImage() {
        try {
            ResultSet resultSet = this.stat.executeQuery("select imgoid from images where imgname='" + this.currentImage + "'");
            if (resultSet != null) {
                while (resultSet.next()) {
                    this.lom.delete(resultSet.getInt(1));
                }
            }
            resultSet.close();
            this.stat.executeUpdate("delete from images where imgname='" + this.currentImage + "'");
            this.label.setText(String.valueOf(this.currentImage) + " deleted");
            this.currentImage = null;
            this.refreshList();
        }
        catch (SQLException sQLException) {
            this.label.setText(sQLException.toString());
        }
    }

    public class imageCanvas
    extends Canvas {
        private Image image = null;
        private Image bkg;
        private Dimension size;

        public Dimension getMinimumSize() {
            return new Dimension(400, 400);
        }

        public Dimension getPreferedSize() {
            return this.getMinimumSize();
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            if (this.size == null || this.bkg == null || !dimension.equals(this.size)) {
                this.size = dimension;
                this.bkg = this.createImage(this.size.width, this.size.height);
            }
            Graphics graphics2 = this.bkg.getGraphics();
            graphics2.setColor(Color.gray);
            graphics2.fillRect(0, 0, dimension.width, dimension.height);
            if (this.image != null) {
                graphics2.drawImage(this.image, 0, 0, this);
            }
            graphics2.dispose();
            graphics.drawImage(this.bkg, 0, 0, this);
        }

        public void setImage(Image image) {
            this.image = image;
            this.repaint();
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    }

    class importer
    extends Thread {
        String name;
        String dir;
        Connection db;

        public importer(Connection connection, String string, String string2) {
            this.db = connection;
            this.name = string;
            this.dir = string2;
        }

        public void run() {
            if (this.name != null && this.dir != null) {
                Statement statement = null;
                try {
                    try {
                        int n;
                        LargeObjectManager largeObjectManager = ((org.postgresql.Connection)this.db).getLargeObjectAPI();
                        this.db.setAutoCommit(false);
                        byte[] byArray = new byte[2048];
                        FileInputStream fileInputStream = new FileInputStream(new File(this.dir, this.name));
                        int n2 = largeObjectManager.create();
                        LargeObject largeObject = largeObjectManager.open(n2);
                        int n3 = 0;
                        while ((n = fileInputStream.read(byArray, 0, byArray.length)) > 0) {
                            n3 += n;
                            largeObject.write(byArray, 0, n);
                        }
                        largeObject.close();
                        statement = this.db.createStatement();
                        statement.executeUpdate("insert into images values ('" + this.name + "'," + n2 + ")");
                        this.db.commit();
                        this.db.setAutoCommit(false);
                        ImageViewer.this.refreshList();
                        ImageViewer.this.displayImage(this.name);
                    }
                    catch (Exception exception) {
                        ImageViewer.this.label.setText(exception.toString());
                    }
                    Object var3_10 = null;
                }
                catch (Throwable throwable) {
                    Object var3_11 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        System.err.println("closing of Statement failed");
                    }
                    throw throwable;
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    System.err.println("closing of Statement failed");
                }
            }
        }
    }
}

