/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;

public class blobtest {
    Connection db;
    Statement s;
    LargeObjectManager lobj;

    public blobtest(String[] stringArray) throws ClassNotFoundException, FileNotFoundException, IOException, SQLException {
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        Class.forName("org.postgresql.Driver");
        System.out.println("Connecting to Database URL = " + string);
        this.db = DriverManager.getConnection(string, string2, string3);
        System.out.println("Connected... First turn off autoCommit()");
        this.db.setAutoCommit(false);
        System.out.println("Now creating a statement");
        this.s = this.db.createStatement();
        this.ownapi();
        System.out.println("Now closing the connection");
        this.s.close();
        this.db.close();
    }

    public static void instructions() {
        System.err.println("java example.blobtest jdbc-url user password [debug]");
        System.err.println("\nExamples:\n");
        System.err.println("java -Djdbc.driver=org.postgresql.Driver example.blobtest jdbc:postgresql:test postgres password\nThis will run the tests on the database test on the local host.\n");
        System.err.println("java -Djdbc.driver=org.postgresql.Driver example.blobtest jdbc:postgresql:test postgres password debug\nThis is the same as above, but will output debug information.\n");
        System.err.println("This example tests the binary large object api of the driver.\nThis allows images or java objects to be stored in the database, and retrieved\nusing both postgresql's own api, and the standard JDBC api.");
    }

    public void jdbc2api(int n) throws SQLException, IOException {
        System.out.println("Testing JDBC2 Blob interface:");
        this.jdbc2api_cleanup();
        System.out.println("Creating Blob on large object " + n);
        this.s.executeUpdate("create table basic (a oid)");
        System.out.println("Inserting row");
        this.s.executeUpdate("insert into basic values (" + n + ")");
        System.out.println("Selecting row");
        ResultSet resultSet = this.s.executeQuery("select a from basic");
        if (resultSet != null) {
            while (resultSet.next()) {
                System.out.println("Fetching Blob");
                Blob blob = resultSet.getBlob("a");
                System.out.println("Blob.length() = " + blob.length());
                System.out.println("Characters 400-500:");
                ((FilterOutputStream)System.out).write(blob.getBytes(400L, 100));
                System.out.println();
            }
            resultSet.close();
        }
        System.out.println("Cleaning up");
        this.jdbc2api_cleanup();
    }

    private void jdbc2api_cleanup() throws SQLException {
        this.db.setAutoCommit(true);
        try {
            this.s.executeUpdate("drop table basic");
        }
        catch (Exception exception) {}
        this.db.setAutoCommit(false);
    }

    public static void main(String[] stringArray) {
        System.out.println("PostgreSQL blobtest v7.0 rev 1\n");
        if (stringArray.length < 3) {
            blobtest.instructions();
            System.exit(1);
        }
        if (stringArray.length > 3) {
            DriverManager.setLogStream(System.err);
        }
        try {
            blobtest blobtest2 = new blobtest(stringArray);
        }
        catch (Exception exception) {
            System.err.println("Exception caught.\n" + exception);
            exception.printStackTrace();
        }
    }

    public void ownapi() throws FileNotFoundException, IOException, SQLException {
        System.out.println("\n----------------------------------------------------------------------\nTesting postgresql large object api\n----------------------------------------------------------------------\n");
        System.out.println("Gaining access to large object api");
        this.lobj = ((org.postgresql.Connection)this.db).getLargeObjectAPI();
        int n = this.ownapi_test1();
        this.ownapi_test2(n);
        this.jdbc2api(n);
        this.ownapi_test3(n);
        System.out.println("\n\nOID=" + n);
    }

    private int ownapi_test1() throws FileNotFoundException, IOException, SQLException {
        int n;
        System.out.println("Test 1 Creating a large object\n");
        System.out.println("Creating a large object");
        int n2 = this.lobj.create(393216);
        DriverManager.println("got large object oid=" + n2);
        LargeObject largeObject = this.lobj.open(n2, 131072);
        DriverManager.println("got large object obj=" + largeObject);
        System.out.println("Opening test source object");
        FileInputStream fileInputStream = new FileInputStream("example/blobtest.java");
        System.out.println("Copying file to large object");
        byte[] byArray = new byte[2048];
        int n3 = 0;
        while ((n = fileInputStream.read(byArray, 0, 2048)) > 0) {
            System.out.println("Block size=" + n + " offset=" + n3);
            largeObject.write(byArray, 0, n);
            n3 += n;
        }
        DriverManager.println("Copied " + n3 + " bytes");
        System.out.println("Closing object");
        largeObject.close();
        return n2;
    }

    private void ownapi_test2(int n) throws FileNotFoundException, IOException, SQLException {
        System.out.println("Test 2 Reading a large object and save as a file\n");
        System.out.println("Opening large object " + n);
        LargeObject largeObject = this.lobj.open(n, 262144);
        DriverManager.println("got obj=" + largeObject);
        System.out.println("Opening test destination object");
        FileOutputStream fileOutputStream = new FileOutputStream("blob_testoutput");
        System.out.println("Copying large object to file");
        byte[] byArray = new byte[512];
        int n2 = largeObject.size();
        int n3 = 0;
        while (n2 > 0) {
            int n4 = byArray.length;
            if (n2 < n4) {
                n4 = n2;
            }
            largeObject.read(byArray, 0, n4);
            fileOutputStream.write(byArray, 0, n4);
            n3 += n4;
            n2 -= n4;
        }
        DriverManager.println("Copied " + n3 + "/" + largeObject.size() + " bytes");
        System.out.println("Closing object");
        largeObject.close();
    }

    private void ownapi_test3(int n) throws SQLException {
        System.out.println("Test 3 Deleting a large object\n");
        System.out.println("Deleting large object " + n);
        this.lobj.unlink(n);
    }
}

