/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;

public class threadsafe {
    Connection db;
    Statement st;

    public threadsafe(String[] stringArray) throws ClassNotFoundException, FileNotFoundException, IOException, SQLException {
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        Class.forName("org.postgresql.Driver");
        System.out.println("Connecting to Database URL = " + string);
        this.db = DriverManager.getConnection(string, string2, string3);
        System.out.println("Connected...Now creating a statement");
        this.st = this.db.createStatement();
        this.cleanup();
        this.db.setAutoCommit(false);
        this.doexample();
        this.cleanup();
        System.out.println("Now closing the connection");
        this.st.close();
        this.db.close();
    }

    public void cleanup() {
        try {
            this.st.executeUpdate("drop table basic1");
        }
        catch (Exception exception) {}
        try {
            this.st.executeUpdate("drop table basic2");
        }
        catch (Exception exception) {}
    }

    public void doexample() throws SQLException {
        System.out.println("\nThis test runs three Threads. Two simply insert data into a table, then\nthey perform a query. While they are running, a third thread is running,\nand it load data into, then reads from a Large Object.\n\nIf alls well, this should run without any errors. If so, we are Thread Safe.\nWhy test JDBC & LargeObject's? Because both will run over the network\nconnection, and if locking on the stream isn't done correctly, the backend\nwill get pretty confused!\n");
        thread3 thread32 = null;
        try {
            Thread thread = Thread.currentThread();
            thread1 thread12 = new thread1(this.db);
            thread2 thread22 = new thread2(this.db);
            thread32 = new thread3(this.db);
            thread12.start();
            thread22.start();
            thread32.start();
            System.out.println("Waiting for threads to run");
            while (thread12.isAlive() || thread22.isAlive() || thread32.isAlive()) {
                Thread.yield();
            }
        }
        finally {
            Object var3_5 = null;
            if (thread32 != null) {
                thread32.cleanup();
            }
        }
        System.out.println("No Exceptions have been thrown. This is a good omen, as it means that we are\npretty much thread safe as we can get.");
    }

    public static void instructions() {
        System.out.println("\nThis tests the thread safety of the driver.\n\nThis is done in two parts, the first with standard JDBC calls, and the\nsecond mixing FastPath and LargeObject calls with queries.\n");
        System.out.println("Useage:\n java example.threadsafe jdbc:postgresql:database user password [debug]\n\nThe debug field can be anything. It's presence will enable DriverManager's\ndebug trace. Unless you want to see screens of items, don't put anything in\nhere.");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        System.out.println("PostgreSQL Thread Safety test v6.4 rev 1\n");
        if (stringArray.length < 3) {
            threadsafe.instructions();
        }
        if (stringArray.length > 3) {
            DriverManager.setLogStream(System.err);
        }
        try {
            threadsafe threadsafe2 = new threadsafe(stringArray);
        }
        catch (Exception exception) {
            System.err.println("Exception caught.\n" + exception);
            exception.printStackTrace();
        }
    }

    class thread1
    extends Thread {
        Connection c;
        Statement st;

        public thread1(Connection connection) throws SQLException {
            this.c = connection;
            this.st = connection.createStatement();
        }

        public void run() {
            try {
                System.out.println("Thread 1 running...");
                this.st.executeUpdate("create table basic1 (a int2, b int2)");
                this.st.executeUpdate("insert into basic1 values (1,1)");
                this.st.executeUpdate("insert into basic1 values (2,1)");
                this.st.executeUpdate("insert into basic1 values (3,1)");
                PreparedStatement preparedStatement = threadsafe.this.db.prepareStatement("insert into basic1 values (?,?)");
                int n = 2;
                while (n < 2000) {
                    preparedStatement.setInt(1, 4);
                    preparedStatement.setInt(2, n);
                    preparedStatement.executeUpdate();
                    if (n % 50 == 0) {
                        DriverManager.println("Thread 1 done " + n + " inserts");
                    }
                    ++n;
                }
                preparedStatement.close();
                DriverManager.println("Thread 1 performing a query");
                ResultSet resultSet = this.st.executeQuery("select a, b from basic1");
                int n2 = 0;
                if (resultSet != null) {
                    while (resultSet.next()) {
                        int n3 = resultSet.getInt("a");
                        int n4 = resultSet.getInt(2);
                        ++n2;
                    }
                    resultSet.close();
                }
                DriverManager.println("Thread 1 read " + n2 + " rows");
                System.out.println("Thread 1 finished");
            }
            catch (SQLException sQLException) {
                System.err.println("Thread 1: " + sQLException.toString());
                sQLException.printStackTrace();
                System.exit(1);
            }
        }
    }

    class thread2
    extends Thread {
        Connection c;
        Statement st;

        public thread2(Connection connection) throws SQLException {
            this.c = connection;
            this.st = connection.createStatement();
        }

        public void run() {
            try {
                System.out.println("Thread 2 running...");
                this.st.executeUpdate("create table basic2 (a int2, b int2)");
                PreparedStatement preparedStatement = threadsafe.this.db.prepareStatement("insert into basic2 values (?,?)");
                int n = 2;
                while (n < 2000) {
                    preparedStatement.setInt(1, 4);
                    preparedStatement.setInt(2, n);
                    preparedStatement.executeUpdate();
                    if (n % 50 == 0) {
                        DriverManager.println("Thread 2 done " + n + " inserts");
                    }
                    ++n;
                }
                preparedStatement.close();
                DriverManager.println("Thread 2 performing a query");
                ResultSet resultSet = this.st.executeQuery("select * from basic2 where b>1");
                int n2 = 0;
                if (resultSet != null) {
                    int n3 = resultSet.findColumn("a");
                    int n4 = resultSet.findColumn("b");
                    while (resultSet.next()) {
                        int n5 = resultSet.getInt(n3);
                        int n6 = resultSet.getInt(n4);
                        ++n2;
                    }
                    resultSet.close();
                }
                DriverManager.println("Thread 2 read " + n2 + " rows");
                System.out.println("Thread 2 finished");
            }
            catch (SQLException sQLException) {
                System.err.println("Thread 2: " + sQLException.toString());
                sQLException.printStackTrace();
                System.exit(1);
            }
        }
    }

    class thread3
    extends Thread {
        Connection c;
        Statement st;
        LargeObjectManager lom;
        LargeObject lo;
        int oid;

        public thread3(Connection connection) throws SQLException {
            this.c = connection;
            this.lom = ((org.postgresql.Connection)connection).getLargeObjectAPI();
            this.oid = this.lom.create();
            System.out.println("Thread 3 has created a blob of oid " + this.oid);
        }

        public void cleanup() throws SQLException {
            if (this.lom != null && this.oid != 0) {
                System.out.println("Thread 3: Removing blob oid=" + this.oid);
                this.lom.delete(this.oid);
            }
        }

        public void run() {
            try {
                int n;
                System.out.println("Thread 3 running...");
                DriverManager.println("Thread 3: Loading data into blob " + this.oid);
                this.lo = this.lom.open(this.oid);
                FileInputStream fileInputStream = new FileInputStream("example/threadsafe.java");
                byte[] byArray = new byte[128];
                int n2 = 1;
                int n3 = 0;
                while ((n = fileInputStream.read(byArray)) > 0) {
                    DriverManager.println("Thread 3 read block " + n2 + " " + n3 + " bytes");
                    this.lo.write(byArray, 0, n);
                    ++n2;
                    n3 += n;
                }
                this.lo.close();
                fileInputStream.close();
                DriverManager.println("Thread 3: Reading blob " + this.oid);
                this.lo = this.lom.open(this.oid);
                n2 = 0;
                while (byArray.length > 0) {
                    if ((byArray = this.lo.read(byArray.length)).length <= 0) continue;
                    String string = new String(byArray);
                    DriverManager.println("Thread 3 block " + ++n2);
                    DriverManager.println("Block " + n2 + " got " + string);
                }
                this.lo.close();
                System.out.println("Thread 3 finished");
            }
            catch (Exception exception) {
                System.err.println("Thread 3: " + exception.toString());
                exception.printStackTrace();
                System.exit(1);
            }
        }
    }
}

