/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.Field;
import org.postgresql.PG_Stream;
import org.postgresql.fastpath.Fastpath;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.PGobject;
import org.postgresql.util.PSQLException;
import org.postgresql.util.Serialize;
import org.postgresql.util.UnixCrypt;

public abstract class Connection {
    public PG_Stream pg_stream;
    private String PG_HOST;
    private int PG_PORT;
    private String PG_USER;
    private String PG_PASSWORD;
    private String PG_DATABASE;
    private boolean PG_STATUS;
    private String encoding;
    public boolean CONNECTION_OK = true;
    public boolean CONNECTION_BAD = false;
    public boolean autoCommit = true;
    public boolean readOnly = false;
    public Driver this_driver;
    private String this_url;
    private String cursor = null;
    protected static final int PG_PROTOCOL_LATEST_MAJOR = 2;
    protected static final int PG_PROTOCOL_LATEST_MINOR = 0;
    private static final int SM_DATABASE = 64;
    private static final int SM_USER = 32;
    private static final int SM_OPTIONS = 64;
    private static final int SM_UNUSED = 64;
    private static final int SM_TTY = 64;
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_KRB4 = 1;
    private static final int AUTH_REQ_KRB5 = 2;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_CRYPT = 4;
    private String salt;
    public Hashtable fieldCache = new Hashtable();
    public SQLWarning firstWarning = null;
    public int pid;
    public int ckey;
    byte[] receive_sbuf = new byte[8192];
    private Fastpath fastpath = null;
    private LargeObjectManager largeobject = null;
    private Hashtable objectTypes = new Hashtable();
    private static final String[][] defaultObjectTypes = new String[][]{{"box", "org.postgresql.geometric.PGbox"}, {"circle", "org.postgresql.geometric.PGcircle"}, {"line", "org.postgresql.geometric.PGline"}, {"lseg", "org.postgresql.geometric.PGlseg"}, {"path", "org.postgresql.geometric.PGpath"}, {"point", "org.postgresql.geometric.PGpoint"}, {"polygon", "org.postgresql.geometric.PGpolygon"}, {"money", "org.postgresql.util.PGmoney"}};

    public String EscapeSQL(String string) {
        int n = string.indexOf("{d");
        while (n != -1) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.setCharAt(n, ' ');
            stringBuffer.setCharAt(n + 1, ' ');
            stringBuffer.setCharAt(string.indexOf(125, n), ' ');
            string = new String(stringBuffer);
            n = string.indexOf("{d");
        }
        return string;
    }

    public ResultSet ExecSQL(String string) throws SQLException {
        return this.ExecSQL(string, null);
    }

    /*
     * Unable to fully structure code
     */
    public ResultSet ExecSQL(String var1_1, Statement var2_2) throws SQLException {
        var3_3 = 0;
        if (var2_2 != null) {
            var3_3 = var2_2.getMaxRows();
        }
        var5_4 = this.pg_stream;
        synchronized (var5_4) {
            var7_5 = null;
            var8_6 = new Vector<byte[][]>();
            var9_7 = null;
            var10_8 = 0;
            var11_9 = false;
            var12_10 = null;
            var14_11 = 1;
            var15_12 = 0;
            var16_13 = null;
            if (this.getEncoding() == null) {
                var9_7 = var1_1.getBytes();
            } else {
                try {
                    var9_7 = var1_1.getBytes(this.getEncoding());
                }
                catch (UnsupportedEncodingException var17_14) {
                    throw new PSQLException("postgresql.con.encoding", var17_14);
                }
            }
            try {
                this.pg_stream.SendChar(81);
                this.pg_stream.Send(var9_7);
                this.pg_stream.SendChar(0);
                this.pg_stream.flush();
                if (true) ** GOTO lbl109
            }
            catch (IOException var17_15) {
                throw new PSQLException("postgresql.con.ioerror", var17_15);
            }
            block25: do {
                var17_16 = null;
                var18_18 = this.pg_stream.ReceiveChar();
                switch (var18_18) {
                    case 65: {
                        this.pid = this.pg_stream.ReceiveInteger(4);
                        var13_17 = this.pg_stream.ReceiveString(this.receive_sbuf, 8192, this.getEncoding());
                        break;
                    }
                    case 66: {
                        if (var7_5 == null) {
                            throw new PSQLException("postgresql.con.tuple");
                        }
                        var17_16 = this.pg_stream.ReceiveTuple(var7_5.length, true);
                        if (var3_3 != 0 && var8_6.size() >= var3_3) continue block25;
                        var8_6.addElement(var17_16);
                        break;
                    }
                    case 67: {
                        var12_10 = this.pg_stream.ReceiveString(this.receive_sbuf, 8192, this.getEncoding());
                        if (var12_10.startsWith("INSERT") || var12_10.startsWith("UPDATE") || var12_10.startsWith("DELETE")) {
                            try {
                                var14_11 = Integer.parseInt(var12_10.substring(1 + var12_10.lastIndexOf(32)));
                            }
                            catch (NumberFormatException v0) {
                                throw new PSQLException("postgresql.con.fathom", (Object)var12_10);
                            }
                            if (var12_10.startsWith("INSERT")) {
                                try {
                                    var15_12 = Integer.parseInt(var12_10.substring(1 + var12_10.indexOf(32), var12_10.lastIndexOf(32)));
                                }
                                catch (NumberFormatException v1) {
                                    throw new PSQLException("postgresql.con.fathom", (Object)var12_10);
                                }
                            }
                        }
                        if (var7_5 != null) {
                            var11_9 = true;
                            break;
                        }
                        try {
                            this.pg_stream.SendChar(81);
                            this.pg_stream.SendChar(32);
                            this.pg_stream.SendChar(0);
                            this.pg_stream.flush();
                        }
                        catch (IOException var19_20) {
                            throw new PSQLException("postgresql.con.ioerror", var19_20);
                        }
                        ++var10_8;
                        break;
                    }
                    case 68: {
                        if (var7_5 == null) {
                            throw new PSQLException("postgresql.con.tuple");
                        }
                        var17_16 = this.pg_stream.ReceiveTuple(var7_5.length, false);
                        if (var3_3 != 0 && var8_6.size() >= var3_3) continue block25;
                        var8_6.addElement(var17_16);
                        break;
                    }
                    case 69: {
                        var13_17 = this.pg_stream.ReceiveString(this.receive_sbuf, 4096, this.getEncoding());
                        var16_13 = new SQLException(var13_17);
                        var11_9 = true;
                        break;
                    }
                    case 73: {
                        var19_19 = this.pg_stream.ReceiveChar();
                        if (var19_19 != 0) {
                            throw new PSQLException("postgresql.con.garbled");
                        }
                        if (var10_8 > 0) {
                            --var10_8;
                        }
                        if (var10_8 != 0) break;
                        var11_9 = true;
                        break;
                    }
                    case 78: {
                        this.addWarning(this.pg_stream.ReceiveString(this.receive_sbuf, 4096, this.getEncoding()));
                        break;
                    }
                    case 80: {
                        var20_21 = this.pg_stream.ReceiveString(this.receive_sbuf, 8192, this.getEncoding());
                        break;
                    }
                    case 84: {
                        if (var7_5 != null) {
                            throw new PSQLException("postgresql.con.multres");
                        }
                        var7_5 = this.ReceiveFields();
                        break;
                    }
                    default: {
                        throw new PSQLException("postgresql.con.type", new Character((char)var18_18));
                    }
                    case 90: 
                }
lbl109:
                // 15 sources

            } while (!var11_9 || var10_8 > 0);
            if (var16_13 != null) {
                throw var16_13;
            }
            var4_22 = this.getResultSet(this, var2_2, var7_5, var8_6, var12_10, var14_11, var15_12);
            var6_23 = null;
            return var4_22;
        }
    }

    private Field[] ReceiveFields() throws SQLException {
        int n = this.pg_stream.ReceiveIntegerR(2);
        Field[] fieldArray = new Field[n];
        int n2 = 0;
        while (n2 < n) {
            String string = this.pg_stream.ReceiveString(this.receive_sbuf, 8192, this.getEncoding());
            int n3 = this.pg_stream.ReceiveIntegerR(4);
            int n4 = this.pg_stream.ReceiveIntegerR(2);
            int n5 = this.pg_stream.ReceiveIntegerR(4);
            fieldArray[n2] = new Field(this, string, n3, n4, n5);
            ++n2;
        }
        return fieldArray;
    }

    public void addDataType(String string, String string2) {
        this.objectTypes.put(string, string2);
    }

    public void addWarning(String string) {
        DriverManager.println(string);
        if (this.firstWarning != null) {
            this.firstWarning.setNextWarning(new SQLWarning(string));
        } else {
            this.firstWarning = new SQLWarning(string);
        }
    }

    public abstract void close() throws SQLException;

    public abstract Statement createStatement() throws SQLException;

    public void finalize() throws Throwable {
        this.close();
    }

    public String getCursorName() throws SQLException {
        return this.cursor;
    }

    public String getEncoding() throws SQLException {
        return this.encoding;
    }

    public Fastpath getFastpathAPI() throws SQLException {
        if (this.fastpath == null) {
            this.fastpath = new Fastpath(this, this.pg_stream);
        }
        return this.fastpath;
    }

    public LargeObjectManager getLargeObjectAPI() throws SQLException {
        if (this.largeobject == null) {
            this.largeobject = new LargeObjectManager(this);
        }
        return this.largeobject;
    }

    public Object getObject(String string, String string2) throws SQLException {
        try {
            Object v = this.objectTypes.get(string);
            if (v == null) {
                Serialize serialize = new Serialize(this, string);
                this.objectTypes.put(string, serialize);
                return serialize.fetch(Integer.parseInt(string2));
            }
            if (v instanceof String) {
                PGobject pGobject = null;
                pGobject = (PGobject)Class.forName((String)v).newInstance();
                pGobject.setType(string);
                pGobject.setValue(string2);
                return pGobject;
            }
            if (v instanceof Serialize) {
                return ((Serialize)v).fetch(Integer.parseInt(string2));
            }
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        catch (Exception exception) {
            throw new PSQLException("postgresql.con.creobj", (Object)string, (Object)exception);
        }
        return null;
    }

    protected abstract ResultSet getResultSet(Connection var1, Statement var2, Field[] var3, Vector var4, String var5, int var6, int var7) throws SQLException;

    public String getURL() throws SQLException {
        return this.this_url;
    }

    public String getUserName() throws SQLException {
        return this.PG_USER;
    }

    private void initObjectTypes() {
        int n = 0;
        while (n < defaultObjectTypes.length) {
            this.objectTypes.put(defaultObjectTypes[n][0], defaultObjectTypes[n][1]);
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void openConnection(String var1_1, int var2_2, Properties var3_3, String var4_4, String var5_5, Driver var6_6) throws SQLException {
        if (var3_3.getProperty("user") == null) {
            throw new PSQLException("postgresql.con.user");
        }
        if (var3_3.getProperty("password") == null) {
            throw new PSQLException("postgresql.con.pass");
        }
        this.this_driver = var6_6;
        this.this_url = var5_5;
        this.PG_DATABASE = var4_4;
        this.PG_PASSWORD = var3_3.getProperty("password");
        this.PG_USER = var3_3.getProperty("user");
        this.PG_PORT = var2_2;
        this.PG_HOST = var1_1;
        this.PG_STATUS = this.CONNECTION_BAD;
        try {
            this.pg_stream = new PG_Stream(var1_1, var2_2);
        }
        catch (ConnectException v0) {
            throw new PSQLException("postgresql.con.refused");
        }
        catch (IOException var7_7) {
            throw new PSQLException("postgresql.con.failed", var7_7);
        }
        try {
            this.pg_stream.SendInteger(296, 4);
            this.pg_stream.SendInteger(2, 2);
            this.pg_stream.SendInteger(0, 2);
            this.pg_stream.Send(var4_4.getBytes(), 64);
            this.pg_stream.Send(this.PG_USER.getBytes(), 224);
            this.pg_stream.flush();
            var7_8 = -1;
            block26: while (true) lbl-1000:
            // 3 sources

            {
                var8_10 = this.pg_stream.ReceiveChar();
                switch (var8_10) {
                    case 69: {
                        throw new SQLException(this.pg_stream.ReceiveString(this.receive_sbuf, 4096, this.getEncoding()));
                    }
                    case 82: {
                        var7_8 = this.pg_stream.ReceiveIntegerR(4);
                        if (var7_8 == 4) {
                            var9_12 /* !! */  = new byte[]{(byte)this.pg_stream.ReceiveChar(), (byte)this.pg_stream.ReceiveChar()};
                            this.salt = new String(var9_12 /* !! */ , 0, 2);
                            DriverManager.println("Salt=" + this.salt);
                        }
                        switch (var7_8) {
                            case 1: {
                                DriverManager.println("postgresql: KRB4");
                                throw new PSQLException("postgresql.con.kerb4");
                            }
                            case 2: {
                                DriverManager.println("postgresql: KRB5");
                                throw new PSQLException("postgresql.con.kerb5");
                            }
                            case 3: {
                                DriverManager.println("postgresql: PASSWORD");
                                this.pg_stream.SendInteger(5 + this.PG_PASSWORD.length(), 4);
                                this.pg_stream.Send(this.PG_PASSWORD.getBytes());
                                this.pg_stream.SendInteger(0, 1);
                                this.pg_stream.flush();
                                ** break;
                            }
                            case 4: {
                                DriverManager.println("postgresql: CRYPT");
                                var9_12 /* !! */  = (byte[])UnixCrypt.crypt(this.salt, this.PG_PASSWORD);
                                this.pg_stream.SendInteger(5 + var9_12 /* !! */ .length(), 4);
                                this.pg_stream.Send(var9_12 /* !! */ .getBytes());
                                this.pg_stream.SendInteger(0, 1);
                                this.pg_stream.flush();
                                ** break;
                            }
                            default: {
                                throw new PSQLException("postgresql.con.auth", new Integer(var7_8));
                            }
                            case 0: {
                                if (var7_8 != 0) continue block26;
                            }
                        }
                    }
                    default: {
                        throw new PSQLException("postgresql.con.authfail");
                    }
                }
lbl67:
                // 2 sources

                if (var7_8 != 0) ** GOTO lbl-1000
                break;
            }
        }
        catch (IOException var7_9) {
            throw new PSQLException("postgresql.con.failed", var7_9);
        }
        var7_8 = this.pg_stream.ReceiveChar();
        switch (var7_8) {
            case 75: {
                this.pid = this.pg_stream.ReceiveInteger(4);
                this.ckey = this.pg_stream.ReceiveInteger(4);
                break;
            }
            case 69: 
            case 78: {
                throw new SQLException(this.pg_stream.ReceiveString(this.receive_sbuf, 4096, this.getEncoding()));
            }
            default: {
                throw new PSQLException("postgresql.con.setup");
            }
        }
        var7_8 = this.pg_stream.ReceiveChar();
        switch (var7_8) {
            case 69: 
            case 78: {
                throw new SQLException(this.pg_stream.ReceiveString(this.receive_sbuf, 4096, this.getEncoding()));
            }
            default: {
                throw new PSQLException("postgresql.con.setup");
            }
            case 90: 
        }
        this.firstWarning = null;
        var8_11 = this.ExecSQL("set datestyle to 'ISO'; select getdatabaseencoding()");
        var9_12 /* !! */  = null;
        if (var8_11.next()) {
            var9_12 /* !! */  = (byte[])var8_11.getString(1);
            var9_12 /* !! */  = (byte[])(var9_12 /* !! */ .equals("SQL_ASCII") != false ? "ASCII" : (byte[])(var9_12 /* !! */ .equals("UNICODE") != false ? "UTF8" : (byte[])(var9_12 /* !! */ .equals("LATIN1") != false ? "ISO8859_1" : (byte[])(var9_12 /* !! */ .equals("LATIN2") != false ? "ISO8859_2" : (byte[])(var9_12 /* !! */ .equals("LATIN3") != false ? "ISO8859_3" : (byte[])(var9_12 /* !! */ .equals("LATIN4") != false ? "ISO8859_4" : (byte[])(var9_12 /* !! */ .equals("LATIN5") != false ? "ISO8859_5" : (byte[])(var9_12 /* !! */ .equals("LATIN6") != false ? "ISO8859_6" : (byte[])(var9_12 /* !! */ .equals("LATIN7") != false ? "ISO8859_7" : (byte[])(var9_12 /* !! */ .equals("LATIN8") != false ? "ISO8859_8" : (byte[])(var9_12 /* !! */ .equals("LATIN9") != false ? "ISO8859_9" : (byte[])(var9_12 /* !! */ .equals("EUC_JP") != false ? "EUC_JP" : (byte[])(var9_12 /* !! */ .equals("EUC_CN") != false ? "EUC_CN" : (byte[])(var9_12 /* !! */ .equals("EUC_KR") != false ? "EUC_KR" : (byte[])(var9_12 /* !! */ .equals("EUC_TW") != false ? "EUC_TW" : (byte[])(var9_12 /* !! */ .equals("KOI8") != false ? "KOI8_R" : (byte[])(var9_12 /* !! */ .equals("WIN") != false ? "Cp1252" : null)))))))))))))))));
        }
        if ((var10_13 = var3_3.getProperty("charSet")) != null) {
            this.encoding = var10_13;
        } else if (var9_12 /* !! */  != null) {
            try {
                "TEST".getBytes((String)var9_12 /* !! */ );
                this.encoding = var9_12 /* !! */ ;
            }
            catch (UnsupportedEncodingException v1) {
                this.encoding = null;
            }
        } else {
            this.encoding = null;
        }
        this.initObjectTypes();
        this.firstWarning = null;
        this.PG_STATUS = this.CONNECTION_OK;
    }

    public int putObject(Object object) throws SQLException {
        try {
            String string = object.getClass().getName();
            Object v = this.objectTypes.get(string);
            if (v == null) {
                Serialize serialize = new Serialize(this, string);
                this.objectTypes.put(string, serialize);
                return serialize.store(object);
            }
            if (v instanceof Serialize) {
                return ((Serialize)v).store(object);
            }
            throw new PSQLException("postgresql.con.strobj");
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        catch (Exception exception) {
            throw new PSQLException("postgresql.con.strobjex", exception);
        }
    }

    public void setCursorName(String string) throws SQLException {
        this.cursor = string;
    }
}

