/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.jdbc2.Connection;
import org.postgresql.jdbc2.Statement;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.PGobject;
import org.postgresql.util.PSQLException;

public class PreparedStatement
extends Statement
implements java.sql.PreparedStatement {
    String sql;
    String[] templateStrings;
    String[] inStrings;
    Connection connection;
    private StringBuffer sbuf = new StringBuffer();
    private ThreadLocal tl_df = new ThreadLocal();
    private ThreadLocal tl_tsdf = new ThreadLocal();

    public PreparedStatement(Connection connection, String string) throws SQLException {
        super(connection);
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        int n = 0;
        this.sql = string;
        this.connection = connection;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == '\'') {
                bl ^= true;
            }
            if (c == '?' && !bl) {
                vector.addElement(string.substring(n, n2));
                n = n2 + 1;
            }
            ++n2;
        }
        vector.addElement(string.substring(n, string.length()));
        this.templateStrings = new String[vector.size()];
        this.inStrings = new String[vector.size() - 1];
        this.clearParameters();
        n2 = 0;
        while (n2 < this.templateStrings.length) {
            this.templateStrings[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
    }

    public void addBatch() throws SQLException {
        super.addBatch(this.compileQuery());
    }

    public void clearParameters() throws SQLException {
        int n = 0;
        while (n < this.inStrings.length) {
            this.inStrings[n] = null;
            ++n;
        }
    }

    public void close() throws SQLException {
        this.tl_df.set(null);
        super.close();
    }

    private synchronized String compileQuery() throws SQLException {
        this.sbuf.setLength(0);
        int n = 0;
        while (n < this.inStrings.length) {
            if (this.inStrings[n] == null) {
                throw new PSQLException("postgresql.prep.param", new Integer(n + 1));
            }
            this.sbuf.append(this.templateStrings[n]).append(this.inStrings[n]);
            ++n;
        }
        this.sbuf.append(this.templateStrings[this.inStrings.length]);
        return this.sbuf.toString();
    }

    public boolean execute() throws SQLException {
        return super.execute(this.compileQuery());
    }

    public ResultSet executeQuery() throws SQLException {
        return super.executeQuery(this.compileQuery());
    }

    public int executeUpdate() throws SQLException {
        return super.executeUpdate(this.compileQuery());
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSet resultSet = this.getResultSet();
        if (resultSet != null) {
            return resultSet.getMetaData();
        }
        return null;
    }

    private void set(int n, String string) throws SQLException {
        if (n < 1 || n > this.inStrings.length) {
            throw new PSQLException("postgresql.prep.range");
        }
        this.inStrings[n - 1] = string;
    }

    public void setArray(int n, Array array) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setBinaryStream(n, inputStream, n2);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.set(n, bigDecimal.toString());
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        LargeObjectManager largeObjectManager = this.connection.getLargeObjectAPI();
        int n3 = largeObjectManager.create();
        LargeObject largeObject = largeObjectManager.open(n3);
        OutputStream outputStream = largeObject.getOutputStream();
        try {
            int n4 = inputStream.read();
            int n5 = 0;
            while (n4 > -1 && n5 < n2) {
                outputStream.write(n4);
                n4 = inputStream.read();
                ++n5;
            }
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new PSQLException("postgresql.prep.is", iOException);
        }
        this.setInt(n, n3);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.setBinaryStream(n, blob.getBinaryStream(), (int)blob.length());
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.set(n, bl ? "'t'" : "'f'");
    }

    public void setByte(int n, byte by) throws SQLException {
        this.set(n, Integer.toString(by));
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        LargeObjectManager largeObjectManager = this.connection.getLargeObjectAPI();
        int n2 = largeObjectManager.create();
        LargeObject largeObject = largeObjectManager.open(n2);
        largeObject.write(byArray);
        largeObject.close();
        this.setInt(n, n2);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        LargeObjectManager largeObjectManager = this.connection.getLargeObjectAPI();
        int n3 = largeObjectManager.create();
        LargeObject largeObject = largeObjectManager.open(n3);
        OutputStream outputStream = largeObject.getOutputStream();
        try {
            int n4 = reader.read();
            int n5 = 0;
            while (n4 > -1 && n5 < n2) {
                outputStream.write(n4);
                n4 = reader.read();
                ++n5;
            }
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new PSQLException("postgresql.prep.is", iOException);
        }
        this.setInt(n, n3);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.setBinaryStream(n, clob.getAsciiStream(), (int)clob.length());
    }

    public void setDate(int n, Date date) throws SQLException {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)this.tl_df.get();
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat("''yyyy-MM-dd''");
            this.tl_df.set(simpleDateFormat);
        }
        this.set(n, simpleDateFormat.format(date));
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (calendar == null) {
            this.setDate(n, date);
        } else {
            calendar.setTime(date);
            this.setDate(n, new Date(calendar.getTime().getTime()));
        }
    }

    public void setDouble(int n, double d) throws SQLException {
        this.set(n, Double.toString(d));
    }

    public void setFloat(int n, float f) throws SQLException {
        this.set(n, Float.toString(f));
    }

    public void setInt(int n, int n2) throws SQLException {
        this.set(n, Integer.toString(n2));
    }

    public void setLong(int n, long l) throws SQLException {
        this.set(n, Long.toString(l));
    }

    public void setNull(int n, int n2) throws SQLException {
        this.set(n, "null");
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.setNull(n, n2);
    }

    public void setObject(int n, Object object) throws SQLException {
        if (object instanceof String) {
            this.setString(n, (String)object);
        } else if (object instanceof BigDecimal) {
            this.setBigDecimal(n, (BigDecimal)object);
        } else if (object instanceof Short) {
            this.setShort(n, (Short)object);
        } else if (object instanceof Integer) {
            this.setInt(n, (Integer)object);
        } else if (object instanceof Long) {
            this.setLong(n, (Long)object);
        } else if (object instanceof Float) {
            this.setFloat(n, ((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.setDouble(n, (Double)object);
        } else if (object instanceof byte[]) {
            this.setBytes(n, (byte[])object);
        } else if (object instanceof Date) {
            this.setDate(n, (Date)object);
        } else if (object instanceof Time) {
            this.setTime(n, (Time)object);
        } else if (object instanceof Timestamp) {
            this.setTimestamp(n, (Timestamp)object);
        } else if (object instanceof Boolean) {
            this.setBoolean(n, (Boolean)object);
        } else if (object instanceof PGobject) {
            this.setString(n, ((PGobject)object).getValue());
        } else {
            this.setLong(n, this.connection.putObject(object));
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, 0);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        switch (n2) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (object instanceof Boolean) {
                    this.set(n, (Boolean)object != false ? "1" : "0");
                    break;
                }
                this.set(n, object.toString());
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.setString(n, object.toString());
                break;
            }
            case 91: {
                this.setDate(n, (Date)object);
                break;
            }
            case 92: {
                this.setTime(n, (Time)object);
                break;
            }
            case 93: {
                this.setTimestamp(n, (Timestamp)object);
                break;
            }
            case 1111: {
                this.setString(n, ((PGobject)object).getValue());
                break;
            }
            default: {
                throw new PSQLException("postgresql.prep.type");
            }
        }
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setShort(int n, short s) throws SQLException {
        this.set(n, Integer.toString(s));
    }

    public void setString(int n, String string) throws SQLException {
        if (string == null) {
            this.set(n, "null");
        } else {
            StringBuffer stringBuffer = this.sbuf;
            synchronized (stringBuffer) {
                this.sbuf.setLength(0);
                this.sbuf.append('\'');
                int n2 = 0;
                while (n2 < string.length()) {
                    char c = string.charAt(n2);
                    if (c == '\\' || c == '\'') {
                        this.sbuf.append('\\');
                    }
                    this.sbuf.append(c);
                    ++n2;
                }
                this.sbuf.append('\'');
                this.set(n, this.sbuf.toString());
            }
        }
    }

    public void setTime(int n, Time time) throws SQLException {
        this.set(n, "'" + time.toString() + "'");
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (calendar == null) {
            this.setTime(n, time);
        } else {
            calendar.setTime(time);
            this.setTime(n, new Time(calendar.getTime().getTime()));
        }
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)this.tl_tsdf.get();
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.tl_tsdf.set(simpleDateFormat);
        }
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuffer stringBuffer = this.sbuf;
        synchronized (stringBuffer) {
            this.sbuf.setLength(0);
            this.sbuf.append("'").append(simpleDateFormat.format(timestamp)).append('.').append(timestamp.getNanos() / 10000000).append("+00'");
            this.set(n, this.sbuf.toString());
        }
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (calendar == null) {
            this.setTimestamp(n, timestamp);
        } else {
            calendar.setTime(timestamp);
            this.setTimestamp(n, new Timestamp(calendar.getTime().getTime()));
        }
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setBinaryStream(n, inputStream, n2);
    }

    public String toString() {
        StringBuffer stringBuffer = this.sbuf;
        synchronized (stringBuffer) {
            this.sbuf.setLength(0);
            int n = 0;
            while (n < this.inStrings.length) {
                if (this.inStrings[n] == null) {
                    this.sbuf.append('?');
                } else {
                    this.sbuf.append(this.templateStrings[n]);
                }
                this.sbuf.append(this.inStrings[n]);
                ++n;
            }
            this.sbuf.append(this.templateStrings[this.inStrings.length]);
            String string = this.sbuf.toString();
            Object var3_4 = null;
            return string;
        }
    }
}

