/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class metadata {
    Connection db;
    Statement st;
    DatabaseMetaData dbmd;
    private static final String[] allUserTables = new String[]{"TABLE", "INDEX", "SEQUENCE"};
    private static final String[] usrIndices = new String[]{"INDEX"};
    private static final String[] usrTables = new String[]{"TABLE"};
    private static final String[] usrSequences = new String[]{"SEQUENCE"};
    private static final String[] sysTables = new String[]{"SYSTEM TABLE", "SYSTEM INDEX"};

    public void doDatabaseMetaData() throws SQLException {
        if (this.doTest("getProcedures() - should show all available procedures")) {
            this.displayResult(this.dbmd.getProcedures(null, null, null));
        }
        if (this.doTest("getProcedures() with pattern - should show all circle procedures")) {
            this.displayResult(this.dbmd.getProcedures(null, null, "circle%"));
        }
        if (this.doTest("getProcedureColumns() on circle procedures")) {
            this.displayResult(this.dbmd.getProcedureColumns(null, null, "circle%", null));
        }
        if (this.doTest("getTables()")) {
            this.displayResult(this.dbmd.getTables(null, null, null, null));
        }
        if (this.doTest("getColumns() - should show all tables, can take a while to run")) {
            this.displayResult(this.dbmd.getColumns(null, null, null, null));
        }
        if (this.doTest("getColumns() - should show the test_b table")) {
            this.displayResult(this.dbmd.getColumns(null, null, "test_b", null));
        }
        if (this.doTest("getColumnPrivileges() - should show all tables")) {
            this.displayResult(this.dbmd.getColumnPrivileges(null, null, null, null));
        }
        if (this.doTest("getPrimaryKeys()")) {
            this.displayResult(this.dbmd.getPrimaryKeys(null, null, null));
        }
        if (this.doTest("getTypeInfo()")) {
            this.displayResult(this.dbmd.getTypeInfo());
        }
    }

    public void doResultSetMetaData() throws SQLException {
        String string = "select imagename,descr,source,cost from test_a,test_b,test_c where test_a.id=test_b.imageid and test_a.id=test_c.imageid";
        System.out.println("Executing query for tests");
        ResultSet resultSet = this.st.executeQuery(string);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (this.doTest("isCurrency()")) {
            System.out.println("isCurrency on col 1 = " + resultSetMetaData.isCurrency(1) + " should be false\nisCurrency on col 4 = " + resultSetMetaData.isCurrency(4) + " should be true");
        }
        if (this.doTest("Display query result")) {
            System.out.println("Query: " + string);
            this.displayResult(resultSet);
        } else {
            resultSet.close();
        }
    }

    public void init() throws SQLException {
        System.out.println("Creating some tables");
        this.cleanup();
        this.st.executeUpdate("create table test_a (imagename name,image oid,id int4)");
        this.st.executeUpdate("create table test_b (descr text,imageid int4,id int4)");
        this.st.executeUpdate("create table test_c (source text,cost money,imageid int4)");
        System.out.println("Adding some data");
        this.st.executeUpdate("insert into test_a values ('test1',0,1)");
        this.st.executeUpdate("insert into test_b values ('A test description',1,2)");
        this.st.executeUpdate("insert into test_c values ('nowhere particular','$10.99',1)");
    }

    public void cleanup() throws SQLException {
        try {
            this.st.executeUpdate("drop table test_a");
            this.st.executeUpdate("drop table test_b");
            this.st.executeUpdate("drop table test_c");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public metadata(String[] stringArray) throws ClassNotFoundException, FileNotFoundException, IOException, SQLException {
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        Class.forName("org.postgresql.Driver");
        System.out.println("Connecting to Database URL = " + string);
        this.db = DriverManager.getConnection(string, string2, string3);
        this.dbmd = this.db.getMetaData();
        this.st = this.db.createStatement();
        System.out.println("Connected to " + this.dbmd.getDatabaseProductName() + " " + this.dbmd.getDatabaseProductVersion());
        this.init();
        System.out.println();
        if (this.doTest("Test DatabaseMetaData")) {
            this.doDatabaseMetaData();
        }
        if (this.doTest("Test ResultSetMetaData")) {
            this.doResultSetMetaData();
        }
        System.out.println("\nNow closing the connection");
        this.st.close();
        this.db.close();
        this.cleanup();
    }

    public boolean doTest(String string) {
        System.out.println();
        System.out.print(string);
        System.out.print(" Perform test? Y or N:");
        System.out.flush();
        int n = 32;
        try {
            while (n != 110 && n != 121 && n != 78 && n != 89) {
                n = (char)System.in.read();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return n == 121 || n == 89;
    }

    public void displayResult(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = 0;
        int n2 = resultSetMetaData.getColumnCount();
        int n3 = 1;
        while (n3 <= n2) {
            System.out.print(resultSetMetaData.getColumnLabel(n3) + (n3 < n2 ? "\t" : "\n"));
            ++n3;
        }
        while (resultSet.next()) {
            ++n;
            int n4 = 1;
            while (n4 <= n2) {
                Object object = resultSet.getObject(n4);
                if (resultSet.wasNull()) {
                    System.out.print("{null}" + (n4 < n2 ? "\t" : "\n"));
                } else {
                    System.out.print(object.toString() + (n4 < n2 ? "\t" : "\n"));
                }
                ++n4;
            }
        }
        System.out.println("Result returned " + n + " rows.");
        resultSet.close();
    }

    public void processSlashCommand(String string) throws SQLException {
        if (string.startsWith("\\d")) {
            if (string.startsWith("\\d ")) {
                String string2 = string.substring(3);
                this.displayResult(this.dbmd.getColumns(null, null, string2, "%"));
            } else {
                String[] stringArray = null;
                if (string.equals("\\d")) {
                    stringArray = allUserTables;
                } else if (string.equals("\\di")) {
                    stringArray = usrIndices;
                } else if (string.equals("\\dt")) {
                    stringArray = usrTables;
                } else if (string.equals("\\ds")) {
                    stringArray = usrSequences;
                } else if (string.equals("\\dS")) {
                    stringArray = sysTables;
                } else {
                    throw new SQLException("Unsupported \\d command: " + string);
                }
                this.displayResult(this.dbmd.getTables(null, null, "%", stringArray));
            }
        } else {
            throw new SQLException("Unsupported \\ command: " + string);
        }
    }

    public static void instructions() {
        System.out.println("\nThis is not really an example, but is used to test the various methods in\nthe DatabaseMetaData and ResultSetMetaData classes.\n");
        System.out.println("Useage:\n java example.metadata jdbc:postgresql:database user password [debug]\n\nThe debug field can be anything. It's presence will enable DriverManager's\ndebug trace. Unless you want to see screens of debug items, don't put anything in\nhere.");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        System.out.println("PostgreSQL metdata tester v6.4 rev 1\n");
        if (stringArray.length < 3) {
            metadata.instructions();
        }
        if (stringArray.length > 3) {
            DriverManager.setLogStream(System.err);
        }
        try {
            metadata metadata2 = new metadata(stringArray);
        }
        catch (Exception exception) {
            System.err.println("Exception caught.\n" + exception);
            exception.printStackTrace();
        }
    }
}

