/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class psql {
    Connection db;
    Statement st;
    DatabaseMetaData dbmd;
    boolean done = false;
    private static final String[] allUserTables = new String[]{"TABLE", "INDEX", "SEQUENCE"};
    private static final String[] usrIndices = new String[]{"INDEX"};
    private static final String[] usrTables = new String[]{"TABLE"};
    private static final String[] usrSequences = new String[]{"SEQUENCE"};
    private static final String[] sysTables = new String[]{"SYSTEM TABLE", "SYSTEM INDEX"};

    public psql(String[] stringArray) throws ClassNotFoundException, FileNotFoundException, IOException, SQLException {
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        Class.forName("org.postgresql.Driver");
        System.out.println("Connecting to Database URL = " + string);
        this.db = DriverManager.getConnection(string, string2, string3);
        this.dbmd = this.db.getMetaData();
        this.st = this.db.createStatement();
        System.out.println("Connected to " + this.dbmd.getDatabaseProductName() + " " + this.dbmd.getDatabaseProductVersion());
        System.out.println();
        StreamTokenizer streamTokenizer = new StreamTokenizer(new InputStreamReader(System.in));
        streamTokenizer.resetSyntax();
        streamTokenizer.slashSlashComments(true);
        streamTokenizer.eolIsSignificant(false);
        streamTokenizer.wordChars(32, 126);
        streamTokenizer.whitespaceChars(59, 59);
        int n = 0;
        int n2 = 1;
        while (n != -1 && !this.done) {
            System.out.print("[" + n2 + "] ");
            System.out.flush();
            try {
                n = streamTokenizer.nextToken();
                if (n != -3) continue;
                this.processLine(streamTokenizer.sval);
                ++n2;
            }
            catch (SQLException sQLException) {
                System.out.println(sQLException.getMessage());
            }
        }
        System.out.println("Now closing the connection");
        this.st.close();
        this.db.close();
    }

    public void processLine(String string) throws SQLException {
        if (string.startsWith("\\")) {
            this.processSlashCommand(string);
            return;
        }
        boolean bl = this.st.execute(string);
        boolean bl2 = true;
        while (bl2) {
            if (bl) {
                ResultSet resultSet = this.st.getResultSet();
                this.displayResult(resultSet);
            } else {
                int n = this.st.getUpdateCount();
                if (n == -1) {
                    bl2 = false;
                } else {
                    System.out.println("Updated " + this.st.getUpdateCount() + " rows");
                }
            }
            if (!bl2) continue;
            bl = this.st.getMoreResults();
        }
    }

    public void displayResult(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        int n2 = 1;
        while (n2 <= n) {
            System.out.print(resultSetMetaData.getColumnLabel(n2) + (n2 < n ? "\t" : "\n"));
            ++n2;
        }
        while (resultSet.next()) {
            int n3 = 1;
            while (n3 <= n) {
                Object object = resultSet.getObject(n3);
                if (resultSet.wasNull()) {
                    System.out.print("{null}" + (n3 < n ? "\t" : "\n"));
                } else {
                    System.out.print(object.toString() + (n3 < n ? "\t" : "\n"));
                }
                ++n3;
            }
        }
        resultSet.close();
    }

    public void processSlashCommand(String string) throws SQLException {
        if (string.startsWith("\\d")) {
            if (string.startsWith("\\d ")) {
                String string2 = string.substring(3);
                this.displayResult(this.dbmd.getColumns(null, null, string2, "%"));
            } else {
                String[] stringArray = null;
                if (string.equals("\\d")) {
                    stringArray = allUserTables;
                } else if (string.equals("\\di")) {
                    stringArray = usrIndices;
                } else if (string.equals("\\dt")) {
                    stringArray = usrTables;
                } else if (string.equals("\\ds")) {
                    stringArray = usrSequences;
                } else if (string.equals("\\dS")) {
                    stringArray = sysTables;
                } else {
                    throw new SQLException("Unsupported \\d command: " + string);
                }
                this.displayResult(this.dbmd.getTables(null, null, "%", stringArray));
            }
        } else if (string.equals("\\q")) {
            this.done = true;
        } else {
            throw new SQLException("Unsupported \\ command: " + string);
        }
    }

    public static void instructions() {
        System.out.println("\nThis example shows how some of the other JDBC features work within the\ndriver. It does this by implementing a very simple psql equivalent in java.\nNot everything that psql does is implemented.\n");
        System.out.println("Useage:\n java example.psql jdbc:postgresql:database user password [debug]\n\nThe debug field can be anything. It's presence will enable DriverManager's\ndebug trace. Unless you want to see screens of items, don't put anything in\nhere.");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        System.out.println("PostgreSQL psql example v6.3 rev 1\n");
        if (stringArray.length < 3) {
            psql.instructions();
        }
        if (stringArray.length > 3) {
            DriverManager.setLogStream(System.err);
        }
        try {
            psql psql2 = new psql(stringArray);
        }
        catch (Exception exception) {
            System.err.println("Exception caught.\n" + exception);
            exception.printStackTrace();
        }
    }
}

