/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.sql.SQLException;
import org.postgresql.core.BytePoolDim1;
import org.postgresql.core.BytePoolDim2;
import org.postgresql.core.Encoding;
import org.postgresql.util.PSQLException;

public class PG_Stream {
    private Socket connection;
    private InputStream pg_input;
    private BufferedOutputStream pg_output;
    private byte[] byte_buf = new byte[8192];
    BytePoolDim1 bytePoolDim1 = new BytePoolDim1();
    BytePoolDim2 bytePoolDim2 = new BytePoolDim2();

    public PG_Stream(String string, int n) throws IOException {
        this.connection = new Socket(string, n);
        this.connection.setTcpNoDelay(true);
        this.pg_input = new BufferedInputStream(this.connection.getInputStream(), 8192);
        this.pg_output = new BufferedOutputStream(this.connection.getOutputStream(), 8192);
    }

    public void SendChar(int n) throws IOException {
        this.pg_output.write((byte)n);
    }

    public void SendInteger(int n, int n2) throws IOException {
        byte[] byArray = this.bytePoolDim1.allocByte(n2);
        while (n2-- > 0) {
            byArray[n2] = (byte)(n & 0xFF);
            n >>= 8;
        }
        this.Send(byArray);
    }

    public void Send(byte[] byArray) throws IOException {
        this.pg_output.write(byArray);
    }

    public void Send(byte[] byArray, int n) throws IOException {
        this.Send(byArray, 0, n);
    }

    public void Send(byte[] byArray, int n, int n2) throws IOException {
        this.pg_output.write(byArray, n, byArray.length - n < n2 ? byArray.length - n : n2);
        if (byArray.length - n < n2) {
            int n3 = byArray.length - n;
            while (n3 < n2) {
                this.pg_output.write(0);
                ++n3;
            }
        }
    }

    public int ReceiveChar() throws SQLException {
        int n = 0;
        try {
            n = this.pg_input.read();
            if (n < 0) {
                throw new PSQLException("postgresql.stream.eof");
            }
        }
        catch (IOException iOException) {
            throw new PSQLException("postgresql.stream.ioerror", iOException);
        }
        return n;
    }

    public int ReceiveInteger(int n) throws SQLException {
        int n2 = 0;
        try {
            int n3 = 0;
            while (n3 < n) {
                int n4 = this.pg_input.read();
                if (n4 < 0) {
                    throw new PSQLException("postgresql.stream.eof");
                }
                n2 |= n4 << 8 * n3;
                ++n3;
            }
        }
        catch (IOException iOException) {
            throw new PSQLException("postgresql.stream.ioerror", iOException);
        }
        return n2;
    }

    public int ReceiveIntegerR(int n) throws SQLException {
        int n2 = 0;
        try {
            int n3 = 0;
            while (n3 < n) {
                int n4 = this.pg_input.read();
                if (n4 < 0) {
                    throw new PSQLException("postgresql.stream.eof");
                }
                n2 = n4 | n2 << 8;
                ++n3;
            }
        }
        catch (IOException iOException) {
            throw new PSQLException("postgresql.stream.ioerror", iOException);
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String ReceiveString(Encoding encoding) throws SQLException {
        int n = 0;
        byte[] byArray = this.byte_buf;
        try {
            int n2 = byArray.length;
            boolean bl = false;
            block2: while (true) {
                if (bl) {
                    return encoding.decode(byArray, 0, n);
                }
                while (true) {
                    if (n >= n2) continue block2;
                    int n3 = this.pg_input.read();
                    if (n3 < 0) {
                        throw new PSQLException("postgresql.stream.eof");
                    }
                    if (n3 == 0) {
                        byArray[n] = 0;
                        bl = true;
                        continue block2;
                    }
                    byArray[n++] = (byte)n3;
                    if (n < n2) continue;
                    byte[] byArray2 = new byte[n2 *= 2];
                    System.arraycopy(byArray, 0, byArray2, 0, n);
                    byArray = byArray2;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw new PSQLException("postgresql.stream.ioerror", iOException);
        }
    }

    public byte[][] ReceiveTuple(int n, boolean bl) throws SQLException {
        int n2 = (n + 7) / 8;
        byte[] byArray = this.Receive(n2);
        byte[][] byArray2 = this.bytePoolDim2.allocByte(n);
        int n3 = 128;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            boolean bl2;
            boolean bl3 = bl2 = (byArray[n4] & n3) == 0;
            if ((n3 >>= 1) == 0) {
                ++n4;
                n3 = 128;
            }
            if (bl2) {
                byArray2[n5] = null;
            } else {
                int n6 = this.ReceiveIntegerR(4);
                if (!bl) {
                    n6 -= 4;
                }
                if (n6 < 0) {
                    n6 = 0;
                }
                byArray2[n5] = this.Receive(n6);
            }
            ++n5;
        }
        return byArray2;
    }

    private byte[] Receive(int n) throws SQLException {
        byte[] byArray = this.bytePoolDim1.allocByte(n);
        this.Receive(byArray, 0, n);
        return byArray;
    }

    public void Receive(byte[] byArray, int n, int n2) throws SQLException {
        int n3 = 0;
        try {
            while (n3 < n2) {
                int n4 = this.pg_input.read(byArray, n + n3, n2 - n3);
                if (n4 < 0) {
                    throw new PSQLException("postgresql.stream.eof");
                }
                n3 += n4;
            }
        }
        catch (IOException iOException) {
            throw new PSQLException("postgresql.stream.ioerror", iOException);
        }
    }

    public void flush() throws SQLException {
        try {
            this.pg_output.flush();
        }
        catch (IOException iOException) {
            throw new PSQLException("postgresql.stream.flush", iOException);
        }
    }

    public void close() throws IOException {
        this.pg_output.close();
        this.pg_input.close();
        this.connection.close();
    }
}

