/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.Hashtable;
import org.postgresql.util.PSQLException;

public class Encoding {
    private static final Encoding DEFAULT_ENCODING = new Encoding(null);
    private static final Hashtable encodings = new Hashtable();
    private final String encoding;

    private Encoding(String string) {
        this.encoding = string;
    }

    public static Encoding getEncoding(String string, String string2) {
        if (string2 != null) {
            if (Encoding.isAvailable(string2)) {
                return new Encoding(string2);
            }
            return Encoding.defaultEncoding();
        }
        return Encoding.encodingForDatabaseEncoding(string);
    }

    private static Encoding encodingForDatabaseEncoding(String string) {
        if (encodings.containsKey(string)) {
            String[] stringArray = (String[])encodings.get(string);
            int n = 0;
            while (n < stringArray.length) {
                if (Encoding.isAvailable(stringArray[n])) {
                    return new Encoding(stringArray[n]);
                }
                ++n;
            }
        }
        return Encoding.defaultEncoding();
    }

    public String name() {
        return this.encoding;
    }

    public byte[] encode(String string) throws SQLException {
        try {
            if (this.encoding == null) {
                return string.getBytes();
            }
            return string.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new PSQLException("postgresql.stream.encoding", unsupportedEncodingException);
        }
    }

    public String decode(byte[] byArray, int n, int n2) throws SQLException {
        try {
            if (this.encoding == null) {
                return new String(byArray, n, n2);
            }
            return new String(byArray, n, n2, this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new PSQLException("postgresql.stream.encoding", unsupportedEncodingException);
        }
    }

    public String decode(byte[] byArray) throws SQLException {
        return this.decode(byArray, 0, byArray.length);
    }

    public Reader getDecodingReader(InputStream inputStream) throws SQLException {
        try {
            if (this.encoding == null) {
                return new InputStreamReader(inputStream);
            }
            return new InputStreamReader(inputStream, this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new PSQLException("postgresql.res.encoding", unsupportedEncodingException);
        }
    }

    public static Encoding defaultEncoding() {
        return DEFAULT_ENCODING;
    }

    private static boolean isAvailable(String string) {
        try {
            "DUMMY".getBytes(string);
            return true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
    }

    static {
        encodings.put("SQL_ASCII", new String[]{"ASCII", "us-ascii"});
        encodings.put("UNICODE", new String[]{"UTF-8", "UTF8"});
        encodings.put("LATIN1", new String[]{"ISO8859_1"});
        encodings.put("LATIN2", new String[]{"ISO8859_2"});
        encodings.put("LATIN3", new String[]{"ISO8859_3"});
        encodings.put("LATIN4", new String[]{"ISO8859_4"});
        encodings.put("ISO_8859_5", new String[]{"ISO8859_5"});
        encodings.put("ISO_8859_6", new String[]{"ISO8859_6"});
        encodings.put("ISO_8859_7", new String[]{"ISO8859_7"});
        encodings.put("ISO_8859_8", new String[]{"ISO8859_8"});
        encodings.put("LATIN5", new String[]{"ISO8859_9"});
        encodings.put("LATIN7", new String[]{"ISO8859_13"});
        encodings.put("LATIN9", new String[]{"ISO8859_15_FDIS"});
        encodings.put("EUC_JP", new String[]{"EUC_JP"});
        encodings.put("EUC_CN", new String[]{"EUC_CN"});
        encodings.put("EUC_KR", new String[]{"EUC_KR"});
        encodings.put("EUC_TW", new String[]{"EUC_TW"});
        encodings.put("SJIS", new String[]{"SJIS"});
        encodings.put("BIG5", new String[]{"Big5"});
        encodings.put("WIN1250", new String[]{"Cp1250"});
        encodings.put("WIN", new String[]{"Cp1251"});
        encodings.put("ALT", new String[]{"Cp866"});
        encodings.put("KOI8", new String[]{"KOI8_U", "KOI8_R"});
        encodings.put("UNKNOWN", new String[0]);
        encodings.put("MULE_INTERNAL", new String[0]);
        encodings.put("LATIN6", new String[0]);
        encodings.put("LATIN8", new String[0]);
        encodings.put("LATIN10", new String[0]);
    }
}

