/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.fastpath;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import org.postgresql.Connection;
import org.postgresql.PG_Stream;
import org.postgresql.fastpath.FastpathArg;
import org.postgresql.util.PSQLException;

public class Fastpath {
    protected Hashtable func = new Hashtable();
    protected Connection conn;
    protected PG_Stream stream;

    public Fastpath(Connection connection, PG_Stream pG_Stream) {
        this.conn = connection;
        this.stream = pG_Stream;
    }

    public Object fastpath(int n, boolean bl, FastpathArg[] fastpathArgArray) throws SQLException {
        PG_Stream pG_Stream = this.stream;
        synchronized (pG_Stream) {
            int n2;
            try {
                this.stream.SendInteger(70, 1);
                this.stream.SendInteger(0, 1);
                this.stream.SendInteger(n, 4);
                this.stream.SendInteger(fastpathArgArray.length, 4);
                int n3 = 0;
                while (n3 < fastpathArgArray.length) {
                    fastpathArgArray[n3].send(this.stream);
                    ++n3;
                }
                this.stream.flush();
            }
            catch (IOException iOException) {
                throw new PSQLException("postgresql.fp.send", new Integer(n), (Object)iOException);
            }
            Object object = null;
            block14: while (true) {
                n2 = this.stream.ReceiveChar();
                switch (n2) {
                    case 86: {
                        continue block14;
                    }
                    case 71: {
                        int n4 = this.stream.ReceiveIntegerR(4);
                        if (bl) {
                            object = new Integer(this.stream.ReceiveIntegerR(n4));
                            continue block14;
                        }
                        byte[] byArray = new byte[n4];
                        this.stream.Receive(byArray, 0, n4);
                        object = byArray;
                        continue block14;
                    }
                    case 69: {
                        throw new PSQLException("postgresql.fp.error", (Object)this.stream.ReceiveString(this.conn.getEncoding()));
                    }
                    case 78: {
                        this.conn.addWarning(this.stream.ReceiveString(this.conn.getEncoding()));
                        continue block14;
                    }
                    case 48: {
                        byte[] byArray = object;
                        return byArray;
                    }
                    case 90: {
                        continue block14;
                    }
                }
                break;
            }
            throw new PSQLException("postgresql.fp.protocol", new Character((char)n2));
        }
    }

    public Object fastpath(String string, boolean bl, FastpathArg[] fastpathArgArray) throws SQLException {
        return this.fastpath(this.getID(string), bl, fastpathArgArray);
    }

    public int getInteger(String string, FastpathArg[] fastpathArgArray) throws SQLException {
        Integer n = (Integer)this.fastpath(string, true, fastpathArgArray);
        if (n == null) {
            throw new PSQLException("postgresql.fp.expint", (Object)string);
        }
        return n;
    }

    public byte[] getData(String string, FastpathArg[] fastpathArgArray) throws SQLException {
        return (byte[])this.fastpath(string, false, fastpathArgArray);
    }

    public void addFunction(String string, int n) {
        this.func.put(string, new Integer(n));
    }

    public void addFunctions(ResultSet resultSet) throws SQLException {
        while (resultSet.next()) {
            this.func.put(resultSet.getString(1), new Integer(resultSet.getInt(2)));
        }
    }

    public int getID(String string) throws SQLException {
        Integer n = (Integer)this.func.get(string);
        if (n == null) {
            throw new PSQLException("postgresql.fp.unknown", (Object)string);
        }
        return n;
    }
}

