/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.Field;
import org.postgresql.ResultSet;
import org.postgresql.jdbc2.Connection;
import org.postgresql.util.PSQLException;

public class DatabaseMetaData
implements java.sql.DatabaseMetaData {
    Connection connection;
    static final int iVarcharOid = 1043;
    static final int iBoolOid = 16;
    static final int iInt2Oid = 21;
    static final int iInt4Oid = 23;
    static final int VARHDRSZ = 4;
    private static final String[][] getTableTypes = new String[][]{{"TABLE", "(relkind='r' and relhasrules='f' and relname !~ '^pg_' and relname !~ '^xinv')"}, {"VIEW", "(relkind='v' and relname !~ '^pg_')"}, {"INDEX", "(relkind='i' and relname !~ '^pg_')"}, {"SEQUENCE", "(relkind='S' and relname !~ '^pg_')"}, {"SYSTEM TABLE", "(relkind='r' and relname ~ '^pg_')"}, {"SYSTEM INDEX", "(relkind='i' and relname ~ '^pg_')"}};
    private static final String[] defaultTableTypes = new String[]{"TABLE", "VIEW", "INDEX", "SEQUENCE"};

    public DatabaseMetaData(Connection connection) {
        this.connection = connection;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        Driver.debug("allProceduresAreCallable");
        return true;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        Driver.debug("allTablesAreSelectable");
        return true;
    }

    public String getURL() throws SQLException {
        String string = this.connection.getURL();
        Driver.debug("getURL " + string);
        return string;
    }

    public String getUserName() throws SQLException {
        String string = this.connection.getUserName();
        Driver.debug("getUserName " + string);
        return string;
    }

    public boolean isReadOnly() throws SQLException {
        boolean bl = this.connection.isReadOnly();
        Driver.debug("isReadOnly " + bl);
        return bl;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        boolean bl = this.connection.haveMinimumServerVersion("7.2");
        Driver.debug("nullsAreSortedHigh " + bl);
        return bl;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        Driver.debug("nullsAreSortedLow false");
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        Driver.debug("nullsAreSortedAtStart false");
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        boolean bl = !this.connection.haveMinimumServerVersion("7.2");
        Driver.debug("nullsAreSortedAtEnd " + bl);
        return bl;
    }

    public String getDatabaseProductName() throws SQLException {
        Driver.debug("getDatabaseProductName PostgresSQL");
        return "PostgreSQL";
    }

    public String getDatabaseProductVersion() throws SQLException {
        String string = this.connection.getDBVersionNumber();
        Driver.debug("getDatabaseProductVersion " + string);
        return string;
    }

    public String getDriverName() throws SQLException {
        String string = "PostgreSQL Native Driver";
        Driver.debug("getDriverName" + string);
        return string;
    }

    public String getDriverVersion() throws SQLException {
        String string = Driver.getVersion();
        Driver.debug("getDriverVersion " + string);
        return string;
    }

    public int getDriverMajorVersion() {
        int n = this.connection.this_driver.getMajorVersion();
        Driver.debug("getMajorVersion " + n);
        return n;
    }

    public int getDriverMinorVersion() {
        int n = this.connection.this_driver.getMinorVersion();
        Driver.debug("getMinorVersion " + n);
        return n;
    }

    public boolean usesLocalFiles() throws SQLException {
        Driver.debug("usesLocalFiles false");
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        Driver.debug("usesLocalFilePerTable false");
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        Driver.debug("supportsMixedCaseIdentifiers false");
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        Driver.debug("storesUpperCaseIdentifiers false");
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        Driver.debug("storesLowerCaseIdentifiers true");
        return true;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        Driver.debug("storesMixedCaseIdentifiers false");
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        Driver.debug("supportsMixedCaseQuotedIdentifiers true");
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        Driver.debug("storesUpperCaseQuotedIdentifiers false");
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        Driver.debug("storesLowerCaseQuotedIdentifiers false");
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        Driver.debug("storesMixedCaseQuotedIdentifiers false");
        return false;
    }

    public String getIdentifierQuoteString() throws SQLException {
        Driver.debug("getIdentifierQuoteString \"");
        return "\"";
    }

    public String getSQLKeywords() throws SQLException {
        Driver.debug("getSQLKeyWords");
        return "abort,acl,add,aggregate,append,archive,arch_store,backward,binary,change,cluster,copy,database,delimiters,do,extend,explain,forward,heavy,index,inherits,isnull,light,listen,load,merge,nothing,notify,notnull,oids,purge,rename,replace,retrieve,returns,rule,recipe,setof,stdin,stdout,store,vacuum,verbose,version";
    }

    public String getNumericFunctions() throws SQLException {
        Driver.debug("getNumericFunctions");
        return "";
    }

    public String getStringFunctions() throws SQLException {
        Driver.debug("getStringFunctions");
        return "";
    }

    public String getSystemFunctions() throws SQLException {
        Driver.debug("getSystemFunctions");
        return "";
    }

    public String getTimeDateFunctions() throws SQLException {
        Driver.debug("getTimeDateFunctions");
        return "";
    }

    public String getSearchStringEscape() throws SQLException {
        Driver.debug("getSearchStringEscape");
        return "\\";
    }

    public String getExtraNameCharacters() throws SQLException {
        Driver.debug("getExtraNameCharacters");
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        Driver.debug("supportsAlterTableWithAddColumn true");
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        Driver.debug("supportsAlterTableWithDropColumn false");
        return false;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        Driver.debug("supportsColumnAliasing true");
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        Driver.debug("nullPlusNonNullIsNull true");
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        Driver.debug("supportsConvert false");
        return false;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        Driver.debug("supportsConvert false");
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        Driver.debug("supportsTableCorrelationNames true");
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        Driver.debug("supportsDifferentTableCorrelationNames false");
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        Driver.debug("supportsExpressionsInOrderBy true");
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        boolean bl = this.connection.haveMinimumServerVersion("6.4");
        Driver.debug("supportsOrderByUnrelated " + bl);
        return bl;
    }

    public boolean supportsGroupBy() throws SQLException {
        Driver.debug("supportsGroupBy true");
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        boolean bl = this.connection.haveMinimumServerVersion("6.4");
        Driver.debug("supportsGroupByUnrelated " + bl);
        return bl;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        boolean bl = this.connection.haveMinimumServerVersion("6.4");
        Driver.debug("supportsGroupByUnrelated " + bl);
        return bl;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        boolean bl = this.connection.haveMinimumServerVersion("7.1");
        Driver.debug("supportsLikeEscapeClause " + bl);
        return bl;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        Driver.debug("supportsMultipleResultSets false");
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        Driver.debug("supportsMultipleTransactions true");
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        Driver.debug("supportsNonNullableColumns true");
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        Driver.debug("supportsMinimumSQLGrammar TRUE");
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        Driver.debug("supportsCoreSQLGrammar FALSE ");
        return false;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        Driver.debug("supportsExtendedSQLGrammar FALSE");
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        Driver.debug("supportsANSI92EntryLevelSQL false ");
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        Driver.debug("supportsANSI92IntermediateSQL false ");
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        Driver.debug("supportsANSI92FullSQL false ");
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        Driver.debug("supportsIntegrityEnhancementFacility false ");
        return false;
    }

    public boolean supportsOuterJoins() throws SQLException {
        boolean bl = this.connection.haveMinimumServerVersion("7.1");
        Driver.debug("supportsOuterJoins " + bl);
        return bl;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        boolean bl = this.connection.haveMinimumServerVersion("7.1");
        Driver.debug("supportsFullOuterJoins " + bl);
        return bl;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        boolean bl = this.connection.haveMinimumServerVersion("7.1");
        Driver.debug("supportsFullOuterJoins " + bl);
        return bl;
    }

    public String getSchemaTerm() throws SQLException {
        Driver.debug("getSchemaTerm schema");
        return "schema";
    }

    public String getProcedureTerm() throws SQLException {
        Driver.debug("getProcedureTerm function ");
        return "function";
    }

    public String getCatalogTerm() throws SQLException {
        Driver.debug("getCatalogTerm database ");
        return "database";
    }

    public boolean isCatalogAtStart() throws SQLException {
        Driver.debug("isCatalogAtStart not implemented");
        return true;
    }

    public String getCatalogSeparator() throws SQLException {
        Driver.debug("getCatalogSeparator not implemented ");
        return ".";
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        Driver.debug("supportsSchemasInDataManipulation false");
        return false;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        Driver.debug("supportsSchemasInProcedureCalls false");
        return false;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        Driver.debug("supportsSchemasInTableDefinitions false");
        return false;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        Driver.debug("supportsSchemasInIndexDefinitions false");
        return false;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        Driver.debug("supportsSchemasInPrivilegeDefinitions false");
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        Driver.debug("supportsCatalogsInDataManipulation false");
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        Driver.debug("supportsCatalogsInDataManipulation false");
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        Driver.debug("supportsCatalogsInTableDefinitions false");
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        Driver.debug("supportsCatalogsInIndexDefinitions false");
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        Driver.debug("supportsCatalogsInPrivilegeDefinitions false");
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        Driver.debug("supportsPositionedDelete false");
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        Driver.debug("supportsPositionedUpdate false");
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return this.connection.haveMinimumServerVersion("6.5");
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return this.connection.haveMinimumServerVersion("7.1");
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return this.connection.haveMinimumServerVersion("7.1");
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 32;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return this.getMaxColumnsInTable();
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 1600;
    }

    public int getMaxConnections() throws SQLException {
        return 8192;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 32;
    }

    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 32;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    public int getMaxRowSize() throws SQLException {
        if (this.connection.haveMinimumServerVersion("7.1")) {
            return 0x40000000;
        }
        return 8192;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    public int getMaxStatementLength() throws SQLException {
        if (this.connection.haveMinimumServerVersion("7.0")) {
            return 0;
        }
        return 16384;
    }

    public int getMaxStatements() throws SQLException {
        return 1;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 32;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 32;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        return n == 8 || n == 2;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return true;
    }

    public java.sql.ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        Field[] fieldArray = new Field[8];
        Vector<byte[][]> vector = new Vector<byte[][]>();
        fieldArray[0] = new Field(this.connection, "PROCEDURE_CAT", 1043, 32);
        fieldArray[1] = new Field(this.connection, "PROCEDURE_SCHEM", 1043, 32);
        fieldArray[2] = new Field(this.connection, "PROCEDURE_NAME", 1043, 32);
        fieldArray[4] = fieldArray[5] = new Field(this.connection, "reserved", 1043, 32);
        fieldArray[3] = fieldArray[5];
        fieldArray[6] = new Field(this.connection, "REMARKS", 1043, 8192);
        fieldArray[7] = new Field(this.connection, "PROCEDURE_TYPE", 21, 2);
        if (string3 == null) {
            string3 = "%";
        }
        java.sql.ResultSet resultSet = this.connection.ExecSQL("select proname, proretset from pg_proc where proname like '" + string3.toLowerCase() + "' order by proname");
        while (resultSet.next()) {
            byte[][] byArray = new byte[8][0];
            byArray[0] = null;
            byArray[1] = null;
            byArray[2] = resultSet.getBytes(1);
            byArray[5] = null;
            byArray[4] = null;
            byArray[3] = null;
            byArray[6] = null;
            byArray[7] = resultSet.getBoolean(2) ? Integer.toString(2).getBytes() : Integer.toString(1).getBytes();
            vector.addElement(byArray);
        }
        return new org.postgresql.jdbc2.ResultSet(this.connection, fieldArray, vector, "OK", 1);
    }

    public java.sql.ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        if (string3 == null) {
            string3 = "%";
        }
        if (string4 == null) {
            string4 = "%";
        }
        Field[] fieldArray = new Field[13];
        Vector vector = new Vector();
        fieldArray[0] = new Field(this.connection, "PROCEDURE_CAT", 1043, 32);
        fieldArray[1] = new Field(this.connection, "PROCEDURE_SCHEM", 1043, 32);
        fieldArray[2] = new Field(this.connection, "PROCEDURE_NAME", 1043, 32);
        fieldArray[3] = new Field(this.connection, "COLUMN_NAME", 1043, 32);
        fieldArray[4] = new Field(this.connection, "COLUMN_TYPE", 21, 2);
        fieldArray[5] = new Field(this.connection, "DATA_TYPE", 21, 2);
        fieldArray[6] = new Field(this.connection, "TYPE_NAME", 1043, 32);
        fieldArray[7] = new Field(this.connection, "PRECISION", 23, 4);
        fieldArray[8] = new Field(this.connection, "LENGTH", 23, 4);
        fieldArray[9] = new Field(this.connection, "SCALE", 21, 2);
        fieldArray[10] = new Field(this.connection, "RADIX", 21, 2);
        fieldArray[11] = new Field(this.connection, "NULLABLE", 21, 2);
        fieldArray[12] = new Field(this.connection, "REMARKS", 1043, 32);
        return new org.postgresql.jdbc2.ResultSet(this.connection, fieldArray, vector, "OK", 1);
    }

    public java.sql.ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        if (stringArray == null) {
            stringArray = defaultTableTypes;
        }
        if (string3 == null) {
            string3 = "%";
        }
        Field[] fieldArray = new Field[5];
        Vector<byte[][]> vector = new Vector<byte[][]>();
        fieldArray[0] = new Field(this.connection, "TABLE_CAT", 1043, 32);
        fieldArray[1] = new Field(this.connection, "TABLE_SCHEM", 1043, 32);
        fieldArray[2] = new Field(this.connection, "TABLE_NAME", 1043, 32);
        fieldArray[3] = new Field(this.connection, "TABLE_TYPE", 1043, 32);
        fieldArray[4] = new Field(this.connection, "REMARKS", 1043, 32);
        StringBuffer stringBuffer = new StringBuffer("select relname,oid,relkind from pg_class where (");
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (n2 < getTableTypes.length) {
                if (getTableTypes[n2][0].equals(stringArray[n])) {
                    if (bl) {
                        stringBuffer.append(" or ");
                    }
                    stringBuffer.append(getTableTypes[n2][1]);
                    bl = true;
                }
                ++n2;
            }
            ++n;
        }
        stringBuffer.append(") and relname like '");
        stringBuffer.append(string3.toLowerCase());
        stringBuffer.append("' order by relkind, relname");
        java.sql.ResultSet resultSet = this.connection.ExecSQL(stringBuffer.toString());
        while (resultSet.next()) {
            String string4;
            byte[][] byArray = new byte[5][0];
            String string5 = this.connection.haveMinimumServerVersion("7.2") ? "select obj_description(" + resultSet.getInt(2) + ",'pg_class')" : "select description from pg_description where objoid=" + resultSet.getInt(2);
            java.sql.ResultSet resultSet2 = this.connection.ExecSQL(string5);
            byte[] byArray2 = null;
            if (((ResultSet)((Object)resultSet2)).getTupleCount() == 1) {
                resultSet2.next();
                byArray2 = resultSet2.getBytes(1);
            }
            resultSet2.close();
            switch (resultSet.getBytes(3)[0]) {
                case 114: {
                    string4 = "TABLE";
                    break;
                }
                case 105: {
                    string4 = "INDEX";
                    break;
                }
                case 83: {
                    string4 = "SEQUENCE";
                    break;
                }
                case 118: {
                    string4 = "VIEW";
                    break;
                }
                default: {
                    string4 = null;
                }
            }
            byArray[0] = null;
            byArray[1] = null;
            byArray[2] = resultSet.getBytes(1);
            byArray[3] = string4 == null ? null : string4.getBytes();
            byArray[4] = byArray2;
            vector.addElement(byArray);
        }
        resultSet.close();
        return new org.postgresql.jdbc2.ResultSet(this.connection, fieldArray, vector, "OK", 1);
    }

    public java.sql.ResultSet getSchemas() throws SQLException {
        Field[] fieldArray = new Field[1];
        Vector<byte[][]> vector = new Vector<byte[][]>();
        byte[][] byArray = new byte[1][0];
        fieldArray[0] = new Field(this.connection, "TABLE_SCHEM", 1043, 32);
        byArray[0] = "".getBytes();
        vector.addElement(byArray);
        return new org.postgresql.jdbc2.ResultSet(this.connection, fieldArray, vector, "OK", 1);
    }

    public java.sql.ResultSet getCatalogs() throws SQLException {
        return this.connection.createStatement().executeQuery("select datname as TABLE_CAT from pg_database;");
    }

    public java.sql.ResultSet getTableTypes() throws SQLException {
        Field[] fieldArray = new Field[1];
        Vector<byte[][]> vector = new Vector<byte[][]>();
        fieldArray[0] = new Field(this.connection, new String("TABLE_TYPE"), 1043, 32);
        int n = 0;
        while (n < getTableTypes.length) {
            byte[][] byArray = new byte[2][0];
            byArray[0] = getTableTypes[n][0].getBytes();
            vector.addElement(byArray);
            ++n;
        }
        return new org.postgresql.jdbc2.ResultSet(this.connection, fieldArray, vector, "OK", 1);
    }

    public java.sql.ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        Vector<byte[][]> vector = new Vector<byte[][]>();
        Field[] fieldArray = new Field[]{new Field(this.connection, "TABLE_CAT", 1043, 32), new Field(this.connection, "TABLE_SCHEM", 1043, 32), new Field(this.connection, "TABLE_NAME", 1043, 32), new Field(this.connection, "COLUMN_NAME", 1043, 32), new Field(this.connection, "DATA_TYPE", 21, 2), new Field(this.connection, "TYPE_NAME", 1043, 32), new Field(this.connection, "COLUMN_SIZE", 23, 4), new Field(this.connection, "BUFFER_LENGTH", 1043, 32), new Field(this.connection, "DECIMAL_DIGITS", 23, 4), new Field(this.connection, "NUM_PREC_RADIX", 23, 4), new Field(this.connection, "NULLABLE", 23, 4), new Field(this.connection, "REMARKS", 1043, 32), new Field(this.connection, "COLUMN_DEF", 1043, 32), new Field(this.connection, "SQL_DATA_TYPE", 23, 4), new Field(this.connection, "SQL_DATETIME_SUB", 23, 4), new Field(this.connection, "CHAR_OCTET_LENGTH", 1043, 32), new Field(this.connection, "ORDINAL_POSITION", 23, 4), new Field(this.connection, "IS_NULLABLE", 1043, 32)};
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append("select " + (this.connection.haveMinimumServerVersion("7.2") ? "a.attrelid, " : "a.oid, ") + "    c.relname, " + "    a.attname, " + "    a.atttypid, " + "    a.attnum, " + "    a.attnotnull, " + "    a.attlen, " + "    a.atttypmod, " + "    d.adsrc, " + "    t.typname, " + (this.connection.haveMinimumServerVersion("7.2") ? "col_description(a.attrelid, a.attnum) " : "e.description ") + "from" + "    (" + "        (pg_class c inner join pg_attribute a on" + "            (" + "                a.attrelid=c.oid");
        if (string3 != null && !string3.equals("%")) {
            stringBuffer.append("                and c.relname like '" + string3 + "'");
        }
        if (string4 != null && !string4.equals("%")) {
            stringBuffer.append("                and a.attname like '" + string4 + "'");
        }
        stringBuffer.append("                and a.attnum > 0            )        ) inner join pg_type t on            (                t.oid = a.atttypid            )    )    left outer join pg_attrdef d on        (            c.oid = d.adrelid            and a.attnum = d.adnum        ) ");
        if (!this.connection.haveMinimumServerVersion("7.2")) {
            stringBuffer.append("    left outer join pg_description e on        (            e.objoid = a.oid        ) ");
        }
        stringBuffer.append("order by    c.relname, a.attnum");
        java.sql.ResultSet resultSet = this.connection.ExecSQL(stringBuffer.toString());
        while (resultSet.next()) {
            int n;
            byte[][] byArray = new byte[18][0];
            String string5 = resultSet.getString(6);
            String string6 = resultSet.getString(10);
            byArray[0] = null;
            byArray[1] = null;
            byArray[2] = resultSet.getBytes(2);
            byArray[3] = resultSet.getBytes(3);
            byArray[4] = Integer.toString(this.connection.getSQLType(string6)).getBytes();
            byArray[5] = string6.getBytes();
            byArray[6] = string6.equals("bpchar") || string6.equals("varchar") ? Integer.toString((n = resultSet.getInt(8)) != -1 ? n - 4 : 0).getBytes() : resultSet.getBytes(7);
            byArray[7] = null;
            if (string6.equals("numeric") || string6.equals("decimal")) {
                n = resultSet.getInt(8);
                byArray[8] = Integer.toString(n - 4 & 0xFFFF).getBytes();
            } else {
                byArray[8] = "0".getBytes();
            }
            byArray[9] = "10".getBytes();
            byArray[10] = Integer.toString(string5.equals("f") ? 1 : 0).getBytes();
            byArray[11] = resultSet.getBytes(11);
            byArray[12] = resultSet.getBytes(9);
            byArray[13] = null;
            byArray[14] = null;
            byArray[15] = byArray[6];
            byArray[16] = resultSet.getBytes(5);
            byArray[17] = (string5.equals("f") ? "YES" : "NO").getBytes();
            vector.addElement(byArray);
        }
        resultSet.close();
        return new org.postgresql.jdbc2.ResultSet(this.connection, fieldArray, vector, "OK", 1);
    }

    public java.sql.ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        Field[] fieldArray = new Field[8];
        Vector vector = new Vector();
        if (string3 == null) {
            string3 = "%";
        }
        string4 = string4 == null ? "%" : string4.toLowerCase();
        fieldArray[0] = new Field(this.connection, "TABLE_CAT", 1043, 32);
        fieldArray[1] = new Field(this.connection, "TABLE_SCHEM", 1043, 32);
        fieldArray[2] = new Field(this.connection, "TABLE_NAME", 1043, 32);
        fieldArray[3] = new Field(this.connection, "COLUMN_NAME", 1043, 32);
        fieldArray[4] = new Field(this.connection, "GRANTOR", 1043, 32);
        fieldArray[5] = new Field(this.connection, "GRANTEE", 1043, 32);
        fieldArray[6] = new Field(this.connection, "PRIVILEGE", 1043, 32);
        fieldArray[7] = new Field(this.connection, "IS_GRANTABLE", 1043, 32);
        java.sql.ResultSet resultSet = this.connection.ExecSQL("SELECT relname, relacl FROM pg_class, pg_user WHERE ( relkind = 'r' OR relkind = 'i') and relname !~ '^pg_' and relname !~ '^xin[vx][0-9]+' and usesysid = relowner and relname like '" + string3.toLowerCase() + "' ORDER BY relname");
        while (resultSet.next()) {
            byte[][] byArray = new byte[8][0];
            byArray[1] = "".getBytes();
            byArray[0] = byArray[1];
            DriverManager.println("relname=\"" + resultSet.getString(1) + "\" relacl=\"" + resultSet.getString(2) + "\"");
        }
        return new org.postgresql.jdbc2.ResultSet(this.connection, fieldArray, vector, "OK", 1);
    }

    public java.sql.ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        Field[] fieldArray = new Field[8];
        Vector vector = new Vector();
        if (string3 == null) {
            string3 = "%";
        }
        fieldArray[0] = new Field(this.connection, "TABLE_CAT", 1043, 32);
        fieldArray[1] = new Field(this.connection, "TABLE_SCHEM", 1043, 32);
        fieldArray[2] = new Field(this.connection, "TABLE_NAME", 1043, 32);
        fieldArray[3] = new Field(this.connection, "COLUMN_NAME", 1043, 32);
        fieldArray[4] = new Field(this.connection, "GRANTOR", 1043, 32);
        fieldArray[5] = new Field(this.connection, "GRANTEE", 1043, 32);
        fieldArray[6] = new Field(this.connection, "PRIVILEGE", 1043, 32);
        fieldArray[7] = new Field(this.connection, "IS_GRANTABLE", 1043, 32);
        java.sql.ResultSet resultSet = this.connection.ExecSQL("SELECT relname, relacl FROM pg_class, pg_user WHERE ( relkind = 'r' OR relkind = 'i') and relname !~ '^pg_' and relname !~ '^xin[vx][0-9]+' and usesysid = relowner and relname like '" + string3.toLowerCase() + "' ORDER BY relname");
        while (resultSet.next()) {
            byte[][] byArray = new byte[8][0];
            byArray[1] = "".getBytes();
            byArray[0] = byArray[1];
            DriverManager.println("relname=\"" + resultSet.getString(1) + "\" relacl=\"" + resultSet.getString(2) + "\"");
        }
        return new org.postgresql.jdbc2.ResultSet(this.connection, fieldArray, vector, "OK", 1);
    }

    public java.sql.ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        Field[] fieldArray = new Field[8];
        Vector vector = new Vector();
        fieldArray[0] = new Field(this.connection, "SCOPE", 21, 2);
        fieldArray[1] = new Field(this.connection, "COLUMN_NAME", 1043, 32);
        fieldArray[2] = new Field(this.connection, "DATA_TYPE", 21, 2);
        fieldArray[3] = new Field(this.connection, "TYPE_NAME", 1043, 32);
        fieldArray[4] = new Field(this.connection, "COLUMN_SIZE", 23, 4);
        fieldArray[5] = new Field(this.connection, "BUFFER_LENGTH", 23, 4);
        fieldArray[6] = new Field(this.connection, "DECIMAL_DIGITS", 21, 2);
        fieldArray[7] = new Field(this.connection, "PSEUDO_COLUMN", 21, 2);
        return new org.postgresql.jdbc2.ResultSet(this.connection, fieldArray, vector, "OK", 1);
    }

    public java.sql.ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        throw Driver.notImplemented();
    }

    public java.sql.ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        return this.connection.createStatement().executeQuery("SELECT '' as TABLE_CAT,'' AS TABLE_SCHEM,bc.relname AS TABLE_NAME,a.attname AS COLUMN_NAME,a.attnum as KEY_SEQ,ic.relname as PK_NAME  FROM pg_class bc, pg_class ic, pg_index i, pg_attribute a WHERE bc.relkind = 'r'   and upper(bc.relname) = upper('" + string3 + "')" + "  and i.indrelid = bc.oid" + "  and i.indexrelid = ic.oid" + "  and ic.oid = a.attrelid" + "  and i.indisprimary='t' " + " ORDER BY table_name, pk_name, key_seq");
    }

    private java.sql.ResultSet getImportedExportedKeys(String string, String string2, String string3, String string4) throws SQLException {
        Field[] fieldArray = new Field[]{new Field(this.connection, "PKTABLE_CAT", 1043, 32), new Field(this.connection, "PKTABLE_SCHEM", 1043, 32), new Field(this.connection, "PKTABLE_NAME", 1043, 32), new Field(this.connection, "PKCOLUMN_NAME", 1043, 32), new Field(this.connection, "FKTABLE_CAT", 1043, 32), new Field(this.connection, "FKTABLE_SCHEM", 1043, 32), new Field(this.connection, "FKTABLE_NAME", 1043, 32), new Field(this.connection, "FKCOLUMN_NAME", 1043, 32), new Field(this.connection, "KEY_SEQ", 21, 2), new Field(this.connection, "UPDATE_RULE", 21, 2), new Field(this.connection, "DELETE_RULE", 21, 2), new Field(this.connection, "FK_NAME", 1043, 32), new Field(this.connection, "PK_NAME", 1043, 32), new Field(this.connection, "DEFERRABILITY", 21, 2)};
        java.sql.ResultSet resultSet = this.connection.ExecSQL("SELECT c.relname,c2.relname,t.tgconstrname,ic.relname,t.tgdeferrable,t.tginitdeferred,t.tgnargs,t.tgargs,p.proname FROM pg_trigger t,pg_class c,pg_class c2,pg_class ic,pg_proc p, pg_index i WHERE t.tgrelid=c.oid AND t.tgconstrrelid=c2.oid AND t.tgfoid=p.oid AND tgisconstraint " + (string3 != null ? "AND c.relname='" + string3 + "' " : "") + (string4 != null ? "AND c2.relname='" + string4 + "' " : "") + "AND i.indrelid=c.oid " + "AND i.indexrelid=ic.oid AND i.indisprimary " + "ORDER BY c.relname,c2.relname");
        Vector<byte[][]> vector = new Vector<byte[][]>();
        int n = 0;
        if (resultSet.next()) {
            boolean bl;
            do {
                byte[][] byArray = new byte[14][0];
                int n2 = 0;
                while (n2 < 14) {
                    byArray[n2] = null;
                    ++n2;
                }
                String string5 = resultSet.getString(3);
                boolean bl2 = false;
                do {
                    int n3;
                    String string6;
                    if ((string6 = resultSet.getString(9)) == null || !string6.startsWith("RI_FKey_")) continue;
                    int n4 = -1;
                    if (string6.endsWith("_upd")) {
                        n4 = 9;
                    } else if (string6.endsWith("_del")) {
                        n4 = 10;
                    }
                    if (n4 <= -1) continue;
                    String string7 = string6.substring(8, string6.length() - 4);
                    int n5 = 3;
                    if ("cascade".equals(string7)) {
                        n5 = 0;
                    } else if ("setnull".equals(string7)) {
                        n5 = 2;
                    } else if ("setdefault".equals(string7)) {
                        n5 = 4;
                    }
                    byArray[n4] = Integer.toString(n5).getBytes();
                    if (bl2) continue;
                    byArray[2] = resultSet.getBytes(1);
                    byArray[6] = resultSet.getBytes(2);
                    StringBuffer stringBuffer = new StringBuffer();
                    StringBuffer stringBuffer2 = new StringBuffer();
                    int n6 = (resultSet.getInt(7) >> 1) - 2;
                    String string8 = resultSet.getString(8);
                    int n7 = string8.lastIndexOf("\\000");
                    int n8 = 0;
                    while (n8 < n6) {
                        if (n7 > -1 && (n3 = string8.lastIndexOf("\\000", n7 - 1)) > -1) {
                            if (stringBuffer2.length() > 0) {
                                stringBuffer2.insert(0, ',');
                            }
                            stringBuffer2.insert(0, string8.substring(n3 + 4, n7));
                            n7 = string8.lastIndexOf("\\000", n3 - 1);
                            if (n7 > -1) {
                                if (stringBuffer.length() > 0) {
                                    stringBuffer.insert(0, ',');
                                }
                                stringBuffer.insert(0, string8.substring(n7 + 4, n3));
                            }
                        }
                        ++n8;
                    }
                    byArray[3] = stringBuffer2.toString().getBytes();
                    byArray[7] = stringBuffer.toString().getBytes();
                    int n9 = n;
                    n = (short)(n + 1);
                    byArray[8] = Integer.toString(n9).getBytes();
                    byArray[11] = string5.getBytes();
                    byArray[12] = resultSet.getBytes(4);
                    n3 = 7;
                    boolean bl3 = resultSet.getBoolean(5);
                    boolean bl4 = resultSet.getBoolean(6);
                    if (bl3) {
                        n3 = bl4 ? 5 : 6;
                    }
                    byArray[13] = Integer.toString(n3).getBytes();
                    bl2 = true;
                } while ((bl = resultSet.next()) && string5.equals(resultSet.getString(3)));
                if (!bl2) continue;
                vector.addElement(byArray);
            } while (bl);
        }
        return new org.postgresql.jdbc2.ResultSet(this.connection, fieldArray, vector, "OK", 1);
    }

    public java.sql.ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        return this.getImportedExportedKeys(string, string2, null, string3);
    }

    public java.sql.ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        return this.getImportedExportedKeys(string, string2, string3, null);
    }

    public java.sql.ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        return this.getImportedExportedKeys(string, string2, string3, string6);
    }

    public java.sql.ResultSet getTypeInfo() throws SQLException {
        java.sql.ResultSet resultSet = this.connection.ExecSQL("select typname from pg_type");
        if (resultSet != null) {
            Field[] fieldArray = new Field[18];
            Vector<byte[][]> vector = new Vector<byte[][]>();
            fieldArray[0] = new Field(this.connection, "TYPE_NAME", 1043, 32);
            fieldArray[1] = new Field(this.connection, "DATA_TYPE", 21, 2);
            fieldArray[2] = new Field(this.connection, "PRECISION", 23, 4);
            fieldArray[3] = new Field(this.connection, "LITERAL_PREFIX", 1043, 32);
            fieldArray[4] = new Field(this.connection, "LITERAL_SUFFIX", 1043, 32);
            fieldArray[5] = new Field(this.connection, "CREATE_PARAMS", 1043, 32);
            fieldArray[6] = new Field(this.connection, "NULLABLE", 21, 2);
            fieldArray[7] = new Field(this.connection, "CASE_SENSITIVE", 16, 1);
            fieldArray[8] = new Field(this.connection, "SEARCHABLE", 21, 2);
            fieldArray[9] = new Field(this.connection, "UNSIGNED_ATTRIBUTE", 16, 1);
            fieldArray[10] = new Field(this.connection, "FIXED_PREC_SCALE", 16, 1);
            fieldArray[11] = new Field(this.connection, "AUTO_INCREMENT", 16, 1);
            fieldArray[12] = new Field(this.connection, "LOCAL_TYPE_NAME", 1043, 32);
            fieldArray[13] = new Field(this.connection, "MINIMUM_SCALE", 21, 2);
            fieldArray[14] = new Field(this.connection, "MAXIMUM_SCALE", 21, 2);
            fieldArray[15] = new Field(this.connection, "SQL_DATA_TYPE", 23, 4);
            fieldArray[16] = new Field(this.connection, "SQL_DATETIME_SUB", 23, 4);
            fieldArray[17] = new Field(this.connection, "NUM_PREC_RADIX", 23, 4);
            byte[] byArray = "9".getBytes();
            byte[] byArray2 = "10".getBytes();
            byte[] byArray3 = "f".getBytes();
            byte[] byArray4 = Integer.toString(0).getBytes();
            byte[] byArray5 = Integer.toString(3).getBytes();
            while (resultSet.next()) {
                byte[][] byArrayArray = new byte[18][];
                String string = resultSet.getString(1);
                byArrayArray[0] = string.getBytes();
                byArrayArray[1] = Integer.toString(this.connection.getSQLType(string)).getBytes();
                byArrayArray[2] = byArray;
                byArrayArray[6] = byArray4;
                byArrayArray[7] = byArray3;
                byArrayArray[8] = byArray5;
                byArrayArray[9] = byArray3;
                byArrayArray[10] = byArray3;
                byArrayArray[11] = byArray3;
                byArrayArray[17] = byArray2;
                vector.addElement(byArrayArray);
            }
            resultSet.close();
            return new org.postgresql.jdbc2.ResultSet(this.connection, fieldArray, vector, "OK", 1);
        }
        throw new PSQLException("postgresql.metadata.unavailable");
    }

    public java.sql.ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        Field[] fieldArray = new Field[13];
        Vector<byte[][]> vector = new Vector<byte[][]>();
        fieldArray[0] = new Field(this.connection, "TABLE_CAT", 1043, 32);
        fieldArray[1] = new Field(this.connection, "TABLE_SCHEM", 1043, 32);
        fieldArray[2] = new Field(this.connection, "TABLE_NAME", 1043, 32);
        fieldArray[3] = new Field(this.connection, "NON_UNIQUE", 16, 1);
        fieldArray[4] = new Field(this.connection, "INDEX_QUALIFIER", 1043, 32);
        fieldArray[5] = new Field(this.connection, "INDEX_NAME", 1043, 32);
        fieldArray[6] = new Field(this.connection, "TYPE", 21, 2);
        fieldArray[7] = new Field(this.connection, "ORDINAL_POSITION", 21, 2);
        fieldArray[8] = new Field(this.connection, "COLUMN_NAME", 1043, 32);
        fieldArray[9] = new Field(this.connection, "ASC_OR_DESC", 1043, 32);
        fieldArray[10] = new Field(this.connection, "CARDINALITY", 23, 4);
        fieldArray[11] = new Field(this.connection, "PAGES", 23, 4);
        fieldArray[12] = new Field(this.connection, "FILTER_CONDITION", 1043, 32);
        java.sql.ResultSet resultSet = this.connection.ExecSQL("select c.relname, x.indisunique, i.relname, x.indisclustered, a.amname, x.indkey, c.reltuples, c.relpages, x.indexrelid FROM pg_index x, pg_class c, pg_class i, pg_am a WHERE ((c.relname = '" + string3.toLowerCase() + "') " + " AND (c.oid = x.indrelid) " + " AND (i.oid = x.indexrelid) " + " AND (i.relam = a.oid)) " + "ORDER BY x.indisunique DESC, " + " x.indisclustered, a.amname, i.relname");
        while (resultSet.next()) {
            String string4 = resultSet.getString(6);
            StringTokenizer stringTokenizer = new StringTokenizer(string4);
            int[] nArray = new int[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                nArray[n++] = Integer.parseInt(stringTokenizer.nextToken());
            }
            int n2 = 0;
            while (n2 < nArray.length) {
                byte[][] byArrayArray = new byte[13][];
                byArrayArray[0] = "".getBytes();
                byArrayArray[1] = "".getBytes();
                byArrayArray[2] = resultSet.getBytes(1);
                byArrayArray[3] = resultSet.getBoolean(2) ? "false".getBytes() : "true".getBytes();
                byArrayArray[4] = null;
                byArrayArray[5] = resultSet.getBytes(3);
                byArrayArray[6] = resultSet.getBoolean(4) ? Integer.toString(1).getBytes() : (resultSet.getString(5).equals("hash") ? Integer.toString(2).getBytes() : Integer.toString(3).getBytes());
                byArrayArray[7] = Integer.toString(n2 + 1).getBytes();
                java.sql.ResultSet resultSet2 = this.connection.ExecSQL("select a.attname FROM pg_attribute a WHERE (a.attnum = " + nArray[n2] + ") AND (a.attrelid = " + resultSet.getInt(9) + ")");
                byArrayArray[8] = resultSet2.next() ? resultSet2.getBytes(1) : "".getBytes();
                byArrayArray[8] = resultSet2.getBytes(1);
                byArrayArray[9] = null;
                byArrayArray[10] = resultSet.getBytes(7);
                byArrayArray[11] = resultSet.getBytes(8);
                byArrayArray[12] = null;
                vector.addElement(byArrayArray);
                ++n2;
            }
        }
        return new org.postgresql.jdbc2.ResultSet(this.connection, fieldArray, vector, "OK", 1);
    }

    public boolean supportsResultSetType(int n) throws SQLException {
        return n != 1005;
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        if (n == 1005) {
            return false;
        }
        return n2 != 1008;
    }

    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean ownInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean insertsAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public java.sql.ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        throw Driver.notImplemented();
    }

    public java.sql.Connection getConnection() throws SQLException {
        return this.connection;
    }

    public boolean rowChangesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean rowChangesAreVisible(int n) throws SQLException {
        return false;
    }
}

