/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageTranslator {
    private static MessageTranslator instance = null;
    private ResourceBundle bundle;

    private MessageTranslator() {
        try {
            this.bundle = ResourceBundle.getBundle("org.postgresql.errors");
        }
        catch (MissingResourceException missingResourceException) {
            this.bundle = null;
        }
    }

    private static final synchronized MessageTranslator getInstance() {
        if (instance == null) {
            instance = new MessageTranslator();
        }
        return instance;
    }

    public static final String translate(String string, Object[] objectArray) {
        MessageTranslator messageTranslator = MessageTranslator.getInstance();
        return messageTranslator._translate(string, objectArray);
    }

    private final String _translate(String string, Object[] objectArray) {
        String string2;
        if (this.bundle != null && string != null) {
            try {
                string2 = this.bundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                string2 = string;
            }
        } else {
            string2 = string;
        }
        if (objectArray != null && string2 != null) {
            string2 = MessageFormat.format(string2, objectArray);
        }
        return string2;
    }
}

