/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.DOMElementWriter;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlLogger
implements BuildListener {
    private static final DocumentBuilder builder = XmlLogger.getDocumentBuilder();
    private static final String BUILD_TAG = "build";
    private static final String TARGET_TAG = "target";
    private static final String TASK_TAG = "task";
    private static final String MESSAGE_TAG = "message";
    private static final String NAME_ATTR = "name";
    private static final String TIME_ATTR = "time";
    private static final String PRIORITY_ATTR = "priority";
    private static final String LOCATION_ATTR = "location";
    private static final String ERROR_ATTR = "error";
    private Document doc;
    private Hashtable tasks = new Hashtable();
    private Hashtable targets = new Hashtable();
    private Hashtable threadStacks = new Hashtable();
    private TimedElement buildElement = null;

    public void buildFinished(BuildEvent buildEvent) {
        long l = System.currentTimeMillis() - this.buildElement.startTime;
        this.buildElement.element.setAttribute(TIME_ATTR, DefaultLogger.formatTime(l));
        if (buildEvent.getException() != null) {
            this.buildElement.element.setAttribute(ERROR_ATTR, buildEvent.getException().toString());
        }
        try {
            String string = buildEvent.getProject().getProperty("XmlLogger.file");
            if (string == null) {
                string = "log.xml";
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF8");
            outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
            outputStreamWriter.write("<?xml:stylesheet type=\"text/xsl\" href=\"log.xsl\"?>\n\n");
            new DOMElementWriter().write(this.buildElement.element, outputStreamWriter, 0, "\t");
            ((Writer)outputStreamWriter).flush();
            ((Writer)outputStreamWriter).close();
        }
        catch (IOException iOException) {
            throw new BuildException("Unable to close log file", iOException);
        }
        this.buildElement = null;
    }

    public void buildStarted(BuildEvent buildEvent) {
        this.buildElement = new TimedElement();
        this.buildElement.startTime = System.currentTimeMillis();
        this.doc = builder.newDocument();
        this.buildElement.element = this.doc.createElement(BUILD_TAG);
    }

    private static DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }

    private Stack getStack() {
        Stack stack = (Stack)this.threadStacks.get(Thread.currentThread());
        if (stack == null) {
            stack = new Stack();
            this.threadStacks.put(Thread.currentThread(), stack);
        }
        return stack;
    }

    public void messageLogged(BuildEvent buildEvent) {
        Stack stack;
        Element element = this.doc.createElement(MESSAGE_TAG);
        String string = "debug";
        switch (buildEvent.getPriority()) {
            case 0: {
                string = ERROR_ATTR;
                break;
            }
            case 1: {
                string = "warn";
                break;
            }
            case 2: {
                string = "info";
                break;
            }
            default: {
                string = "debug";
            }
        }
        element.setAttribute(PRIORITY_ATTR, string);
        CDATASection cDATASection = this.doc.createCDATASection(buildEvent.getMessage());
        element.appendChild(cDATASection);
        TimedElement timedElement = null;
        Task task = buildEvent.getTask();
        Target target = buildEvent.getTarget();
        if (task != null) {
            timedElement = (TimedElement)this.tasks.get(task);
        }
        if (timedElement == null && target != null) {
            timedElement = (TimedElement)this.targets.get(target);
        }
        if (timedElement == null && (stack = (Stack)this.threadStacks.get(Thread.currentThread())) != null && !stack.empty()) {
            timedElement = (TimedElement)stack.peek();
        }
        if (timedElement != null) {
            timedElement.element.appendChild(element);
        } else {
            this.buildElement.element.appendChild(element);
        }
    }

    public void targetFinished(BuildEvent buildEvent) {
        Target target = buildEvent.getTarget();
        TimedElement timedElement = (TimedElement)this.targets.get(target);
        if (timedElement != null) {
            long l = System.currentTimeMillis() - timedElement.startTime;
            timedElement.element.setAttribute(TIME_ATTR, DefaultLogger.formatTime(l));
            TimedElement timedElement2 = null;
            Stack stack = this.getStack();
            if (!stack.empty()) {
                TimedElement timedElement3 = (TimedElement)stack.pop();
                if (timedElement3 != timedElement) {
                    throw new RuntimeException("Mismatch - popped element = " + timedElement3.element + " finished task element = " + timedElement.element);
                }
                if (!stack.empty()) {
                    timedElement2 = (TimedElement)stack.peek();
                }
            }
            if (timedElement2 == null) {
                this.buildElement.element.appendChild(timedElement.element);
            } else {
                timedElement2.element.appendChild(timedElement.element);
            }
        }
    }

    public void targetStarted(BuildEvent buildEvent) {
        Target target = buildEvent.getTarget();
        TimedElement timedElement = new TimedElement();
        timedElement.startTime = System.currentTimeMillis();
        timedElement.element = this.doc.createElement(TARGET_TAG);
        timedElement.element.setAttribute(NAME_ATTR, target.getName());
        this.targets.put(target, timedElement);
        this.getStack().push(timedElement);
    }

    public void taskFinished(BuildEvent buildEvent) {
        Task task = buildEvent.getTask();
        TimedElement timedElement = (TimedElement)this.tasks.get(task);
        if (timedElement != null) {
            TimedElement timedElement2;
            long l = System.currentTimeMillis() - timedElement.startTime;
            timedElement.element.setAttribute(TIME_ATTR, DefaultLogger.formatTime(l));
            Target target = task.getOwningTarget();
            TimedElement timedElement3 = (TimedElement)this.targets.get(target);
            if (timedElement3 == null) {
                this.buildElement.element.appendChild(timedElement.element);
            } else {
                timedElement3.element.appendChild(timedElement.element);
            }
            Stack stack = this.getStack();
            if (!stack.empty() && (timedElement2 = (TimedElement)stack.pop()) != timedElement) {
                throw new RuntimeException("Mismatch - popped element = " + timedElement2.element + " finished task element = " + timedElement.element);
            }
        }
    }

    public void taskStarted(BuildEvent buildEvent) {
        Task task = buildEvent.getTask();
        TimedElement timedElement = new TimedElement();
        timedElement.startTime = System.currentTimeMillis();
        timedElement.element = this.doc.createElement(TASK_TAG);
        String string = buildEvent.getTask().getTaskName();
        timedElement.element.setAttribute(NAME_ATTR, string);
        timedElement.element.setAttribute(LOCATION_ATTR, buildEvent.getTask().getLocation().toString());
        this.tasks.put(task, timedElement);
        this.getStack().push(timedElement);
    }

    private static class TimedElement {
        long startTime;
        Element element;

        TimedElement() {
        }
    }
}

