/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.FlatFileNameMapper;
import org.apache.tools.ant.util.IdentityMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class Copy
extends Task {
    protected File file = null;
    protected File destFile = null;
    protected File destDir = null;
    protected Vector filesets = new Vector();
    protected boolean filtering = false;
    protected boolean preserveLastModified = false;
    protected boolean forceOverwrite = false;
    protected boolean flatten = false;
    protected int verbosity = 3;
    protected boolean includeEmpty = true;
    protected Hashtable fileCopyMap = new Hashtable();
    protected Hashtable dirCopyMap = new Hashtable();
    protected Mapper mapperElement = null;
    private Vector filterSets = new Vector();
    private FileUtils fileUtils = FileUtils.newFileUtils();

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    protected void buildMap(File file, File file2, String[] stringArray, FileNameMapper fileNameMapper, Hashtable hashtable) {
        Object object;
        Object[] objectArray = null;
        if (this.forceOverwrite) {
            object = new Vector();
            int n = 0;
            while (n < stringArray.length) {
                if (fileNameMapper.mapFileName(stringArray[n]) != null) {
                    ((Vector)object).addElement(stringArray[n]);
                }
                ++n;
            }
            objectArray = new String[((Vector)object).size()];
            ((Vector)object).copyInto(objectArray);
        } else {
            object = new SourceFileScanner(this);
            objectArray = ((SourceFileScanner)object).restrict(stringArray, file, file2, fileNameMapper);
        }
        int n = 0;
        while (n < objectArray.length) {
            File file3 = new File(file, (String)objectArray[n]);
            File file4 = new File(file2, fileNameMapper.mapFileName((String)objectArray[n])[0]);
            hashtable.put(file3.getAbsolutePath(), file4.getAbsolutePath());
            ++n;
        }
    }

    public FilterSet createFilterSet() {
        FilterSet filterSet = new FilterSet();
        this.filterSets.addElement(filterSet);
        return filterSet;
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.location);
        }
        this.mapperElement = new Mapper(this.project);
        return this.mapperElement;
    }

    protected void doFileOperations() {
        Object object;
        Enumeration<Object> enumeration;
        if (this.fileCopyMap.size() > 0) {
            this.log("Copying " + this.fileCopyMap.size() + " file" + (this.fileCopyMap.size() == 1 ? "" : "s") + " to " + this.destDir.getAbsolutePath());
            enumeration = this.fileCopyMap.keys();
            while (enumeration.hasMoreElements()) {
                Object object2;
                String string = (String)enumeration.nextElement();
                if (string.equals(object = (String)this.fileCopyMap.get(string))) {
                    this.log("Skipping self-copy of " + string, this.verbosity);
                    continue;
                }
                try {
                    this.log("Copying " + string + " to " + (String)object, this.verbosity);
                    FilterSetCollection filterSetCollection = new FilterSetCollection();
                    if (this.filtering) {
                        filterSetCollection.addFilterSet(this.project.getGlobalFilterSet());
                    }
                    object2 = this.filterSets.elements();
                    while (object2.hasMoreElements()) {
                        filterSetCollection.addFilterSet((FilterSet)object2.nextElement());
                    }
                    this.fileUtils.copyFile(string, (String)object, filterSetCollection, this.forceOverwrite, this.preserveLastModified);
                }
                catch (IOException iOException) {
                    object2 = "Failed to copy " + string + " to " + (String)object + " due to " + iOException.getMessage();
                    throw new BuildException((String)object2, iOException, this.location);
                }
            }
        }
        if (this.includeEmpty) {
            enumeration = this.dirCopyMap.elements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                object = new File((String)enumeration.nextElement());
                if (((File)object).exists()) continue;
                if (!((File)object).mkdirs()) {
                    this.log("Unable to create directory " + ((File)object).getAbsolutePath(), 0);
                    continue;
                }
                ++n;
            }
            if (n > 0) {
                this.log("Copied " + n + " empty director" + (n == 1 ? "y" : "ies") + " to " + this.destDir.getAbsolutePath());
            }
        }
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        if (this.file != null) {
            if (this.file.exists()) {
                if (this.destFile == null) {
                    this.destFile = new File(this.destDir, this.file.getName());
                }
                if (this.forceOverwrite || this.file.lastModified() > this.destFile.lastModified()) {
                    this.fileCopyMap.put(this.file.getAbsolutePath(), this.destFile.getAbsolutePath());
                } else {
                    this.log(String.valueOf(String.valueOf(this.file)) + " omitted as " + this.destFile + " is up to date.", 3);
                }
            } else {
                String string = "Could not find file " + this.file.getAbsolutePath() + " to copy.";
                this.log(string);
                throw new BuildException(string);
            }
        }
        int n = 0;
        while (n < this.filesets.size()) {
            FileSet fileSet = (FileSet)this.filesets.elementAt(n);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.project);
            File file = fileSet.getDir(this.project);
            String[] stringArray = directoryScanner.getIncludedFiles();
            String[] stringArray2 = directoryScanner.getIncludedDirectories();
            this.scan(file, this.destDir, stringArray, stringArray2);
            ++n;
        }
        this.doFileOperations();
        if (this.destFile != null) {
            this.destDir = null;
        }
    }

    protected FileUtils getFileUtils() {
        return this.fileUtils;
    }

    protected Vector getFilterSets() {
        return this.filterSets;
    }

    protected void scan(File file, File file2, String[] stringArray, String[] stringArray2) {
        FileNameMapper fileNameMapper = null;
        fileNameMapper = this.mapperElement != null ? this.mapperElement.getImplementation() : (this.flatten ? new FlatFileNameMapper() : new IdentityMapper());
        this.buildMap(file, file2, stringArray, fileNameMapper, this.fileCopyMap);
        if (this.includeEmpty) {
            this.buildMap(file, file2, stringArray2, fileNameMapper, this.dirCopyMap);
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setFiltering(boolean bl) {
        this.filtering = bl;
    }

    public void setFlatten(boolean bl) {
        this.flatten = bl;
    }

    public void setIncludeEmptyDirs(boolean bl) {
        this.includeEmpty = bl;
    }

    public void setOverwrite(boolean bl) {
        this.forceOverwrite = bl;
    }

    public void setPreserveLastModified(String string) {
        this.preserveLastModified = Project.toBoolean(string);
    }

    public void setTodir(File file) {
        this.destDir = file;
    }

    public void setTofile(File file) {
        this.destFile = file;
    }

    public void setVerbose(boolean bl) {
        this.verbosity = bl ? 2 : 3;
    }

    protected void validateAttributes() throws BuildException {
        if (this.file == null && this.filesets.size() == 0) {
            throw new BuildException("Specify at least one source - a file or a fileset.");
        }
        if (this.destFile != null && this.destDir != null) {
            throw new BuildException("Only one of destfile and destdir may be set.");
        }
        if (this.destFile == null && this.destDir == null) {
            throw new BuildException("One of destfile or destdir must be set.");
        }
        if (this.file != null && this.file.exists() && this.file.isDirectory()) {
            throw new BuildException("Use a fileset to copy directories.");
        }
        if (this.destFile != null && this.filesets.size() > 0) {
            throw new BuildException("Cannot concatenate multple files into a single file.");
        }
        if (this.destFile != null) {
            this.destDir = new File(this.destFile.getParent());
        }
    }
}

