/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.Touch;

public class Expand
extends MatchingTask {
    private File dest;
    private File source;
    private boolean overwrite = true;

    public void execute() throws BuildException {
        if ("expand".equals(this.taskType)) {
            this.log("!! expand is deprecated. Use unzip instead. !!");
        }
        Touch touch = (Touch)this.project.createTask("touch");
        touch.setOwningTarget(this.target);
        touch.setTaskName(this.getTaskName());
        touch.setLocation(this.getLocation());
        if (this.source == null) {
            throw new BuildException("Source attribute must be specified");
        }
        if (this.dest == null) {
            throw new BuildException("Dest attribute must be specified");
        }
        if (this.source.isDirectory()) {
            DirectoryScanner directoryScanner = super.getDirectoryScanner(this.source);
            String[] stringArray = directoryScanner.getIncludedFiles();
            int n = 0;
            while (n < stringArray.length) {
                File file = new File(this.source, stringArray[n]);
                this.expandFile(touch, file, this.dest);
                ++n;
            }
        } else {
            this.expandFile(touch, this.source, this.dest);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void expandFile(Touch touch, File file, File file2) {
        ZipInputStream zipInputStream = null;
        try {
            try {
                this.log("Expanding: " + file + " into " + file2, 2);
                zipInputStream = new ZipInputStream(new FileInputStream(file));
                ZipEntry zipEntry = null;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    File file3 = new File(file2, Project.translatePath(zipEntry.getName()));
                    try {
                        if (!this.overwrite && file3.exists() && file3.lastModified() >= zipEntry.getTime()) {
                            this.log("Skipping " + file3 + " as it is up-to-date", 4);
                            continue;
                        }
                        this.log("expanding " + zipEntry.getName() + " to " + file3, 3);
                        File file4 = new File(file3.getParent());
                        file4.mkdirs();
                        if (zipEntry.isDirectory()) {
                            file3.mkdirs();
                        } else {
                            byte[] byArray = new byte[1024];
                            int n = 0;
                            FileOutputStream fileOutputStream = new FileOutputStream(file3);
                            while ((n = zipInputStream.read(byArray)) >= 0) {
                                fileOutputStream.write(byArray, 0, n);
                            }
                            fileOutputStream.close();
                        }
                        if (Project.getJavaVersion() == "1.1") continue;
                        touch.setFile(file3);
                        touch.setMillis(zipEntry.getTime());
                        touch.touch();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.log("Unable to expand to file " + file3.getPath(), 1);
                    }
                }
                this.log("expand complete", 3);
            }
            catch (IOException iOException) {
                throw new BuildException("Error while expanding " + file.getPath(), iOException);
            }
            Object var6_12 = null;
            if (zipInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_13 = null;
            if (zipInputStream == null) throw throwable;
            try {
                zipInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            zipInputStream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public void setDest(File file) {
        this.dest = file;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    public void setSrc(File file) {
        this.source = file;
    }
}

