/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class PathConvert
extends Task {
    private Path path = null;
    private Reference refid = null;
    private String targetOS = null;
    private boolean targetWindows = false;
    private boolean onWindows = false;
    private String property = null;
    private Vector prefixMap = new Vector();
    private String pathSep = null;
    private String dirSep = null;

    public MapEntry createMap() {
        MapEntry mapEntry = new MapEntry();
        this.prefixMap.addElement(mapEntry);
        return mapEntry;
    }

    public Path createPath() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.path == null) {
            this.path = new Path(this.getProject());
        }
        return this.path.createPath();
    }

    public void execute() throws BuildException {
        String string;
        Object object;
        if (this.isReference()) {
            this.path = new Path(this.getProject()).createPath();
            object = this.refid.getReferencedObject(this.getProject());
            if (object instanceof Path) {
                this.path.setRefid(this.refid);
            } else if (object instanceof FileSet) {
                FileSet fileSet = (FileSet)object;
                this.path.addFileset(fileSet);
            } else {
                throw new BuildException("'refid' does not refer to a path or fileset");
            }
        }
        this.validateSetup();
        object = System.getProperty("os.name").toLowerCase();
        this.onWindows = ((String)object).indexOf("windows") >= 0;
        char c = this.onWindows ? (char)'\\' : '/';
        char c2 = this.dirSep.charAt(0);
        StringBuffer stringBuffer = new StringBuffer(100);
        String[] stringArray = this.path.list();
        int n = 0;
        while (n < stringArray.length) {
            string = stringArray[n];
            string = this.mapElement(string);
            string = string.replace(c, c2);
            if (n != 0) {
                stringBuffer.append(this.pathSep);
            }
            stringBuffer.append(string);
            ++n;
        }
        string = stringBuffer.toString();
        this.log("Set property " + this.property + " = " + string, 3);
        this.getProject().setProperty(this.property, string);
    }

    public boolean isReference() {
        return this.refid != null;
    }

    private String mapElement(String string) {
        int n = this.prefixMap.size();
        if (n != 0) {
            int n2 = 0;
            while (n2 < n) {
                MapEntry mapEntry = (MapEntry)this.prefixMap.elementAt(n2);
                String string2 = mapEntry.apply(string);
                if (string2 != string) {
                    string = string2;
                    break;
                }
                ++n2;
            }
        }
        return string;
    }

    private BuildException noChildrenAllowed() {
        return new BuildException("You must not specify nested PATH elements when using refid");
    }

    public void setDirSep(String string) {
        this.dirSep = string;
    }

    public void setPathSep(String string) {
        this.pathSep = string;
    }

    public void setProperty(String string) {
        this.property = string;
    }

    public void setRefid(Reference reference) {
        if (this.path != null) {
            throw this.noChildrenAllowed();
        }
        this.refid = reference;
    }

    public void setTargetos(String string) {
        this.targetOS = string.toLowerCase();
        if (!this.targetOS.equals("windows") && !string.equals("unix")) {
            throw new BuildException("targetos must be one of 'unix' or 'windows'");
        }
        this.targetWindows = this.targetOS.equals("windows");
    }

    private void validateSetup() throws BuildException {
        if (this.path == null) {
            throw new BuildException("You must specify a path to convert");
        }
        if (this.property == null) {
            throw new BuildException("You must specify a property");
        }
        if (this.targetOS == null && this.pathSep == null && this.dirSep == null) {
            throw new BuildException("You must specify at least one of targetOS, dirSep, or pathSep");
        }
        String string = File.separator;
        String string2 = File.pathSeparator;
        if (this.targetOS != null) {
            string2 = this.targetWindows ? ";" : ":";
            String string3 = string = this.targetWindows ? "\\" : "/";
        }
        if (this.pathSep != null) {
            string2 = this.pathSep;
        }
        if (this.dirSep != null) {
            string = this.dirSep;
        }
        this.pathSep = string2;
        this.dirSep = string;
    }

    public class MapEntry {
        private String from = null;
        private String to = null;

        public String apply(String string) {
            String string2;
            if (this.from == null || this.to == null) {
                throw new BuildException("Both 'from' and 'to' must be set in a map entry");
            }
            String string3 = PathConvert.this.onWindows ? string.toLowerCase() : string;
            String string4 = string2 = PathConvert.this.onWindows ? this.from.toLowerCase() : this.from;
            if (string3.startsWith(string2)) {
                int n = this.from.length();
                string = n >= string.length() ? this.to : String.valueOf(this.to) + string.substring(n);
            }
            return string;
        }

        public void setFrom(String string) {
            this.from = string;
        }

        public void setTo(String string) {
            this.to = string;
        }
    }
}

