/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Touch;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

public class Untar
extends Task {
    private File dest;
    private File source;
    private boolean overwrite = true;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws BuildException {
        Touch touch = (Touch)this.project.createTask("touch");
        touch.setOwningTarget(this.target);
        touch.setTaskName(this.getTaskName());
        touch.setLocation(this.getLocation());
        File file = this.source;
        TarInputStream tarInputStream = null;
        try {
            try {
                if (this.source == null) {
                    throw new BuildException("No source specified", this.location);
                }
                if (!file.exists()) {
                    throw new BuildException("source " + file + " doesn't exist", this.location);
                }
                if (this.dest == null) {
                    throw new BuildException("No destination specified", this.location);
                }
                File file2 = this.dest;
                this.log("Expanding: " + file + " into " + file2, 2);
                tarInputStream = new TarInputStream(new FileInputStream(file));
                TarEntry tarEntry = null;
                while ((tarEntry = tarInputStream.getNextEntry()) != null) {
                    try {
                        File file3 = new File(file2, Project.translatePath(tarEntry.getName()));
                        if (!this.overwrite && file3.exists() && file3.lastModified() >= tarEntry.getModTime().getTime()) {
                            this.log("Skipping " + file3 + " as it is up-to-date", 4);
                            continue;
                        }
                        this.log("expanding " + tarEntry.getName() + " to " + file3, 3);
                        File file4 = new File(file3.getParent());
                        file4.mkdirs();
                        if (tarEntry.isDirectory()) {
                            file3.mkdirs();
                        } else {
                            byte[] byArray = new byte[1024];
                            int n = 0;
                            FileOutputStream fileOutputStream = new FileOutputStream(file3);
                            while ((n = tarInputStream.read(byArray)) >= 0) {
                                fileOutputStream.write(byArray, 0, n);
                            }
                            fileOutputStream.close();
                        }
                        if (Project.getJavaVersion() == "1.1") continue;
                        touch.setFile(file3);
                        touch.setMillis(tarEntry.getModTime().getTime());
                        touch.touch();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.log("FileNotFoundException: " + tarEntry.getName(), 1);
                    }
                }
            }
            catch (IOException iOException) {
                throw new BuildException("Error while expanding " + file.getPath(), iOException, this.location);
            }
            Object var5_12 = null;
            if (tarInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_13 = null;
            if (tarInputStream == null) throw throwable;
            try {
                tarInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            tarInputStream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public void setDest(File file) {
        this.dest = file;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    public void setSrc(File file) {
        this.source = file;
    }
}

