/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.compilers;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapter;
import org.apache.tools.ant.taskdefs.compilers.Gcj;
import org.apache.tools.ant.taskdefs.compilers.Javac12;
import org.apache.tools.ant.taskdefs.compilers.Javac13;
import org.apache.tools.ant.taskdefs.compilers.JavacExternal;
import org.apache.tools.ant.taskdefs.compilers.Jikes;
import org.apache.tools.ant.taskdefs.compilers.Jvc;
import org.apache.tools.ant.taskdefs.compilers.Kjc;
import org.apache.tools.ant.taskdefs.compilers.Sj;

public class CompilerAdapterFactory {
    private CompilerAdapterFactory() {
    }

    public static CompilerAdapter getCompiler(String string, Task task) throws BuildException {
        if (string.equalsIgnoreCase("jikes")) {
            return new Jikes();
        }
        if (string.equalsIgnoreCase("extJavac")) {
            return new JavacExternal();
        }
        if (string.equalsIgnoreCase("classic") || string.equalsIgnoreCase("javac1.1") || string.equalsIgnoreCase("javac1.2")) {
            return new Javac12();
        }
        if (string.equalsIgnoreCase("modern") || string.equalsIgnoreCase("javac1.3") || string.equalsIgnoreCase("javac1.4")) {
            try {
                Class.forName("com.sun.tools.javac.Main");
            }
            catch (ClassNotFoundException classNotFoundException) {
                task.log("Modern compiler is not available - using classic compiler", 1);
                return new Javac12();
            }
            return new Javac13();
        }
        if (string.equalsIgnoreCase("jvc") || string.equalsIgnoreCase("microsoft")) {
            return new Jvc();
        }
        if (string.equalsIgnoreCase("kjc")) {
            return new Kjc();
        }
        if (string.equalsIgnoreCase("gcj")) {
            return new Gcj();
        }
        if (string.equalsIgnoreCase("sj") || string.equalsIgnoreCase("symantec")) {
            return new Sj();
        }
        return CompilerAdapterFactory.resolveClassName(string);
    }

    private static CompilerAdapter resolveClassName(String string) throws BuildException {
        try {
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.newInstance();
            return (CompilerAdapter)obj;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BuildException(String.valueOf(string) + " can't be found.", classNotFoundException);
        }
        catch (ClassCastException classCastException) {
            throw new BuildException(String.valueOf(string) + " isn't the classname of " + "a compiler adapter.", classCastException);
        }
        catch (Throwable throwable) {
            throw new BuildException(String.valueOf(string) + " caused an interesting " + "exception.", throwable);
        }
    }
}

