/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.rmic;

import java.io.File;
import java.util.Random;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Rmic;
import org.apache.tools.ant.taskdefs.rmic.RmicAdapter;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileNameMapper;

public abstract class DefaultRmicAdapter
implements RmicAdapter {
    private Rmic attributes;
    private FileNameMapper mapper;
    private static final Random rand = new Random();

    protected void addExtdirsToClasspath(Path path) {
        String[] stringArray;
        Path path2 = this.attributes.getExtdirs();
        if (path2 == null) {
            stringArray = System.getProperty("java.ext.dirs");
            if (stringArray != null) {
                path2 = new Path(this.attributes.getProject(), (String)stringArray);
            } else {
                return;
            }
        }
        stringArray = path2.list();
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].endsWith(File.separator)) {
                int n2 = n;
                stringArray[n2] = String.valueOf(stringArray[n2]) + File.separator;
            }
            File file = this.attributes.getProject().resolveFile(stringArray[n]);
            FileSet fileSet = new FileSet();
            fileSet.setDir(file);
            fileSet.setIncludes("*");
            path.addFileset(fileSet);
            ++n;
        }
    }

    public abstract boolean execute() throws BuildException;

    public Path getClasspath() {
        return this.getCompileClasspath();
    }

    protected Path getCompileClasspath() {
        Path path = new Path(this.attributes.getProject());
        path.setLocation(this.attributes.getBase());
        if (this.attributes.getClasspath() == null) {
            if (this.attributes.getIncludeantruntime()) {
                path.addExisting(Path.systemClasspath);
            }
        } else if (this.attributes.getIncludeantruntime()) {
            path.addExisting(this.attributes.getClasspath().concatSystemClasspath("last"));
        } else {
            path.addExisting(this.attributes.getClasspath().concatSystemClasspath("ignore"));
        }
        if (this.attributes.getIncludejavaruntime()) {
            if (System.getProperty("java.vendor").toLowerCase().indexOf("microsoft") >= 0) {
                FileSet fileSet = new FileSet();
                fileSet.setDir(new File(String.valueOf(System.getProperty("java.home")) + File.separator + "Packages"));
                fileSet.setIncludes("*.ZIP");
                path.addFileset(fileSet);
            } else if (Project.getJavaVersion() == "1.1") {
                path.addExisting(new Path(null, String.valueOf(System.getProperty("java.home")) + File.separator + "lib" + File.separator + "classes.zip"));
            } else if (System.getProperty("java.vm.name").equals("Kaffe")) {
                FileSet fileSet = new FileSet();
                fileSet.setDir(new File(String.valueOf(System.getProperty("java.home")) + File.separator + "share" + File.separator + "kaffe"));
                fileSet.setIncludes("*.jar");
                path.addFileset(fileSet);
            } else {
                path.addExisting(new Path(null, String.valueOf(System.getProperty("java.home")) + File.separator + "lib" + File.separator + "rt.jar"));
                path.addExisting(new Path(null, String.valueOf(System.getProperty("java.home")) + File.separator + "jre" + File.separator + "lib" + File.separator + "rt.jar"));
                path.addExisting(new Path(null, String.valueOf(System.getProperty("java.home")) + File.separator + ".." + File.separator + "Classes" + File.separator + "classes.jar"));
                path.addExisting(new Path(null, String.valueOf(System.getProperty("java.home")) + File.separator + ".." + File.separator + "Classes" + File.separator + "ui.jar"));
            }
        }
        return path;
    }

    public FileNameMapper getMapper() {
        return this.mapper;
    }

    public Rmic getRmic() {
        return this.attributes;
    }

    protected String getSkelClassSuffix() {
        return "_Skel";
    }

    protected String getStubClassSuffix() {
        return "_Stub";
    }

    protected String getTieClassSuffix() {
        return "_Tie";
    }

    protected void logAndAddFilesToCompile(Commandline commandline) {
        Vector vector = this.attributes.getCompileList();
        this.attributes.log("Compilation args: " + commandline.toString(), 3);
        StringBuffer stringBuffer = new StringBuffer("File");
        if (vector.size() != 1) {
            stringBuffer.append("s");
        }
        stringBuffer.append(" to be compiled:");
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            commandline.createArgument().setValue(string);
            stringBuffer.append("    " + string);
            ++n;
        }
        this.attributes.log(stringBuffer.toString(), 3);
    }

    public void setRmic(Rmic rmic) {
        this.attributes = rmic;
        this.mapper = new RmicFileNameMapper();
    }

    protected Commandline setupRmicCommand() {
        return this.setupRmicCommand(null);
    }

    protected Commandline setupRmicCommand(String[] stringArray) {
        Commandline commandline = new Commandline();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                commandline.createArgument().setValue(stringArray[n]);
                ++n;
            }
        }
        Path path = this.getCompileClasspath();
        commandline.createArgument().setValue("-d");
        commandline.createArgument().setFile(this.attributes.getBase());
        if (this.attributes.getExtdirs() != null) {
            if (Project.getJavaVersion().startsWith("1.1")) {
                this.addExtdirsToClasspath(path);
            } else {
                commandline.createArgument().setValue("-extdirs");
                commandline.createArgument().setPath(this.attributes.getExtdirs());
            }
        }
        commandline.createArgument().setValue("-classpath");
        commandline.createArgument().setPath(path);
        String string = this.attributes.getStubVersion();
        if (string != null) {
            if ("1.1".equals(string)) {
                commandline.createArgument().setValue("-v1.1");
            } else if ("1.2".equals(string)) {
                commandline.createArgument().setValue("-v1.2");
            } else {
                commandline.createArgument().setValue("-vcompat");
            }
        }
        if (this.attributes.getSourceBase() != null) {
            commandline.createArgument().setValue("-keepgenerated");
        }
        if (this.attributes.getIiop()) {
            this.attributes.log("IIOP has been turned on.", 2);
            commandline.createArgument().setValue("-iiop");
            if (this.attributes.getIiopopts() != null) {
                this.attributes.log("IIOP Options: " + this.attributes.getIiopopts(), 2);
                commandline.createArgument().setValue(this.attributes.getIiopopts());
            }
        }
        if (this.attributes.getIdl()) {
            commandline.createArgument().setValue("-idl");
            this.attributes.log("IDL has been turned on.", 2);
            if (this.attributes.getIdlopts() != null) {
                commandline.createArgument().setValue(this.attributes.getIdlopts());
                this.attributes.log("IDL Options: " + this.attributes.getIdlopts(), 2);
            }
        }
        if (this.attributes.getDebug()) {
            commandline.createArgument().setValue("-g");
        }
        this.logAndAddFilesToCompile(commandline);
        return commandline;
    }

    private class RmicFileNameMapper
    implements FileNameMapper {
        RmicFileNameMapper() {
        }

        public String[] mapFileName(String string) {
            String[] stringArray;
            block11: {
                String string2;
                String string3;
                block12: {
                    if (string == null || !string.endsWith(".class") || string.endsWith(String.valueOf(DefaultRmicAdapter.this.getStubClassSuffix()) + ".class") || string.endsWith(String.valueOf(DefaultRmicAdapter.this.getSkelClassSuffix()) + ".class") || string.endsWith(String.valueOf(DefaultRmicAdapter.this.getTieClassSuffix()) + ".class")) {
                        return null;
                    }
                    string3 = string.substring(0, string.indexOf(".class"));
                    string2 = string3.replace(File.separatorChar, '.');
                    if (DefaultRmicAdapter.this.attributes.getVerify() && !DefaultRmicAdapter.this.attributes.isValidRmiRemote(string2)) {
                        return null;
                    }
                    stringArray = new String[]{String.valueOf(string) + ".tmp." + rand.nextLong()};
                    if (DefaultRmicAdapter.this.attributes.getIiop() || DefaultRmicAdapter.this.attributes.getIdl()) break block12;
                    stringArray = "1.2".equals(DefaultRmicAdapter.this.attributes.getStubVersion()) ? new String[]{String.valueOf(string3) + DefaultRmicAdapter.this.getStubClassSuffix() + ".class"} : new String[]{String.valueOf(string3) + DefaultRmicAdapter.this.getStubClassSuffix() + ".class", String.valueOf(string3) + DefaultRmicAdapter.this.getSkelClassSuffix() + ".class"};
                    break block11;
                }
                if (DefaultRmicAdapter.this.attributes.getIdl()) break block11;
                int n = string3.lastIndexOf(File.separatorChar);
                String string4 = "";
                int n2 = -1;
                if (n == -1) {
                    n2 = 0;
                } else {
                    n2 = n + 1;
                    string4 = string3.substring(0, n2);
                }
                String string5 = string3.substring(n2);
                try {
                    Class<?> clazz = DefaultRmicAdapter.this.attributes.getLoader().loadClass(string2);
                    if (clazz.isInterface()) {
                        stringArray = new String[]{String.valueOf(string4) + "_" + string5 + DefaultRmicAdapter.this.getStubClassSuffix() + ".class"};
                        break block11;
                    }
                    Class clazz2 = DefaultRmicAdapter.this.attributes.getRemoteInterface(clazz);
                    String string6 = clazz2.getName();
                    String string7 = "";
                    int n3 = -1;
                    int n4 = string6.lastIndexOf(".");
                    if (n4 == -1) {
                        n3 = 0;
                    } else {
                        n3 = n4 + 1;
                        string7 = string6.substring(0, n3);
                        string7 = string7.replace('.', File.separatorChar);
                    }
                    stringArray = new String[]{String.valueOf(string4) + "_" + string5 + DefaultRmicAdapter.this.getTieClassSuffix() + ".class", String.valueOf(string7) + "_" + string6.substring(n3) + DefaultRmicAdapter.this.getStubClassSuffix() + ".class"};
                }
                catch (ClassNotFoundException classNotFoundException) {
                    DefaultRmicAdapter.this.attributes.log("Unable to verify class " + string2 + ". It could not be found.", 1);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    DefaultRmicAdapter.this.attributes.log("Unable to verify class " + string2 + ". It is not defined.", 1);
                }
                catch (Throwable throwable) {
                    DefaultRmicAdapter.this.attributes.log("Unable to verify class " + string2 + ". Loading caused Exception: " + throwable.getMessage(), 1);
                }
            }
            return stringArray;
        }

        public void setFrom(String string) {
        }

        public void setTo(String string) {
        }
    }
}

