/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;

public class Commandline
implements Cloneable {
    private Vector arguments = new Vector();
    private String executable = null;

    public Commandline() {
    }

    public Commandline(String string) {
        String[] stringArray = Commandline.translateCommandline(string);
        if (stringArray != null && stringArray.length > 0) {
            this.setExecutable(stringArray[0]);
            int n = 1;
            while (n < stringArray.length) {
                this.createArgument().setValue(stringArray[n]);
                ++n;
            }
        }
    }

    public void addArguments(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.createArgument().setValue(stringArray[n]);
            ++n;
        }
    }

    public void clear() {
        this.executable = null;
        this.arguments.removeAllElements();
    }

    public void clearArgs() {
        this.arguments.removeAllElements();
    }

    public Object clone() {
        Commandline commandline = new Commandline();
        commandline.setExecutable(this.executable);
        commandline.addArguments(this.getArguments());
        return commandline;
    }

    public Argument createArgument() {
        Argument argument = new Argument();
        this.arguments.addElement(argument);
        return argument;
    }

    public Marker createMarker() {
        return new Marker(this.arguments.size());
    }

    public String[] getArguments() {
        Object object;
        Vector<String> vector = new Vector<String>(this.arguments.size() * 2);
        int n = 0;
        while (n < this.arguments.size()) {
            object = (Argument)this.arguments.elementAt(n);
            String[] stringArray = ((Argument)object).getParts();
            int n2 = 0;
            while (n2 < stringArray.length) {
                vector.addElement(stringArray[n2]);
                ++n2;
            }
            ++n;
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public String[] getCommandline() {
        String[] stringArray = this.getArguments();
        if (this.executable == null) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = this.executable;
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return stringArray2;
    }

    public String getExecutable() {
        return this.executable;
    }

    public static String quoteArgument(String string) {
        if (string.indexOf("\"") > -1) {
            if (string.indexOf("'") > -1) {
                throw new BuildException("Can't handle single and double quotes in same argument");
            }
            return String.valueOf('\'') + string + '\'';
        }
        if (string.indexOf("'") > -1 || string.indexOf(" ") > -1) {
            return String.valueOf('\"') + string + '\"';
        }
        return string;
    }

    public void setExecutable(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.executable = string.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public int size() {
        return this.getCommandline().length;
    }

    public String toString() {
        return Commandline.toString(this.getCommandline());
    }

    public static String toString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(Commandline.quoteArgument(stringArray[n]));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String[] translateCommandline(String string) {
        Object[] objectArray;
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        boolean bl = false;
        boolean bl2 = true;
        int n = 2;
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\"' ", true);
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        block4: while (stringTokenizer.hasMoreTokens()) {
            objectArray = stringTokenizer.nextToken();
            switch (n2) {
                case 1: {
                    if ("'".equals(objectArray)) {
                        n2 = 0;
                        break;
                    }
                    stringBuffer.append((String)objectArray);
                    break;
                }
                case 2: {
                    if ("\"".equals(objectArray)) {
                        n2 = 0;
                        break;
                    }
                    stringBuffer.append((String)objectArray);
                    break;
                }
                default: {
                    if ("'".equals(objectArray)) {
                        n2 = 1;
                        break;
                    }
                    if ("\"".equals(objectArray)) {
                        n2 = 2;
                        break;
                    }
                    if (" ".equals(objectArray)) {
                        if (stringBuffer.length() == 0) continue block4;
                        vector.addElement(stringBuffer.toString());
                        stringBuffer.setLength(0);
                        break;
                    }
                    stringBuffer.append((String)objectArray);
                    break;
                }
            }
        }
        if (stringBuffer.length() != 0) {
            vector.addElement(stringBuffer.toString());
        }
        if (n2 == 1 || n2 == 2) {
            throw new BuildException("unbalanced quotes in " + string);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public class Argument {
        private String[] parts;

        public String[] getParts() {
            return this.parts;
        }

        public void setFile(File file) {
            this.parts = new String[]{file.getAbsolutePath()};
        }

        public void setLine(String string) {
            this.parts = Commandline.translateCommandline(string);
        }

        public void setPath(Path path) {
            this.parts = new String[]{path.toString()};
        }

        public void setValue(String string) {
            this.parts = new String[]{string};
        }
    }

    public class Marker {
        private int position;
        private int realPos = -1;

        Marker(int n) {
            this.position = n;
        }

        public int getPosition() {
            if (this.realPos == -1) {
                this.realPos = Commandline.this.executable == null ? 0 : 1;
                int n = 0;
                while (n < this.position) {
                    Argument argument = (Argument)Commandline.this.arguments.elementAt(n);
                    this.realPos += argument.getParts().length;
                    ++n;
                }
            }
            return this.realPos;
        }
    }
}

