/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;

public class CommandlineJava
implements Cloneable {
    private Commandline vmCommand = new Commandline();
    private Commandline javaCommand = new Commandline();
    private SysProperties sysProperties = new SysProperties();
    private Path classpath = null;
    private String vmVersion;
    private String maxMemory = null;
    private boolean executeJar = false;

    public CommandlineJava() {
        this.setVm(this.getJavaExecutableName());
        this.setVmversion(Project.getJavaVersion());
    }

    public void addSysproperty(Environment.Variable variable) {
        this.sysProperties.addVariable(variable);
    }

    public void clearJavaArgs() {
        this.javaCommand.clearArgs();
    }

    public Object clone() {
        CommandlineJava commandlineJava = new CommandlineJava();
        commandlineJava.vmCommand = (Commandline)this.vmCommand.clone();
        commandlineJava.javaCommand = (Commandline)this.javaCommand.clone();
        commandlineJava.sysProperties = (SysProperties)this.sysProperties.clone();
        commandlineJava.maxMemory = this.maxMemory;
        if (this.classpath != null) {
            commandlineJava.classpath = (Path)this.classpath.clone();
        }
        commandlineJava.vmVersion = this.vmVersion;
        commandlineJava.executeJar = this.executeJar;
        return commandlineJava;
    }

    public Commandline.Argument createArgument() {
        return this.javaCommand.createArgument();
    }

    public Path createClasspath(Project project) {
        if (this.classpath == null) {
            this.classpath = new Path(project);
        }
        return this.classpath;
    }

    public Commandline.Argument createVmArgument() {
        return this.vmCommand.createArgument();
    }

    private Commandline getActualVMCommand() {
        Commandline commandline = (Commandline)this.vmCommand.clone();
        if (this.maxMemory != null) {
            if (this.vmVersion.startsWith("1.1")) {
                commandline.createArgument().setValue("-mx" + this.maxMemory);
            } else {
                commandline.createArgument().setValue("-Xmx" + this.maxMemory);
            }
        }
        return commandline;
    }

    public String getClassname() {
        if (!this.executeJar) {
            return this.javaCommand.getExecutable();
        }
        return null;
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public String[] getCommandline() {
        Path path;
        String[] stringArray = new String[this.size()];
        int n = 0;
        String[] stringArray2 = this.getActualVMCommand().getCommandline();
        stringArray[n++] = stringArray2[0];
        if (this.executeJar) {
            stringArray[n++] = "-jar";
        }
        System.arraycopy(stringArray2, 1, stringArray, n, stringArray2.length - 1);
        n += stringArray2.length - 1;
        if (this.sysProperties.size() > 0) {
            System.arraycopy(this.sysProperties.getVariables(), 0, stringArray, n, this.sysProperties.size());
            n += this.sysProperties.size();
        }
        Path path2 = path = this.classpath != null ? this.classpath.concatSystemClasspath("ignore") : null;
        if (path != null && path.toString().trim().length() > 0) {
            stringArray[n++] = "-classpath";
            stringArray[n++] = path.toString();
        }
        System.arraycopy(this.javaCommand.getCommandline(), 0, stringArray, n, this.javaCommand.size());
        return stringArray;
    }

    public String getJar() {
        if (this.executeJar) {
            return this.javaCommand.getExecutable();
        }
        return null;
    }

    public Commandline getJavaCommand() {
        return this.javaCommand;
    }

    private String getJavaExecutableName() {
        String string = System.getProperty("os.name").toLowerCase();
        boolean bl = string.indexOf("windows") >= 0 || string.indexOf("os/2") >= 0;
        String string2 = bl ? ".exe" : "";
        File file = new File(String.valueOf(System.getProperty("java.home")) + "/../bin/java" + string2);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        return "java";
    }

    public SysProperties getSystemProperties() {
        return this.sysProperties;
    }

    public Commandline getVmCommand() {
        return this.getActualVMCommand();
    }

    public String getVmversion() {
        return this.vmVersion;
    }

    public void restoreSystemProperties() throws BuildException {
        this.sysProperties.restoreSystem();
    }

    public void setClassname(String string) {
        this.javaCommand.setExecutable(string);
        this.executeJar = false;
    }

    public void setJar(String string) {
        this.javaCommand.setExecutable(string);
        this.executeJar = true;
    }

    public void setMaxmemory(String string) {
        this.maxMemory = string;
    }

    public void setSystemProperties() throws BuildException {
        this.sysProperties.setSystem();
    }

    public void setVm(String string) {
        this.vmCommand.setExecutable(string);
    }

    public void setVmversion(String string) {
        this.vmVersion = string;
    }

    public int size() {
        Path path;
        int n = this.getActualVMCommand().size() + this.javaCommand.size() + this.sysProperties.size();
        Path path2 = path = this.classpath != null ? this.classpath.concatSystemClasspath("ignore") : null;
        if (path != null && path.toString().trim().length() > 0) {
            n += 2;
        }
        if (this.executeJar) {
            ++n;
        }
        return n;
    }

    public String toString() {
        return Commandline.toString(this.getCommandline());
    }

    public static class SysProperties
    extends Environment
    implements Cloneable {
        Properties sys = null;

        public Object clone() {
            try {
                SysProperties sysProperties = (SysProperties)super.clone();
                sysProperties.variables = (Vector)this.variables.clone();
                return sysProperties;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public String[] getVariables() throws BuildException {
            String[] stringArray = super.getVariables();
            if (stringArray == null) {
                return null;
            }
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = "-D" + stringArray[n];
                ++n;
            }
            return stringArray;
        }

        public void restoreSystem() throws BuildException {
            if (this.sys == null) {
                throw new BuildException("Unbalanced nesting of SysProperties");
            }
            try {
                System.setProperties(this.sys);
                this.sys = null;
            }
            catch (SecurityException securityException) {
                throw new BuildException("Cannot modify system properties", securityException);
            }
        }

        public void setSystem() throws BuildException {
            try {
                this.sys = System.getProperties();
                Properties properties = new Properties(this.sys);
                Enumeration enumeration = this.variables.elements();
                while (enumeration.hasMoreElements()) {
                    Environment.Variable variable = (Environment.Variable)enumeration.nextElement();
                    ((Hashtable)properties).put(variable.getKey(), variable.getValue());
                }
                System.setProperties(properties);
            }
            catch (SecurityException securityException) {
                throw new BuildException("Cannot modify system properties", securityException);
            }
        }

        public int size() {
            return this.variables.size();
        }
    }
}

