/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;

public class Environment {
    protected Vector variables = new Vector();

    public void addVariable(Variable variable) {
        this.variables.addElement(variable);
    }

    public String[] getVariables() throws BuildException {
        if (this.variables.size() == 0) {
            return null;
        }
        String[] stringArray = new String[this.variables.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = ((Variable)this.variables.elementAt(n)).getContent();
            ++n;
        }
        return stringArray;
    }

    public static class Variable {
        private String key;
        private String value;

        public String getContent() throws BuildException {
            if (this.key == null || this.value == null) {
                throw new BuildException("key and value must be specified for environment variables.");
            }
            StringBuffer stringBuffer = new StringBuffer(this.key.trim());
            stringBuffer.append("=").append(this.value.trim());
            return stringBuffer.toString();
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void setFile(File file) {
            this.value = file.getAbsolutePath();
        }

        public void setKey(String string) {
            this.key = string;
        }

        public void setPath(Path path) {
            this.value = path.toString();
        }

        public void setValue(String string) {
            this.value = string;
        }
    }
}

